
/*!
@file dkcArcfour.c
@brief RC4݊ASY arcfour
@auther d
*/

#include "dkcArcfour.h"
#include "dkcStdio.h"



DKC_ARCFOUR_STATE *WINAPI dkcAllocArcfour(
	const unsigned char *key,size_t keylen)
{

	int i,j;
	unsigned char temp;
	unsigned char *sb1,sb2[256];
	DKC_ARCFOUR_STATE *p;
	
	memset(sb2,0,sizeof(sb2));
	//allocate state struct
	p = dkcAllocate(sizeof(DKC_ARCFOUR_STATE));
	if(NULL==p){
		return NULL;
	}
	sb1 = p->msbox;
	
	//initialize
	for(i=0;i<256;i++){
		sb1[i] = (unsigned char)i;
		//kȂ悤(Ȃ񂩁AӖ̂HȂi@H
		//p->msbox2[i] = key [i % keylen];
	}
	j=i=0;
	
	for(;j<256;j++){
		sb2[j] = key [j % keylen];
	}


	for(i=0;i<256;i++){
		//j = (j + sb1 [i] + sb2 [i]) % 256;
		j = (j + sb1[i] + sb2[i]) & 0xff;
		temp = sb1 [i];
		sb1 [i] = sb1 [j];
		sb1 [j] = temp;
		/*sb1[i] = sb1[j] - sb1[i] ;
    sb1[j] -= sb1[i] ;
    sb1[i] += sb1[j] ;*/
	//SWAP_NUM(sb1[i],sb1[j]);
	}
	return p;
}

DKC_EXTERN unsigned char WINAPI dkcArcfourByte(DKC_ARCFOUR_STATE *p){
  unsigned char i,j,temp;
  unsigned char *sb1 = p->msbox;
  
  //calc
  i = (unsigned char )(p->mi+1);// % 256;
  j = (unsigned char )(p->mj + sb1[i]);// % 256;
  
	 //swap
  temp = sb1 [i];
  sb1 [i] = sb1 [j];
  sb1 [j] = temp;

  //SWAP_NUM(sb1[i],sb1[j]);
  //refresh
  p->mi = i;
  p->mj = j;
  //calc
  i = (unsigned char )(sb1 [i] + sb1 [j]);// % 256;
  j = (unsigned char )sb1[i];
  return j;
}

static DKC_INLINE void dkcArcfourEncrypt_Base(DKC_ARCFOUR_STATE *p,
	unsigned char *dest,unsigned const char *src,size_t srcsize)
{

	size_t cc;
  unsigned char i,j;
  unsigned char *sb1 = p->msbox;
	unsigned char temp;
  
 	 //calc
	i = (unsigned char )(p->mi);
	j = (unsigned char )(p->mj);

	for(cc = 0;cc < srcsize;cc++){
		 	 //calc
		i = (unsigned char )(i+1);
		j = (unsigned char )(j + sb1[i]);
  
		 //swap
		
		temp = sb1 [i];
		sb1 [i] = sb1 [j];
		sb1 [j] = temp;
		

		//SWAP_NUM_EX(sb1[i],sb1[j],unsigned char);

		//calc
		dest[cc] = (unsigned char )
			(src[cc] ^ (unsigned char )sb1[
				(unsigned char )(sb1 [i] + sb1 [j]) 
			] 
		);
	}
	//refresh
	p->mi = i;
	p->mj = j;

}

int WINAPI dkcArcfourEncrypt(DKC_ARCFOUR_STATE *p,
	unsigned char *dest,size_t destsize,
	const unsigned char *src,size_t srcsize)
{
	//size_t i=0;
	if(destsize < srcsize){
		return edk_BufferOverFlow;
	}
	dkcArcfourEncrypt_Base(p,dest,src,srcsize);

	/*for(i = 0;i < srcsize;i++){
		dest[i] = (unsigned char )(src[i] ^ dkcArcfourByte(p) );
	}*/

	return edk_SUCCEEDED;
}



void WINAPI dkcArcfourEncryptNoDest(DKC_ARCFOUR_STATE *p,
	unsigned char *dest_and_src,size_t dest_and_srcsize)
{
	dkcArcfourEncrypt_Base(p,dest_and_src,dest_and_src,dest_and_srcsize);
}

int WINAPI dkcFreeArcfour(DKC_ARCFOUR_STATE **p){
	if(NULL==p){
		return edk_FAILED;
	}
	return dkcFree(p);
}




