/*
 * Decompiled with CFR 0.152.
 */
package dijava;

import dijava.InvokerUtil;
import dijava.JavaMemoryObject;
import dijava.JavaSource;
import dijava.Token;
import dijava.Tokenizer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static Map<String, JavaSource> src = new LinkedHashMap<String, JavaSource>();
    private static int mode = 1;

    private static URI toURI(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new IllegalStateException("Cannot find the system Java compiler. Check that your class path includes tools.jar");
        }
        final HashMap output = new HashMap();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ForwardingJavaFileManager<StandardJavaFileManager> jfm = new ForwardingJavaFileManager<StandardJavaFileManager>(compiler.getStandardFileManager(diagnostics, null, null)){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                MemoryJavaFileObject jfo = new MemoryJavaFileObject(name, kind);
                output.put(name, jfo);
                return jfo;
            }
        };
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        int nest = 0;
        try {
            InputStreamReader in = new InputStreamReader(System.in);
            BufferedReader reader = new BufferedReader(in);
            boolean compile = false;
            String fileName = null;
            ArrayList cp = new ArrayList();
            block11: while (true) {
                JavaSource js;
                String mode_title = "(free)";
                if (mode == 0) {
                    mode_title = "(free)";
                } else if (mode == 1) {
                    mode_title = "(main)";
                } else if (mode == 2) {
                    mode_title = "(meth)";
                }
                System.out.print("DIJava:" + mode_title + Main.padding(3, count) + ":" + Main.padding(2, nest) + "> ");
                String command = reader.readLine();
                if ("quit".equals(command.trim()) || "exit".equals(command.trim())) {
                    System.exit(0);
                }
                if ("version".equals(command.trim())) {
                    System.out.println("DIJava(Dynamic Interactive Java) -Version \"0.0.2\"");
                    continue;
                }
                if ("clear".equals(command.trim())) {
                    list.clear();
                    count = 0;
                    nest = 0;
                    fileName = null;
                    cp.clear();
                    continue;
                }
                if (command.startsWith("cat")) {
                    if ("cat".equals(command)) {
                        for (int j = 0; j < list.size(); ++j) {
                            System.out.println(Main.padding(3, j) + ":" + (String)list.get(j));
                        }
                        if (list.size() != 0) continue;
                        System.out.println("code is nothing!");
                        continue;
                    }
                    StringTokenizer commands = new StringTokenizer(command);
                    int i = 0;
                    while (true) {
                        if (!commands.hasMoreTokens()) continue block11;
                        if (i == 1) {
                            String file_name = commands.nextToken();
                            if (src.containsKey(file_name)) {
                                js = src.get(file_name);
                                List l = js.getSource();
                                int j = 0;
                                while (true) {
                                    if (j >= l.size()) continue block11;
                                    System.out.println(Main.padding(3, j) + ":" + l.get(j));
                                    ++j;
                                }
                            }
                            System.out.println("Not Found File:[" + file_name + "]");
                            continue block11;
                        }
                        if (i > 1) continue block11;
                        ++i;
                        commands.nextToken();
                    }
                }
                if (command.startsWith("del")) {
                    StringTokenizer commands = new StringTokenizer(command);
                    int i = 0;
                    while (true) {
                        if (!commands.hasMoreTokens()) continue block11;
                        if (i == 1) {
                            String file_name = commands.nextToken();
                            if (src.containsKey(file_name)) {
                                src.remove(file_name);
                                continue block11;
                            }
                            System.out.println("Not Found File:[" + file_name + "]");
                            continue block11;
                        }
                        if (i > 1) continue block11;
                        ++i;
                        commands.nextToken();
                    }
                }
                if ("list".equals(command.trim()) || "ls".equals(command.trim())) {
                    if (src.size() == 0) {
                        System.out.println("File is not exsits!");
                        continue;
                    }
                    Set<String> s = src.keySet();
                    Iterator<String> ite = s.iterator();
                    int i = 0;
                    while (true) {
                        if (!ite.hasNext()) continue block11;
                        js = src.get(ite.next());
                        System.out.println(i + ":" + js.getFile_name() + ":" + js.getPackage_name());
                        ++i;
                    }
                }
                if (command.startsWith("mode")) {
                    StringTokenizer commands = new StringTokenizer(command);
                    int i = 0;
                    while (true) {
                        if (!commands.hasMoreTokens()) continue block11;
                        if (i == 1) {
                            String mode_name = commands.nextToken();
                            if ("free".equals(mode_name)) {
                                if (mode == 0) continue block11;
                                list.clear();
                                mode = 0;
                                continue block11;
                            }
                            if ("main".equals(mode_name)) {
                                if (mode == 1) continue block11;
                                list.clear();
                                mode = 1;
                                continue block11;
                            }
                            if (!"meth".equals(mode_name) || mode == 2) continue block11;
                            list.clear();
                            mode = 2;
                            continue block11;
                        }
                        if (i > 1) continue block11;
                        ++i;
                        commands.nextToken();
                    }
                }
                if (command.startsWith("edit")) {
                    String line;
                    StringTokenizer commands = new StringTokenizer(command);
                    int i = 0;
                    if (commands.countTokens() == 3) {
                        String co = "";
                        line = "";
                        while (commands.hasMoreTokens()) {
                            if (i == 0) {
                                commands.nextToken();
                            }
                            if (i == 1) {
                                co = commands.nextToken();
                            } else if (i == 2) {
                                line = commands.nextToken();
                                break;
                            }
                            ++i;
                        }
                        char[] c = line.toCharArray();
                        boolean error = false;
                        for (int x = 0; x < c.length; ++x) {
                            if (Character.isDigit(c[x])) continue;
                            System.out.println("Command is wrong!");
                            error = true;
                            break;
                        }
                        if (error) continue;
                        if (Integer.parseInt(line) >= list.size()) {
                            System.out.println("Line is wrong![" + line + "]" + "MaxSize:" + list.size());
                            continue;
                        }
                        if (co.equals("ins")) {
                            System.out.print("DIEdit:" + mode_title + Main.padding(3, Integer.parseInt(line)) + ":" + Main.padding(2, 0) + "> ");
                            String line_source = reader.readLine();
                            list.add(Integer.parseInt(line), line_source);
                            ++count;
                            continue;
                        }
                        if (co.equals("upd")) {
                            System.out.print("DIEdit:" + mode_title + Main.padding(3, Integer.parseInt(line)) + ":" + Main.padding(2, 0) + "> ");
                            String line_source = reader.readLine();
                            list.set(Integer.parseInt(line), line_source);
                            continue;
                        }
                        if (!co.equals("del")) continue;
                        list.remove(Integer.parseInt(line));
                        --count;
                        continue;
                    }
                    if (commands.countTokens() == 4) {
                        String line_source;
                        String co = "";
                        line = "";
                        String fileNM = "";
                        while (commands.hasMoreTokens()) {
                            if (i == 0) {
                                commands.nextToken();
                            }
                            if (i == 1) {
                                co = commands.nextToken();
                            } else if (i == 2) {
                                line = commands.nextToken();
                            } else if (i == 3) {
                                fileNM = commands.nextToken();
                                break;
                            }
                            ++i;
                        }
                        char[] c = line.toCharArray();
                        boolean error = false;
                        for (int x = 0; x < c.length; ++x) {
                            if (Character.isDigit(c[x])) continue;
                            System.out.println("Command is wrong!");
                            error = true;
                            break;
                        }
                        if (error) continue;
                        if (!src.containsKey(fileNM)) {
                            System.out.println("File Not Found![" + fileNM + "]");
                            continue;
                        }
                        JavaSource js2 = src.get(fileNM);
                        List xlist = js2.getSource();
                        if (Integer.parseInt(line) >= xlist.size()) {
                            System.out.println("Line is wrong![" + line + "]" + "MaxSize:" + xlist.size());
                            continue;
                        }
                        if (co.equals("ins")) {
                            System.out.print("DIEdit:" + mode_title + Main.padding(3, Integer.parseInt(line)) + ":" + Main.padding(2, 0) + "> ");
                            line_source = reader.readLine();
                            xlist.add(Integer.parseInt(line), line_source);
                            js2.setSource(xlist);
                            js2.setEditable(true);
                            src.put(js2.getFile_name(), js2);
                            continue;
                        }
                        if (co.equals("upd")) {
                            System.out.print("DIEdit:" + mode_title + Main.padding(3, Integer.parseInt(line)) + ":" + Main.padding(2, 0) + "> ");
                            line_source = reader.readLine();
                            xlist.set(Integer.parseInt(line), line_source);
                            js2.setSource(xlist);
                            js2.setEditable(true);
                            src.put(js2.getFile_name(), js2);
                            continue;
                        }
                        if (!co.equals("del")) continue;
                        xlist.remove(Integer.parseInt(line));
                        js2.setSource(xlist);
                        js2.setEditable(true);
                        src.put(js2.getFile_name(), js2);
                        continue;
                    }
                    System.out.println("Command is wrong!.");
                    continue;
                }
                if ("help".equals(command.trim()) || "?".equals(command.trim())) {
                    System.out.println("-------------------------------------------");
                    System.out.println("-----DIJava (Dynamic Interactive Java) ----");
                    System.out.println("-------------------------------------------");
                    System.out.println("This is DIJava commands and reserved words.");
                    System.out.println("");
                    System.out.println("cat [file_name or nothing].");
                    System.out.println("del [file_name].");
                    System.out.println("list or ls");
                    System.out.println("java [args...]");
                    System.out.println("start [method]");
                    System.out.println("edit [command](ins or upd or del) [line] [file_name or nothing]");
                    System.out.println("mode [mode](free or main)");
                    System.out.println("version");
                    System.out.println("clear");
                    System.out.println("help or ?");
                    System.out.println("quit or exit");
                    continue;
                }
                if (command.startsWith("java ") || command.equals("java")) {
                    StringTokenizer commands = new StringTokenizer(command);
                    ArrayList<String> a = new ArrayList<String>();
                    boolean flg = false;
                    while (commands.hasMoreTokens()) {
                        if (!flg) {
                            commands.nextToken();
                            flg = !flg;
                            continue;
                        }
                        a.add(commands.nextToken());
                    }
                    if (a.size() != 0) {
                        args = a.toArray(new String[0]);
                    }
                } else {
                    if (command.startsWith("start")) {
                        if (src.size() == 0) {
                            System.out.println("Source is nothing!.");
                            continue;
                        }
                        try {
                            InvokerUtil.invoke(src, command);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    list.add(command);
                    ++count;
                }
                List<Token> l = Tokenizer.split(Main.getSource(list));
                if (null == fileName) {
                    fileName = Tokenizer.getFileName(l);
                }
                nest = Tokenizer.getNestCount(l);
                if (null == fileName && mode == 0) continue;
                ArrayList<String> classpath = null;
                if (cp.size() > 0) {
                    classpath = new ArrayList<String>();
                    classpath.add(" -cp ");
                    String path = "";
                    for (int cpi = 0; cpi < cp.size(); ++cpi) {
                        String p = (String)cp.get(cpi);
                        if (p == null || "".equals(p)) continue;
                        path = path + p + ";";
                    }
                    classpath.add(path);
                }
                ArrayList<String> _list = null;
                String _fileName = null;
                if (mode == 0) {
                    _list = list;
                    _fileName = fileName;
                } else if (mode == 1) {
                    _list = new ArrayList<String>(list);
                    _list.add(0, "import java.util.*;");
                    _list.add(1, "public class MAIN{");
                    _list.add(2, "  public static void main(String args[]) {");
                    _list.add("    }");
                    _list.add("}");
                    _fileName = "MAIN";
                } else if (mode == 2) {
                    _list = new ArrayList<String>(list);
                    _list.add(0, "import java.util.*;");
                    _list.add(1, "public class METHOD{");
                    _list.add("}");
                    _fileName = "METHOD";
                }
                ArrayList<String> clazzs = null;
                if (src.size() > 0) {
                    clazzs = new ArrayList<String>();
                    Set<String> s = src.keySet();
                    for (String key : s) {
                        if (key.equals(_fileName)) continue;
                        JavaSource js3 = src.get(key);
                        clazzs.add(js3.getPackage_name());
                    }
                }
                JavaCompiler.CompilationTask task = null;
                task = compiler.getTask(null, jfm, diagnostics, classpath, clazzs, Arrays.asList(new JavaMemoryObject(Main.toURI(_fileName + JavaFileObject.Kind.SOURCE.extension), Main.getSource(_list))));
                compile = task.call();
                if (!compile && nest == 0 && _list.size() > 1) {
                    for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                        System.out.println("Error:" + diagnostic.getMessage(null));
                    }
                }
                if (!compile) continue;
                Set s = output.keySet();
                Iterator ite = s.iterator();
                String clazz = "";
                while (ite.hasNext() && !(clazz = (String)ite.next()).endsWith(_fileName)) {
                }
                src.put(_fileName, new JavaSource(new ArrayList<String>(list), clazz, _fileName, classpath));
                ClassLoader cl = new ClassLoader(){

                    @Override
                    protected Class<?> findClass(String name) throws ClassNotFoundException {
                        JavaFileObject jfo = (JavaFileObject)output.get(name);
                        if (jfo != null) {
                            byte[] bytes = ((MemoryJavaFileObject)jfo).baos.toByteArray();
                            return this.defineClass(name, bytes, 0, bytes.length);
                        }
                        return super.findClass(name);
                    }
                };
                try {
                    Class<?> c = Class.forName(clazz, false, cl);
                    Method[] ms = c.getDeclaredMethods();
                    boolean mainflg = false;
                    for (int i = 0; i < ms.length; ++i) {
                        String method = ms[i].getName();
                        Class<?>[] clz = ms[i].getParameterTypes();
                        if (!"main".equals(method) || !clz[0].isAssignableFrom(String[].class)) continue;
                        mainflg = true;
                        break;
                    }
                    JavaSource js4 = src.get(_fileName);
                    js4.setMs(ms);
                    js4.setMainflg(mainflg);
                    js4.setC(c);
                    src.put(_fileName, js4);
                    if (mainflg) {
                        c.getMethod("main", String[].class).invoke(null, new Object[]{args});
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (mode != 0) continue;
                list.clear();
                count = 0;
                nest = 0;
                cp.clear();
                fileName = null;
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(1);
            return;
        }
    }

    public static String padding(int digit, int val) {
        return String.format("%0" + digit + "d", val);
    }

    public static String getSource(List<String> list) {
        String source = "";
        for (String arg : list) {
            source = source + "\n" + arg;
        }
        return source;
    }

    static class MemoryJavaFileObject
    extends SimpleJavaFileObject {
        ByteArrayOutputStream baos;

        MemoryJavaFileObject(String name, JavaFileObject.Kind kind) {
            super(Main.toURI(name), kind);
        }

        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException, IllegalStateException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public InputStream openInputStream() throws IOException, IllegalStateException, UnsupportedOperationException {
            return new ByteArrayInputStream(this.baos.toByteArray());
        }

        public OutputStream openOutputStream() throws IOException, IllegalStateException, UnsupportedOperationException {
            this.baos = new ByteArrayOutputStream();
            return this.baos;
        }
    }
}

