/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class AnnotationUtil {
    public static final <T> T getAnnotationClass(Class target, Class<T> anno) {
        return anno.cast(target.getAnnotation(anno));
    }

    public static final Map getAnnotationFieldEntity(Class target, Class<? extends Annotation> anno) {
        Field[] f;
        HashMap<String, Annotation> m = new HashMap<String, Annotation>();
        Field[] fieldArray = f = target.getDeclaredFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Annotation[] as;
            Field ff = fieldArray[n];
            if (!ff.isAccessible()) {
                ff.setAccessible(true);
            }
            Annotation[] annotationArray = as = ff.getAnnotations();
            int n3 = 0;
            int n4 = annotationArray.length;
            while (n3 < n4) {
                Annotation a = annotationArray[n3];
                if (a.annotationType().isAssignableFrom(anno)) {
                    m.put(ff.getName(), a);
                }
                ++n3;
            }
            ++n;
        }
        return m;
    }

    public static final <T> T getAnnotationConstructor(Class target, Class[] param, Class<T> anno) {
        Constructor c;
        block11: {
            c = null;
            if (param == null) {
                if (target.isMemberClass()) {
                    Class<?> superc = target.getDeclaringClass();
                    c = target.getConstructor(superc);
                } else {
                    c = target.getDeclaredConstructor(new Class[0]);
                }
            } else {
                c = target.getDeclaredConstructor(param);
            }
            if (c != null) break block11;
            return null;
        }
        try {
            Annotation[] as;
            if (!c.isAccessible()) {
                c.setAccessible(true);
            }
            Annotation[] annotationArray = as = c.getAnnotations();
            int n = 0;
            int n2 = annotationArray.length;
            while (n < n2) {
                Annotation a = annotationArray[n];
                if (a.annotationType().isAssignableFrom(anno)) {
                    return anno.cast(a);
                }
                ++n;
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static final <T> T getAnnotationMethod(Class target, String method, Class[] param, Class<T> anno) {
        Method m;
        block7: {
            m = target.getDeclaredMethod(method, param);
            if (m != null) break block7;
            return null;
        }
        try {
            Annotation[] as;
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            Annotation[] annotationArray = as = m.getAnnotations();
            int n = 0;
            int n2 = annotationArray.length;
            while (n < n2) {
                Annotation a = annotationArray[n];
                if (a.annotationType().isAssignableFrom(anno)) {
                    return anno.cast(a);
                }
                ++n;
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static final <T> T getAnnotationField(Class target, String field, Class<T> anno) {
        Field f;
        block7: {
            f = target.getDeclaredField(field);
            if (f != null) break block7;
            return null;
        }
        try {
            Annotation[] as;
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            Annotation[] annotationArray = as = f.getAnnotations();
            int n = 0;
            int n2 = annotationArray.length;
            while (n < n2) {
                Annotation a = annotationArray[n];
                if (a.annotationType().isAssignableFrom(anno)) {
                    return anno.cast(a);
                }
                ++n;
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static Object getAnnotationMethod(Class<? extends Object> c) throws Exception {
        Method[] ms = c.getDeclaredMethods();
        Class<? extends Annotation> ano = ms[0].getDeclaredAnnotations()[0].annotationType();
        Method[] ms2 = ano.getDeclaredMethods();
        String m = ms2[1].getName();
        Method m2 = ano.getDeclaredMethod(m, new Class[0]);
        m2.setAccessible(true);
        Object xx = m2.invoke((Object)ms[0].getDeclaredAnnotations()[0], new Object[0]);
        return new Object[]{xx};
    }

    public static boolean isRuntimeAnnotation(Class<? extends Annotation> anno) {
        Retention retention = anno.getAnnotation(Retention.class);
        if (retention == null) {
            return false;
        }
        return RetentionPolicy.RUNTIME == retention.value();
    }
}

