/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.container.factory;

import ikdnet.container.Container;
import ikdnet.container.factory.ContainerFactory;
import ikdnet.container.factory.exception.ContainerClassNotFoundException;
import ikdnet.container.factory.exception.ErrorCode;
import ikdnet.container.factory.exception.NotFoundContainerException;
import ikdnet.container.factory.exception.NotSupportedClassException;
import ikdnet.container.factory.list.DIProxyList;
import ikdnet.container.impl.ContainerImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContainerFactoryImpl
extends ContainerFactory {
    private static boolean initialized = false;
    private static Map<String, Boolean> isDI = new ConcurrentHashMap<String, Boolean>();

    @Override
    public boolean isClass(String key) {
        if (isDI == null) {
            isDI = new ConcurrentHashMap<String, Boolean>();
        }
        if (isDI.containsKey(key)) {
            return isDI.get(key);
        }
        boolean b = super.isClass(key);
        isDI.put(key, b);
        return b;
    }

    private synchronized void init() {
        String string = "containerfactory.";
        if (!initialized) {
            ConcurrentHashMap<String, String> containerclass = new ConcurrentHashMap<String, String>();
            for (String key : DIProxyList.m.keySet()) {
                String c = ContainerFactoryImpl.getProperty("containerfactory." + key.toLowerCase());
                if (c == null || "".equals(c)) continue;
                if (!this.isClass(c)) {
                    throw new ContainerClassNotFoundException(ErrorCode.E008, c);
                }
                if (!this.isContainerImpl(c)) continue;
                containerclass.put(key, c);
            }
            DIProxyList.initClass(containerclass);
            initialized = true;
        }
    }

    @Override
    protected synchronized Container createContainer() {
        this.init();
        if (ContainerFactoryImpl.getDefaultcontainer() != null && !"".equals(ContainerFactoryImpl.getDefaultcontainer())) {
            String defaultcontainer = ContainerFactoryImpl.getDefaultcontainer();
            if ("SEASAR".equals(defaultcontainer.trim().toUpperCase())) {
                if (!this.isClass(DIProxyList.seasar)) {
                    throw new NotFoundContainerException(ErrorCode.E004, DIProxyList.seasar);
                }
                return this.newInstance(DIProxyList.m.get("SEASAR"));
            }
            if ("SPRING".equals(defaultcontainer.trim().toUpperCase())) {
                if (!this.isClass(DIProxyList.spring)) {
                    throw new NotFoundContainerException(ErrorCode.E004, DIProxyList.spring);
                }
                return this.newInstance(DIProxyList.m.get("SPRING"));
            }
            if ("PICO".equals(defaultcontainer.trim().toUpperCase())) {
                if (!this.isClass(DIProxyList.pico)) {
                    throw new NotFoundContainerException(ErrorCode.E004, DIProxyList.pico);
                }
                return this.newInstance(DIProxyList.m.get("PICO"));
            }
            if ("HIVEMIND".equals(defaultcontainer.trim().toUpperCase())) {
                if (!this.isClass(DIProxyList.hivemind)) {
                    throw new NotFoundContainerException(ErrorCode.E004, DIProxyList.hivemind);
                }
                return this.newInstance(DIProxyList.m.get("HIVEMIND"));
            }
            if ("GUICE".equals(defaultcontainer.trim().toUpperCase())) {
                if (!this.isClass(DIProxyList.guice)) {
                    throw new NotFoundContainerException(ErrorCode.E004, DIProxyList.guice);
                }
                return this.newInstance(DIProxyList.m.get("GUICE"));
            }
            if ("CUSTOM".equals(defaultcontainer.trim().toUpperCase())) {
                return this.newInstance(DIProxyList.m.get("CUSTOM"));
            }
            throw new NotSupportedClassException(ErrorCode.E003, ContainerFactoryImpl.getDefaultcontainer());
        }
        Container container = this.isClass(DIProxyList.spring) ? this.newInstance(DIProxyList.m.get("SPRING")) : (this.isClass(DIProxyList.seasar) ? this.newInstance(DIProxyList.m.get("SEASAR")) : (this.isClass(DIProxyList.pico) ? this.newInstance(DIProxyList.m.get("PICO")) : (this.isClass(DIProxyList.hivemind) ? this.newInstance(DIProxyList.m.get("HIVEMIND")) : (this.isClass(DIProxyList.guice) ? this.newInstance(DIProxyList.m.get("GUICE")) : new ContainerImpl()))));
        return container;
    }
}

