/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.container.factory;

import ikdnet.container.Container;
import ikdnet.container.factory.ContainerFactoryImpl;
import ikdnet.container.factory.exception.ErrorCode;
import ikdnet.container.factory.exception.NotCreatedContainerException;
import ikdnet.container.factory.exception.NotSupportedClassException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ContainerFactory {
    private static final String DEFAULT_CONFIG = "/diproxy.properties";
    private static final String defaultfactory = "ContainerFactoryImpl";
    private static Container container;
    private static ContainerFactory containerfactory;
    private static Map<String, Container> containermap;
    private static String custumfactory;
    private static String defaultcontainer;
    private static Properties props;

    static {
        containermap = new ConcurrentHashMap<String, Container>();
    }

    protected abstract Container createContainer();

    public static final synchronized Container getContainer() {
        ContainerFactory.createContainerFactory();
        if (container == null) {
            container = containerfactory.createContainer();
        }
        return container;
    }

    private static synchronized void createContainerFactory() {
        if (containerfactory == null) {
            props = ContainerFactory.getProperties(ContainerFactory.getPath(DEFAULT_CONFIG));
            if (props != null) {
                custumfactory = props.getProperty("containerfactory.custumfactory");
                defaultcontainer = props.getProperty("containerfactory.defaultcontainer");
            }
            if (custumfactory == null || "".equals(custumfactory)) {
                custumfactory = defaultfactory;
            }
            try {
                Class<?> c = Class.forName(custumfactory);
                if (!ContainerFactory.class.isAssignableFrom(c)) {
                    throw new NotSupportedClassException(ErrorCode.E007, c.getName());
                }
                containerfactory = (ContainerFactory)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                containerfactory = new ContainerFactoryImpl();
            }
            catch (IllegalAccessException e) {
                containerfactory = new ContainerFactoryImpl();
            }
            catch (InstantiationException e) {
                containerfactory = new ContainerFactoryImpl();
            }
        }
    }

    public static final synchronized Container getContainer(String container_key) {
        Container container = null;
        if (container_key == null || "".equals(container_key)) {
            throw new NotCreatedContainerException(ErrorCode.E006, container_key);
        }
        if (containermap.containsKey(container_key)) {
            container = containermap.get(container_key);
        }
        ContainerFactory.createContainerFactory();
        if (container == null) {
            defaultcontainer = container_key;
            container = containerfactory.createContainer();
            containermap.put(container_key, container);
        }
        return container;
    }

    protected synchronized Container newInstance(String clazz) {
        try {
            Class<?> c = Class.forName(clazz);
            if (!Container.class.isAssignableFrom(c)) {
                throw new NotSupportedClassException(ErrorCode.E005, c.getName());
            }
            return (Container)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new NotCreatedContainerException(e);
        }
        catch (IllegalAccessException e) {
            throw new NotCreatedContainerException(e);
        }
        catch (InstantiationException e) {
            throw new NotCreatedContainerException(e);
        }
    }

    protected boolean isContainerImpl(String clazz) {
        try {
            Class<?> c = Class.forName(clazz);
            if (!Container.class.isAssignableFrom(c)) {
                throw new NotSupportedClassException(ErrorCode.E005, c.getName());
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            throw new NotCreatedContainerException(e);
        }
    }

    protected boolean isClass(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static final Properties getProperties(final String path) {
        PrivilegedAction pa = new PrivilegedAction(){

            public Object run() {
                try {
                    FileInputStream is = new FileInputStream(path);
                    if (is != null) {
                        Properties props = new Properties();
                        props.load(is);
                        ((InputStream)is).close();
                        return props;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
        return (Properties)AccessController.doPrivileged(pa);
    }

    private static final String getPath(String canonicalPath) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(canonicalPath);
        String realPath = "";
        if (url == null) {
            String pathes = System.getProperty("java.class.path");
            String[] s = pathes.split(";");
            realPath = String.valueOf(s[0]) + canonicalPath;
        } else {
            realPath = url.getPath();
        }
        return realPath;
    }

    protected static String getCustumfactory() {
        return custumfactory;
    }

    protected static String getDefaultcontainer() {
        return defaultcontainer;
    }

    protected static void setDefaultcontainer(String type) {
        defaultcontainer = type;
    }

    protected static String getProperty(String keyword) {
        if (props != null) {
            return props.getProperty(keyword);
        }
        return null;
    }
}

