package org.ocharake.matobaa.postal;

import java.io.IOException;

import org.ocharake.matobaa.dictionary.IDictionary;

public class ZipCodeDictionary implements IDictionary {
	private String queryWord;
	public ZipCodeDictionary() {
	}
	public String getSupportType() {
		return "X֔ԍ(CSV`)";
	}
	public void setDictionary(String dictionaryPath) throws IOException {
	}
	public void closeDictionary() {}
	public String query(String queryWord) {
		if (queryWord == null || queryWord.length() != 7 || !Character.isDigit(queryWord.charAt(0)))
			return null;
		this.queryWord = queryWord;
		try {
			ZipCode zipCode = ZipCode.searchByZip(queryWord);
			return zipCode == null
				? null
				: zipCode.s{ + zipCode.s撬 + zipCode.於;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}
	public String next() {
		return null;
	}
	public String getHeading() {
		return queryWord;
	}
}
