package org.ocharake.matobaa.dictionary.pdicw;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
/**
 * BigEndianp̃\bhǉRandomAccessFileNXB
 * @author matobaa
 * @version 2003/11/28
 */
public class RandomAccessFileBigEndian extends RandomAccessFile {
	/**
	 * I[oChꂽRXgN^B
	 * @see java.io.RandomAccessFile(java.io.File, java.lang.String);
	 * @param file
	 * @param mode
	 * @throws java.io.FileNotFoundException
	 */
	public RandomAccessFileBigEndian(File file, String mode)
		throws FileNotFoundException {
		super(file, mode);
	}
	/**
	 * I[oChꂽRXgN^B
	 * @see java.io.RandomAccessFile(java.lang.String, java.lang.String);
	 * @param name
	 * @param mode
	 * @throws java.io.FileNotFoundException
	 */
	public RandomAccessFileBigEndian(String name, String mode)
		throws FileNotFoundException {
		super(name, mode);
	}
	/**
	 * Reads a signed 16-bit number from this file in Big Endian. The method reads two 
	 * bytes from this file, starting at the current file pointer. 
	 * If the two bytes read, in order, are 
	 * <code>b1</code> and <code>b2</code>, where each of the two values is 
	 * between <code>0</code> and <code>255</code>, inclusive, then the 
	 * result is equal to:
	 * <blockquote><pre>
	 *     (short)(b1 | (b2 &lt;&lt; 8))
	 * </pre></blockquote>
	 * <p>
	 * This method blocks until the two bytes are read, the end of the 
	 * stream is detected, or an exception is thrown. 
	 *
	 * @return     the next two bytes of this file, interpreted as a signed
	 *             16-bit number.
	 * @exception  EOFException  if this file reaches the end before reading
	 *               two bytes.
	 * @exception  IOException   if an I/O error occurs.
	 */
	public final short readShortBigEndian() throws IOException {
		int ch2 = this.read();
		int ch1 = this.read();
		if ((ch1 | ch2) < 0)
			throw new EOFException();
		return (short) ((ch1 << 8) + (ch2 << 0));
	}
	/**
	 * Reads a signed 32-bit integer from this file in Big Endian. This method reads 4 
	 * bytes from the file, starting at the current file pointer. 
	 * If the bytes read, in order, are <code>b1</code>,
	 * <code>b2</code>, <code>b3</code>, and <code>b4</code>, where 
	 * <code>0&nbsp;&lt;=&nbsp;b1, b2, b3, b4&nbsp;&lt;=&nbsp;255</code>, 
	 * then the result is equal to:
	 * <blockquote><pre>
	 *     (b4 &lt;&lt; 24) | (b3 &lt;&lt; 16) + (b2 &lt;&lt; 8) + b1
	 * </pre></blockquote>
	 * <p>
	 * This method blocks until the four bytes are read, the end of the 
	 * stream is detected, or an exception is thrown. 
	 *
	 * @return     the next four bytes of this file, interpreted as an
	 *             <code>int</code>.
	 * @exception  EOFException  if this file reaches the end before reading
	 *               four bytes.
	 * @exception  IOException   if an I/O error occurs.
	 */
	public final int readIntBigEndian() throws IOException {
		int ch4 = this.read();
		int ch3 = this.read();
		int ch2 = this.read();
		int ch1 = this.read();
		if ((ch1 | ch2 | ch3 | ch4) < 0)
			throw new EOFException();
		return ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
	}
	/**
	 * ̃t@C̎̃eLXgsǂݍ݂܂B
	 * ̃\bh́At@Č݂̃t@C|C^n߂čsL܂̓t@C̏IɒB܂ŁAAIɃoCgǂݍ݂܂B
	 * ̉ 8 rbg̃oCgl擾A 8 rbg[ɐݒ肷邱ƂŁAeoCg͕ɕϊ܂B̂߁Ã\bh
	 * Unicode ZbgSɂ̓T|[gĂ܂B 
	 * eLXgśAA ('\r')As ('\n')AA̒ɉsƂgݍ킹ANULL, ܂̓t@C̏IŏI܂B
	 * NULL܂͍s͔jAԂ镶̈ꕔɂ͊܂܂܂B 
	 * ̃\bh́Asǂݍ܂܂ŁAAƂɑoCgǂݍ܂ (sǂmF) ܂ŁANULLɂ܂ŁA
	 * t@C̏IɒB܂ŁA܂͗OX[܂ŃubN܂B 
	 *
	 * @return     ̃t@C̎̃eLXgsBt@C̏I肪o܂ł 1 oCgǂݍ߂Ȃꍇ null 
	 * @exception  IOException  o̓G[ꍇ
	 */
	public String readNullTerminatedString() throws IOException {
		StringBuffer input = new StringBuffer();
		int c = -1;
		boolean eol = false;
		while (!eol) {
			switch (c = read()) {
				case 0 :
				case -1 :
				case '\n' :
					eol = true;
					break;
				case '\r' :
					eol = true;
					long cur = getFilePointer();
					if ((read()) != '\n') {
						seek(cur);
					}
					break;
				default :
					input.append((char) c);
					break;
			}
		}
		if ((c == -1) && (input.length() == 0)) {
			return null;
		}
		return input.toString();
	}
}
