package org.ocharake.matobaa.dictionary.pdicw;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.ocharake.matobaa.dictionary.IDictionary;

/**
 * PDICW`̎̌@\񋟂܂B
 * @author matobaa
 * @version 2003/11/28
 */
public class PDICW implements IDictionary {

	public static void main(String[] args) {
		PDICW dict = new PDICW();
		dict.setDictionary("c:\\PDIC\\gene.DIC");
		long start;
		start = System.currentTimeMillis();
		System.out.println("GENE>>> " + dict.query("eclipse"));
		System.out.println(System.currentTimeMillis() - start);
		dict.setDictionary("c:\\PDIC\\EIJIRO52.DIC");
		start = System.currentTimeMillis();
		System.out.println("Eijiro>>> " + dict.query("cost"));
		System.out.println(System.currentTimeMillis() - start);
	}
	private String heading;
	Index[] index = null;
	private RandomAccessFileBigEndian file;
	private Header header;
	/**
	 * ̈Ӗ
	 * @param string 
	 * @return ̈ӖBG[oȂꍇnull
	 */
	public String query(String string) {
		if (string == null || string.length() == 0) {
			return null;
		}
		//ADHOC start
		if (file == null)
			setDictionary("c:\\PDIC\\EIJIRO39.DIC");
		// ADHOC end
		try {
			if (file == null) {
				// ADHOC
				System.err.println("No Dictionary");
				return null;
			}
			// ubNT
			int i;
			for (i = 0;
				i < index.length && index[i].indexWord.compareTo(string) < 0;
				i++);
			if (i == index.length) {
				// ADHOC
				System.err.println(
					"Block not found fot string [" + string + "]");
				return null;
			}
			int blockIndexPhysical = index[i - 1].blockIndexPhysical;
			file.seek(
				header.size
					+ header.extheader
					+ (int)header.index_block * (int)header.block_size
					+ blockIndexPhysical * (int)header.block_size);
			// ubNT
			short numBlocks = file.readShortBigEndian();
			if (numBlocks == 0) {
				// ADHOC
				System.err.println("Empty block found");
				return null;
			}
			boolean longData = numBlocks < 0; // ŏʃrbgĂꍇAOf[^`
			StringBuffer lookingWord = new StringBuffer(20);
			// tB[hǂ
			long pos;
			int fieldLength = 0;
			String word = null;
			do {
				fieldLength =
					!longData
						? (file.readShortBigEndian() & 0xffff)
						: file.readIntBigEndian();
				byte prefixLength = file.readByte();
				word = file.readNullTerminatedString();
				lookingWord.setLength(prefixLength + word.length());
				lookingWord.replace(prefixLength, lookingWord.length(), word);
				pos = file.getFilePointer(); // ƂŖǂݎ邽߂ɍTĂ
				file.seek(pos + fieldLength - word.length() - 1);
			} while (string.compareTo(lookingWord.toString()) > 0);
			// ǂݎ
			file.seek(pos);
			heading = lookingWord.toString();
			byte attribute = file.readByte();
			if ((attribute & 0x10) == 0) {
				// gȂ
				byte[] meaning = new byte[fieldLength - word.length() - 2];
				file.read(meaning);
				// FIXME: ԂlmF邱
				return new String(meaning, "Shift_JIS");
			} else {
				// g
				String meaning = file.readNullTerminatedString();
				meaning =
					new String(meaning.getBytes("ISO-8859-1"), "Shift_JIS");
				byte ext_attribute = file.readByte();
				byte[] rest = new byte[256];
				file.read(rest);
				return meaning;
			}
		} catch (IOException e) {
			e.printStackTrace();
			//ADHOC b쐬ꂽOBK؂ȏɕύXĂB
			return null;
		}
	}
	/**
	 * PICW`̎o^
	 * @param string PICW`t@C̃pX
	 */
	public void setDictionary(String dictionary) {
		if (file != null) {
			closeDictionary();
		}
		try {
			// wb_͂
			header = new Header();
			file = new RandomAccessFileBigEndian(dictionary, "r");
			if (file.length() < 256) {
				// ADHOC: Maybe Invalid file
				return;
			}
			file.seek(0);
			file.readFully(header.headername);
			file.readFully(header.dictitle);
			header.version = file.readShortBigEndian();
			header.lword = file.readShortBigEndian();
			header.ljapa = file.readShortBigEndian();
			header.block_size = file.readShortBigEndian();
			header.index_block = file.readShortBigEndian();
			header.header_size = file.readShortBigEndian();
			header.index_size = file.readShortBigEndian();
			header.empty_block = file.readShortBigEndian();
			header.nindex = file.readShortBigEndian();
			header.nblock = file.readShortBigEndian();
			header.nword = file.readIntBigEndian();
			header.dicorder = file.readByte();
			header.dictype = file.readByte();
			header.attrlen = file.readByte();
			header.olenumber = file.readIntBigEndian();
			header.os = file.readByte();
			header.lid_word = file.readShortBigEndian();
			header.lid_japa = file.readShortBigEndian();
			header.lid_exp = file.readShortBigEndian();
			header.lid_pron = file.readShortBigEndian();
			header.lid_other = file.readShortBigEndian();
			header.extheader = file.readIntBigEndian();
			header.empty_block2 = file.readIntBigEndian();
			header.nindex2 = file.readIntBigEndian();
			header.nblock2 = file.readIntBigEndian();
			header.index_blkbit = file.readByte(); // 0:16bit, 1:32bit
			file.readFully(header.reserved);
			header.update_count = file.readIntBigEndian();
			header.charcode = file.readByte();
			file.readFully(header.dummy);
			// f[^``FbN
			//			assert file.getFilePointer() == 256;
			if (header.version != 1024) {
				// ADHOC
				System.err.println("Unsupported Dictionary version");
				return;
			}
			// CfbNX͂
			file.skipBytes(header.extheader);
			if (header.index_blkbit == Header.BLKBIT_SHORT) {
				index = new Index[header.nindex2];
				for (int blockIndexLogical = 0;
					blockIndexLogical < header.nindex2;
					blockIndexLogical++) {
					int blockIndexPhysical = file.readShortBigEndian();
					String indexWord = file.readNullTerminatedString();
					//					assert indexWord.length() != 0;
					index[blockIndexLogical] =
						new Index(blockIndexPhysical, indexWord);
				}
			} else if (header.index_blkbit == Header.BLKBIT_INT) {
				index = new Index[header.nindex2];
				for (int blockIndexLogical = 0;
					blockIndexLogical < header.nindex2;
					blockIndexLogical++) {
					int blockIndexPhysical = file.readIntBigEndian();
					String indexWord = file.readNullTerminatedString();
					//					assert indexWord.length() != 0;
					index[blockIndexLogical] =
						new Index(blockIndexPhysical, indexWord);
				}
			} else {
				// ADHOC
				System.err.println("invalid block size");
				return;
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			//ADHOC b쐬ꂽOBK؂ȏɕύXĂB
		} catch (IOException e) {
			e.printStackTrace();
			//ADHOC b쐬ꂽOBK؂ȏɕύXĂB
		}
	}
	/**
	 * B
	 */
	public void closeDictionary() {
		try {
			file.close();
		} catch (IOException e) {
			e.printStackTrace();
			//ADHOC b쐬ꂽOBK؂ȏɕύXĂB
		}
		index = null;
		file = null;
	}
	/**
	 * JĂΌnB
	 * @throws java.lang.Throwable
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		closeDictionary();
	}
	/**
	 * Ԃ܂B
	 * @return
	 * @see org.ocharake.matobaa.dictionary.IDictionary#getHeading()
	 */
	public String getHeading() {
		return heading;
	}

	/**
	 * ̃GWΉĂ鎫t@Č`Ԃ܂B
	 * @return
	 * @see org.ocharake.matobaa.dictionary.IDictionary#getSupportType()
	 */
	public String getSupportType() {
		return "PDIC";
	}

	/**
	 * O񌟍̎̈ӖԂ܂B
	 * ̃GWł͂܂T|[gĂ܂B
	 * @return
	 * @see org.ocharake.matobaa.dictionary.IDictionary#next()
	 */
	public String next() {
		return null; // PENDING: Not Suppported
	}

}
