package org.ocharake.matobaa.dictionary.pdictext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.ocharake.matobaa.dictionary.IDictionary;

/**
 * PDICeLXg`̎̌@\񋟂܂B
 * @author matobaa
 * @version 2003/11/26
 */
public class PDICText implements IDictionary {
	static final char SENTINEL = '\0';
	public PDICText() {
		super();
		setDictionary("c:\\PDIC\\gene.txt"); // ADHOC: setDictionaryĂяo܂ł̂Ȃ
	}
	public static void main(String[] args) throws IOException {
		PDICText dict = new PDICText();
		dict.setDictionary("c:\\PDIC\\gene.txt");
		System.out.println(dict.query("Eclipse"));
		dict.closeDictionary();
	}
	RandomAccessFile file;
	List[] index = null;
	public void closeDictionary() {
		try {
			if (file != null)
				file.close();
		} catch (IOException e) {
			e.printStackTrace();
			//ADHOC b쐬ꂽOBK؂ȏɕύXĂB
		}
		file = null;
		index = null;
	}

	public String getHeading() {
		return null; // PENDING: Not Supported Yet
	}

	public String getSupportType() {
		return "PDIC Text";
	}

	public String next() {
		return null; // FIXME: Not Supported 
	}

	public String query(String inputString) {
		if (inputString == null || inputString.length() == 0) {
			return null;
		}
		char indexChar = Character.toLowerCase(inputString.charAt(0));
		if (indexChar < 'a' || indexChar > 'z') {
			return null;
		}
		Iterator indexes = index[indexChar - 'a'].iterator();
		try {
			while (indexes.hasNext()) {
				FromTo index = (FromTo) indexes.next();

				file.seek(index.from);
				String fLine;
				for (fLine = file.readLine();
					file.getFilePointer() < index.to;
					fLine = file.readLine()) {
					if (inputString.equalsIgnoreCase(fLine)) {
						return new String(file.readLine().getBytes("ISO-8859-1"),"Shift_JIS");
					}
					file.readLine(); // skip japanese
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}
	public void setDictionary(String filename) {
		try {
			file = new RandomAccessFile(filename, "r");
			char indexChar = SENTINEL;
			char headOfLine;
			long pos = 0;
			long from;
			String aLine;
			FromTo fromTo = null;
			index = new ArrayList['z' - 'a' + 1];
			for (int i = 0; i < index.length; i++) {
				index[i] = new ArrayList(2);
			}
			for (aLine = file.readLine();
				aLine != null;
				aLine = file.readLine()) {
				headOfLine = Character.toLowerCase(aLine.charAt(0));
				file.readLine(); // skip Japanese
				if (!Character.isLowerCase(headOfLine))
					continue;
				if (headOfLine != indexChar) { // meet new char in head of line
					if (fromTo != null) {
						// complete from/to of last char
						fromTo.to = pos;
						index[indexChar - 'a'].add(fromTo);
					}
					// new from/to of new char
					indexChar = headOfLine;
					fromTo = new FromTo();
					fromTo.from = pos;
				}
				pos = file.getFilePointer();
			}
			fromTo.to = file.getFilePointer();
			index[indexChar - 'a'].add(fromTo);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			//			logger.error("ɓK؂ȃbZ[WL܂", e);
			//ADHOC b쐬ꂽOBK؂ȏɕύXĂB
		} catch (IOException e) {
			e.printStackTrace();
			//			logger.error("ɓK؂ȃbZ[WL܂", e);
			//ADHOC b쐬ꂽOBK؂ȏɕύXĂB
		}
	}

}
