package org.ocharake.matobaa.dictionary.eb4j;
import java.io.IOException;

import org.ocharake.matobaa.dictionary.IDictionary;

import fuku.eb4j.Book;
import fuku.eb4j.EBException;
import fuku.eb4j.Result;
import fuku.eb4j.SubBook;
/**
 * EB4Jp@\񋟂܂B
 * @author matobaa
 * @version 2003/11/26
 */
public class Eb4j implements IDictionary {
	Book book = null;
	SubBook[] subbooks = null;
	public Eb4j() {
		super();
		try {
			setDictionary("C:\\mydoc\\ebxa\\sanseido"); // ADHOC
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) throws EBException {
		Book book = new Book("C:\\mydoc\\ebxa\\sanseido");
		int count = book.getSubBookCount();
		SubBook subbook = book.getSubBook(0);
		subbook.searchWord("eclipse");
		Result result = null;
		while ((result = subbook.getNextResult()) != null) {
			System.out.println("-----");
			System.out.println(subbook.getText(result, null));
		}
	}

	public void setDictionary(String dictionaryPath) throws IOException {
		try {
			book = new Book(dictionaryPath);
			subbooks = book.getSubBooks();
		} catch (EBException e) {
			e.printStackTrace();
			throw new IOException(e.getMessage());
		}
	}
	public void closeDictionary() {
		book = null;
		subbooks = null;
	}

	public String getHeading() {
		return null; // PENDING: not implemented yet
	}

	public String getSupportType() {
		return "EBXA/EB-Wing";
	}

	public String next() {
		String resultString = "";
		try {
			for (int i = 0; i < subbooks.length; i++) {
				Result result = subbooks[i].getNextResult();
				if (result != null) {
					resultString += subbooks[i].getText(result, null);
				}
			}
		} catch (EBException e) {
			e.printStackTrace();
		}
		return resultString;
	}

	public String query(String queryWord) {
		try {
			for (int i = 0; i < subbooks.length; i++) {
				subbooks[i].searchWord(queryWord);
				Result result = subbooks[i].getNextResult();
			}
		} catch (EBException e) {
			e.printStackTrace();
		}
		return next();
	}

}
