package org.ocharake.matobaa.dictionary;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class ViewPart1 extends ViewPart implements ModifyListener {
	/**
	 * mFpGg|Cg
	 * @param args
	 */
	public static void main(String[] args) {
		Display display = new Display();
		Shell shell = new Shell(display);
		shell.setText("Dictionary");
		ViewPart me = new ViewPart1();
		me.createPartControl(shell);
		shell.setSize(200, 200);
		shell.open();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}
	//	PDICW dict = null;
	private Text queryWord;
	private Text result;
	public ViewPart1() {
	}
	/**
	 * ̃vOCp̃r[쐬܂B
	 * s̃eLXg̈ƁAXN[o[𔺂s̃eLXg̈cɔzu܂B
	 * s̃eLXg̈ɂ́ÃCX^Xg ModifyListenerƂēo^܂B
	 * @see ViewPart#createPartControl
	 */
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		queryWord = new Text(parent, SWT.SINGLE | SWT.BORDER);
		queryWord.setText("input word to query");
		queryWord.selectAll();
		queryWord.addModifyListener(this);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		queryWord.setLayoutData(gridData);
		result =
			new Text(parent, SWT.MULTI | SWT.BORDER | SWT.V_SCROLL | SWT.WRAP);
		result.setText("Result will be shown here");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		result.setLayoutData(gridData);
		parent.layout();
	}
	/**
	 * eLXgύXǁA܂B
	 * @param e eLXgύXCxg
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e) {
		String resultString =
			DictionaryPlugin.getDefault().query(queryWord.getText());
		result.setText(resultString);
	}

	/**
	 * @see ViewPart#setFocus
	 */
	public void setFocus() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		IWorkbenchPage page = window.getActivePage();
		IEditorPart editorPart = page.getActiveEditor();
//		if (editorPart instanceof MultiPageEditorPart) {
//			MultiPageEditorPart multiPageEditorPart =
//				(MultiPageEditorPart) editorPart;
//		}
		if (!(editorPart instanceof AbstractTextEditor)) {
			return;
		}
		AbstractTextEditor textEditor = (AbstractTextEditor) editorPart;
		ISelection selection = textEditor.getSelectionProvider().getSelection();
		if (!(selection instanceof TextSelection)) {
			return;
		}
		TextSelection textSelection = (TextSelection) selection;
		queryWord.setText(textSelection.getText());
	}

}
