package org.ocharake.matobaa.dictionary;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
/**
 * The main plugin class to be used in the desktop.
 */
public class DictionaryPlugin extends AbstractUIPlugin {
	IDictionary[] extensions = null;
	/**
	 * ǉԂ܂B
	 * @return ǉg|CggĂvOCԂB
	 */
	public IDictionary[] getExtentions() {
		if (extensions == null)
			extensions = searchExtentions();
		return extensions;
	}
	/**
	 * vOC|Wgǉo܂B
	 * @return vOC|WgɒǉĂǉ
	 */
	protected IDictionary[] searchExtentions() {
		ArrayList dictionaries = new ArrayList();
		try {
			IPluginRegistry registry = Platform.getPluginRegistry();
			IExtensionPoint point =
				registry.getExtensionPoint(
					"org.ocharake.matobaa.dictionary.externalDictionary");
			IExtension[] extensions = point.getExtensions();
			for (int i = 0; i < extensions.length; i++) {
				IConfigurationElement[] elements =
					extensions[i].getConfigurationElements();
				for (int j = 0; j < elements.length; j++) {
					if ("dictionary".equals(elements[j].getName())) {
						IDictionary dictionary =
							(
								IDictionary) elements[j]
									.createExecutableExtension(
								"class");
						dictionaries.add(dictionary);
					}
				}
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		IDictionary[] result = new IDictionary[dictionaries.size()];
		dictionaries.toArray(result);
		return result;
	}
	//The shared instance.
	private static DictionaryPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	/**
	 * The constructor.
	 */
	public DictionaryPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle =
				ResourceBundle.getBundle(
					"org.ocharake.matobaa.SelectionReporter.SelectionReporterPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}
	/**
	 * Returns the shared instance.
	 */
	public static DictionaryPlugin getDefault() {
		return plugin;
	}
	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}
	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle =
			DictionaryPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}
	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	/**
	 * w肳ꂽ̈ӖԂB
	 * @param string
	 * @return
	 */
	public String query(String string) {
		String result = "";
		IDictionary[] dictionaries = getExtentions();
		for (int i = 0; i < dictionaries.length; i++) {
			String eachResult = dictionaries[i].query(string);
			if(eachResult!=null) {
				result += eachResult;
				result += '\n';
			}
		}
		return result;
	}
}
