/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.util;

public final class CompareUtil {
    private CompareUtil() {
    }

    public static int compareToCanonical(byte[] key, byte[] pattern, boolean exact) {
        int ret = 0;
        int len = key.length;
        int i = 0;
        while (i < len) {
            if (i >= pattern.length) {
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                ret = exact ? -(pattern[i] & 0xFF) : 0;
                return ret;
            }
            int kByte = key[i] & 0xFF;
            int pByte = pattern[i] & 0xFF;
            if (kByte != pByte) {
                ret = kByte - pByte;
                return ret;
            }
            ++i;
        }
        if (len < pattern.length && exact) {
            ret = -(pattern[len] & 0xFF);
        }
        return ret;
    }

    public static int compareToLatin(byte[] key, byte[] pattern, boolean exact) {
        int ret = 0;
        int len = key.length;
        int i = 0;
        while (i < len) {
            if (i >= pattern.length) {
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                ret = exact ? -(pattern[i] & 0xFF) : 0;
                return ret;
            }
            int kByte = key[i] & 0xFF;
            int pByte = pattern[i] & 0xFF;
            if (kByte != pByte) {
                return kByte - pByte;
            }
            ++i;
        }
        if (len < pattern.length && exact) {
            ret = -(pattern[len] & 0xFF);
        }
        return ret;
    }

    public static int compareTo(byte[] key, byte[] pattern, boolean exact) {
        int ret = 0;
        int len = key.length;
        int i = 0;
        while (i < len) {
            if (i >= pattern.length) {
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                ret = exact ? -(pattern[i] & 0xFF) : 0;
                return ret;
            }
            if (i + 1 >= pattern.length || i + 1 >= len) {
                return (key[i] & 0xFF) - (pattern[i] & 0xFF);
            }
            int kByte = key[i] & 0xFF;
            int pByte = pattern[i] & 0xFF;
            if (kByte != pByte) {
                return kByte - pByte;
            }
            kByte = key[i + 1] & 0xFF;
            pByte = pattern[i + 1] & 0xFF;
            if (kByte != pByte) {
                return kByte - pByte;
            }
            i += 2;
        }
        if (len < pattern.length && exact) {
            ret = -(pattern[len] & 0xFF);
        }
        return ret;
    }
}

