/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.util;

import java.io.UnsupportedEncodingException;

public final class ByteUtil {
    private static final int[] JISX0208_TABLE = new int[]{8481, 8490, 8521, 8564, 8560, 8563, 8565, 8519, 8522, 8523, 8566, 8540, 8484, 8541, 8485, 8511, 9008, 9009, 9010, 9011, 9012, 9013, 9014, 9015, 9016, 9017, 8487, 8488, 8547, 8545, 8548, 8489, 8567, 9025, 9026, 9027, 9028, 9029, 9030, 9031, 9032, 9033, 9034, 9035, 9036, 9037, 9038, 9039, 9040, 9041, 9042, 9043, 9044, 9045, 9046, 9047, 9048, 9049, 9050, 8526, 8512, 8527, 8496, 8498, 8518, 9057, 9058, 9059, 9060, 9061, 9062, 9063, 9064, 9065, 9066, 9067, 9068, 9069, 9070, 9071, 9072, 9073, 9074, 9075, 9076, 9077, 9078, 9079, 9080, 9081, 9082, 8528, 8515, 8529, 8513};
    private static final int[] JISX0201_TABLE;
    private static final byte[] LONG_VOWEL_TABLE;
    private static final byte[] VOICED_CONSONANT_TABLE;

    static {
        int[] nArray = new int[64];
        nArray[1] = 8483;
        nArray[2] = 8534;
        nArray[3] = 8535;
        nArray[4] = 8482;
        nArray[5] = 8486;
        nArray[6] = 9586;
        nArray[7] = 9505;
        nArray[8] = 9507;
        nArray[9] = 9509;
        nArray[10] = 9511;
        nArray[11] = 9513;
        nArray[12] = 9571;
        nArray[13] = 9573;
        nArray[14] = 9575;
        nArray[15] = 9539;
        nArray[16] = 8508;
        nArray[17] = 9506;
        nArray[18] = 9508;
        nArray[19] = 9510;
        nArray[20] = 9512;
        nArray[21] = 9514;
        nArray[22] = 9515;
        nArray[23] = 9517;
        nArray[24] = 9519;
        nArray[25] = 9521;
        nArray[26] = 9523;
        nArray[27] = 9525;
        nArray[28] = 9527;
        nArray[29] = 9529;
        nArray[30] = 9531;
        nArray[31] = 9533;
        nArray[32] = 9535;
        nArray[33] = 9537;
        nArray[34] = 9540;
        nArray[35] = 9542;
        nArray[36] = 9544;
        nArray[37] = 9546;
        nArray[38] = 9547;
        nArray[39] = 9548;
        nArray[40] = 9549;
        nArray[41] = 9550;
        nArray[42] = 9551;
        nArray[43] = 9554;
        nArray[44] = 9557;
        nArray[45] = 9560;
        nArray[46] = 9563;
        nArray[47] = 9566;
        nArray[48] = 9567;
        nArray[49] = 9568;
        nArray[50] = 9569;
        nArray[51] = 9570;
        nArray[52] = 9572;
        nArray[53] = 9574;
        nArray[54] = 9576;
        nArray[55] = 9577;
        nArray[56] = 9578;
        nArray[57] = 9579;
        nArray[58] = 9580;
        nArray[59] = 9581;
        nArray[60] = 9583;
        nArray[61] = 9587;
        nArray[62] = 8491;
        nArray[63] = 8492;
        JISX0201_TABLE = nArray;
        LONG_VOWEL_TABLE = new byte[]{34, 34, 36, 36, 38, 38, 40, 40, 42, 42, 34, 34, 36, 36, 38, 38, 40, 40, 42, 42, 34, 34, 36, 36, 38, 38, 40, 40, 42, 42, 34, 34, 36, 36, 38, 38, 38, 40, 40, 42, 42, 34, 36, 38, 40, 42, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, 42, 42, 34, 36, 38, 40, 42, 34, 34, 38, 38, 42, 42, 34, 36, 38, 40, 42, 34, 34, 36, 40, 42, 115, 38, 34, 40};
        VOICED_CONSONANT_TABLE = new byte[]{33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 43, 45, 45, 47, 47, 49, 49, 51, 51, 53, 53, 55, 55, 57, 57, 59, 59, 61, 61, 63, 63, 65, 65, 67, 68, 68, 70, 70, 72, 72, 74, 75, 76, 77, 78, 79, 79, 81, 82, 82, 84, 85, 85, 87, 88, 88, 90, 91, 91, 93, 94, 95, 96, 97, 98, 100, 100, 102, 102, 104, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 38, 117, 118};
    }

    private ByteUtil() {
    }

    public static int getInt2(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF;
    }

    public static int getInt3(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 16 | (b[offset + 1] & 0xFF) << 8 | b[offset + 2] & 0xFF;
    }

    public static int getIntLE2(byte[] b, int offset) {
        return (b[offset + 1] & 0xFF) << 8 | b[offset] & 0xFF;
    }

    public static int getBCD2(byte[] b, int offset) {
        int ret = b[offset + 1] & 0xF;
        ret += (b[offset + 1] >>> 4 & 0xF) * 10;
        ret += (b[offset] & 0xF) * 100;
        return ret += (b[offset] >>> 4 & 0xF) * 1000;
    }

    public static int getBCD4(byte[] b, int offset) {
        int ret = b[offset + 3] & 0xF;
        ret += (b[offset + 3] >>> 4 & 0xF) * 10;
        ret += (b[offset + 2] & 0xF) * 100;
        ret += (b[offset + 2] >>> 4 & 0xF) * 1000;
        ret += (b[offset + 1] & 0xF) * 10000;
        ret += (b[offset + 1] >>> 4 & 0xF) * 100000;
        ret += (b[offset] & 0xF) * 1000000;
        return ret += (b[offset] >>> 4 & 0xF) * 10000000;
    }

    public static long getLong4(byte[] b, int offset) {
        long ret = (b[offset] & 0xFF) << 24;
        ret += (long)((b[offset + 1] & 0xFF) << 16);
        ret += (long)((b[offset + 2] & 0xFF) << 8);
        return ret += (long)(b[offset + 3] & 0xFF);
    }

    public static long getLongLE4(byte[] b, int offset) {
        long ret = (b[offset + 3] & 0xFF) << 24;
        ret += (long)((b[offset + 2] & 0xFF) << 16);
        ret += (long)((b[offset + 1] & 0xFF) << 8);
        return ret += (long)(b[offset] & 0xFF);
    }

    public static String narrowToWide(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case ' ': {
                    buf.append(12288);
                    break;
                }
                case '\'': {
                    buf.append(8217);
                    break;
                }
                case '\"': {
                    buf.append(8221);
                    break;
                }
                default: {
                    if (ch >= '!' && ch <= '~') {
                        ch = (char)(ch + 65248);
                    }
                    buf.append(ch);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String wideToNarrow(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u3000': {
                    buf.append(' ');
                    break;
                }
                case '\u2019': {
                    buf.append('\'');
                    break;
                }
                case '\u2212': {
                    buf.append('-');
                    break;
                }
                case '\u201d': {
                    buf.append('\"');
                    break;
                }
                case '\uffe3': {
                    buf.append('~');
                    break;
                }
                default: {
                    if (ch >= '\uff01' && ch <= '\uff5e') {
                        ch = (char)(ch - 65248);
                    }
                    buf.append(ch);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String gb2312ToString(byte[] b) {
        return ByteUtil.jisx0208ToString(b, 0, b.length);
    }

    public static String gb2312ToString(byte[] b, int offset, int len) {
        byte[] buf = new byte[len];
        int i = 0;
        while (i < len / 2) {
            if (b[offset + i * 2] != 0) {
                buf[i * 2] = (byte)(b[offset + i * 2] | 0x80);
                buf[i * 2 + 1] = b[offset + i * 2 + 1];
            } else {
                buf[i * 2] = 0;
                buf[i * 2 + 1] = 0;
            }
            ++i;
        }
        String str = null;
        try {
            str = new String(buf, "EUC-CN");
        }
        catch (UnsupportedEncodingException e) {
            str = new String(buf);
        }
        return str.trim();
    }

    public static String jisx0208ToString(byte[] b) {
        return ByteUtil.jisx0208ToString(b, 0, b.length);
    }

    public static String jisx0208ToString(byte[] b, int offset, int len) {
        byte[] buf = new byte[len];
        int i = 0;
        while (i < len) {
            buf[i] = b[offset + i] != 0 ? (byte)(b[offset + i] | 0x80) : (byte)0;
            ++i;
        }
        String str = null;
        try {
            str = new String(buf, "EUC-JP");
        }
        catch (UnsupportedEncodingException e) {
            str = new String(buf);
        }
        return str.trim();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] stringToJISX0208(String str) {
        byte[] b;
        if (str == null || str.length() <= 0) {
            return null;
        }
        String s = str.replace('\t', ' ').trim();
        StringBuffer buf = new StringBuffer(s);
        while (buf.charAt(0) == '\u3000') {
            buf.deleteCharAt(0);
        }
        int len = buf.length();
        while (buf.charAt(len - 1) == '\u3000') {
            buf.deleteCharAt(len - 1);
            len = buf.length();
        }
        try {
            b = buf.toString().getBytes("EUC-JP");
        }
        catch (UnsupportedEncodingException e) {
            b = buf.toString().getBytes();
        }
        int size = b.length;
        if (size <= 0) {
            return null;
        }
        byte[] tmp = new byte[size * 2];
        len = 0;
        int i = 0;
        while (i < size) {
            void var9_11;
            int low;
            int c;
            int high = b[i] & 0xFF;
            if (high >= 32 && high <= 126) {
                c = JISX0208_TABLE[high - 32];
                high = c >>> 8;
                low = c & 0xFF;
            } else if (high >= 161 && high <= 254) {
                low = b[i + 1] & 0xFF;
                if (low >= 161 && low <= 254) {
                    high &= 0x7F;
                    low &= 0x7F;
                } else {
                    return null;
                }
                ++i;
            } else if (high == 142) {
                low = b[i + 1] & 0xFF;
                if (low < 161 || low > 223) {
                    return null;
                }
                c = JISX0201_TABLE[low - 160];
                high = c >>> 8;
                low = c & 0xFF;
                ++i;
            } else {
                return null;
            }
            tmp[len] = (byte)high;
            tmp[len + 1] = (byte)var9_11;
            len += 2;
            ++i;
        }
        byte[] ret = new byte[len];
        System.arraycopy(tmp, 0, ret, 0, len);
        return ret;
    }

    public static void katakanaToHiragana(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high == 37 && low >= 33 && low <= 118) {
                b[i] = 36;
            }
            i += 2;
        }
    }

    public static void hiraganaToKatakana(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high == 36 && low >= 33 && low <= 118) {
                b[i] = 37;
            }
            i += 2;
        }
    }

    public static void upperToLowerLatin(byte[] b) {
        int len = b.length;
        int i = 0;
        while (i < len) {
            int ch = b[i] & 0xFF;
            if (ch == 0) break;
            if (ch >= 65 && ch <= 90 || ch >= 192 && ch <= 214 || ch >= 216 && ch <= 222) {
                b[i] = (byte)(ch + 32);
            }
            ++i;
        }
    }

    public static void lowerToUpperLatin(byte[] b) {
        int len = b.length;
        int i = 0;
        while (i < len) {
            int ch = b[i] & 0xFF;
            if (ch == 0) break;
            if (ch >= 97 && ch <= 122 || ch >= 224 && ch <= 246 || ch >= 248 && ch <= 254) {
                b[i] = (byte)(ch - 32);
            }
            ++i;
        }
    }

    public static void upperToLower(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high == 35 && low >= 65 && low <= 90) {
                b[i + 1] = (byte)(low + 32);
            }
            i += 2;
        }
    }

    public static void lowerToUpper(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high == 35 && low >= 97 && low <= 122) {
                b[i + 1] = (byte)(low - 32);
            }
            i += 2;
        }
    }

    public static void convertLongVowel(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int prevHigh = 0;
        int prevLow = 0;
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high == 33 && low == 60 && (prevHigh == 36 || prevHigh == 37) && prevLow >= 33 && prevLow <= 118) {
                b[i] = (byte)prevHigh;
                b[i + 1] = LONG_VOWEL_TABLE[prevLow - 33];
            }
            prevHigh = high;
            prevLow = low;
            i += 2;
        }
    }

    public static void deleteLongVowel(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int count = 0;
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) {
                count = count + len - i;
                break;
            }
            if (high == 33 && low == 60) {
                count += 2;
            } else {
                b[i - count] = (byte)high;
                b[i - count + 1] = (byte)low;
            }
            i += 2;
        }
        if (count > 0) {
            int size = b.length;
            int i2 = len - count;
            while (i2 < size) {
                b[i2] = 0;
                ++i2;
            }
        }
    }

    public static void convertDoubleConsonant(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if ((high == 36 || high == 37) && low == 67) {
                b[i + 1] = 68;
            }
            i += 2;
        }
    }

    public static void convertContractedSound(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high == 36 || high == 37) {
                if (low == 99 || low == 101 || low == 103 || low == 110) {
                    b[i + 1] = (byte)(low + 1);
                } else if (low == 117) {
                    b[i + 1] = 43;
                } else if (low == 118) {
                    b[i + 1] = 49;
                }
            }
            i += 2;
        }
    }

    public static void convertVoicedConsonant(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if ((high == 36 || high == 37) && low >= 33 && low <= 118) {
                b[i + 1] = VOICED_CONSONANT_TABLE[low - 33];
            }
            i += 2;
        }
    }

    public static void convertSmallVowel(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (!(high != 36 && high != 37 || low != 33 && low != 35 && low != 37 && low != 39 && low != 41)) {
                b[i + 1] = (byte)(low + 1);
            }
            i += 2;
        }
    }

    public static void convertPSound(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (!(high != 36 && high != 37 || low != 81 && low != 84 && low != 87 && low != 90 && low != 93)) {
                b[i + 1] = (byte)(low - 2);
            }
            i += 2;
        }
    }

    public static void deleteMark(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int count = 0;
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) {
                count = count + len - i;
                break;
            }
            if (high == 33 && (low == 38 || low == 62 || low == 71 || low == 93)) {
                count += 2;
            } else {
                b[i - count] = (byte)high;
                b[i - count + 1] = (byte)low;
            }
            i += 2;
        }
        if (count > 0) {
            int size = b.length;
            int i2 = len - count;
            while (i2 < size) {
                b[i2] = 0;
                ++i2;
            }
        }
    }

    public static void deleteSpaceLatin(byte[] b) {
        int count = 0;
        int len = b.length;
        int i = 0;
        while (i < len) {
            int ch = b[i] & 0xFF;
            if (ch == 0) {
                count = count + len - i;
                break;
            }
            if (ch == 32) {
                ++count;
            } else {
                b[i - count] = (byte)ch;
            }
            ++i;
        }
        if (count > 0) {
            i = len - count;
            while (i < len) {
                b[i] = 0;
                ++i;
            }
        }
    }

    public static void deleteSpace(byte[] b) {
        int len = b.length;
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        int count = 0;
        int i = 0;
        while (i < len) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) {
                count = count + len - i;
                break;
            }
            if (high == 33 && low == 33) {
                count += 2;
            } else {
                b[i - count] = (byte)high;
                b[i - count + 1] = (byte)low;
            }
            i += 2;
        }
        if (count > 0) {
            int size = b.length;
            int i2 = len - count;
            while (i2 < size) {
                b[i2] = 0;
                ++i2;
            }
        }
    }

    public static void reverseWordLatin(byte[] b) {
        int len = 0;
        int size = b.length;
        int i = size - 1;
        while (i >= 0) {
            if ((b[i] & 0xFF) != 0) {
                len = i + 1;
                break;
            }
            --i;
        }
        i = 0;
        while (i < len / 2) {
            byte tmp = b[i];
            b[i] = b[size - 1 - i];
            b[size - 1 - i] = tmp;
            ++i;
        }
    }

    public static void reverseWord(byte[] b) {
        int len = 0;
        int i = b.length - 1;
        while (i >= 0) {
            if ((b[i] & 0xFF) != 0) {
                len = i + 1;
                break;
            }
            --i;
        }
        if (len % 2 == 1) {
            b[len - 1] = 0;
            --len;
        }
        i = 0;
        while (i < len / 2) {
            byte tmp = b[i];
            b[i] = b[len - 2 - i];
            b[len - 2 - i] = tmp;
            tmp = b[i + 1];
            b[i + 1] = b[len - 1 - i];
            b[len - 1 - i] = tmp;
            i += 2;
        }
    }
}

