/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.tool;

import fuku.eb4j.Book;
import fuku.eb4j.EBException;
import fuku.eb4j.ExtFont;
import fuku.eb4j.SubBook;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.io.EBZipConstants;
import fuku.eb4j.io.EBZipInputStream;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.zip.Adler32;
import java.util.zip.Deflater;

public final class EBZip
implements EBZipConstants {
    private static final String _PROGRAM = "fuku.eb4j.tool.EBZip";
    private static final String DEFAULT_BOOK_DIR = ".";
    private static final String DEFAULT_OUTPUT_DIR = ".";
    private static final int OVERWRITE_NO = 0;
    private static final int OVERWRITE_QUERY = 1;
    private static final int OVERWRITE_FORCE = 2;
    private static final int ACTION_ZIP = 0;
    private static final int ACTION_UNZIP = 1;
    private static final int ACTION_INFO = 2;
    private static final DecimalFormat FMT = new DecimalFormat("##0.0'%'");
    private static final LongOpt[] LONGOPT = new LongOpt[]{new LongOpt("force-overwrite", 0, null, 102), new LongOpt("no-overwrite", 0, null, 110), new LongOpt("information", 0, null, 105), new LongOpt("keep", 0, null, 107), new LongOpt("level", 1, null, 108), new LongOpt("gzip", 1, null, 103), new LongOpt("outpur-directory", 1, null, 111), new LongOpt("quiet", 0, null, 113), new LongOpt("skip-content", 1, null, 115), new LongOpt("subbook", 1, null, 83), new LongOpt("compress", 0, null, 122), new LongOpt("uncompress", 0, null, 117), new LongOpt("test", 0, null, 116), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118)};
    private static String _bookDir = ".";
    private static String _outDir = ".";
    private static String[] _subbooks = null;
    private static int _overwrite = 1;
    private static int _level = 0;
    private static int _gzip = 6;
    private static boolean _keep = false;
    private static boolean _quiet = false;
    private static boolean _test = false;
    private static boolean _skipFont = false;
    private static boolean _skipSound = false;
    private static boolean _skipGraphic = false;
    private static boolean _skipMovie = false;

    public static void main(String[] args) {
        int idx;
        int c;
        Getopt g = new Getopt(_PROGRAM, args, "fnikl:g:o:qs:S:zuthv", LONGOPT);
        int action = 0;
        StringTokenizer st = null;
        ArrayList<String> list = new ArrayList<String>(4);
        block23: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 102: {
                    _overwrite = 2;
                    break;
                }
                case 110: {
                    _overwrite = 0;
                    break;
                }
                case 105: {
                    action = 2;
                    break;
                }
                case 107: {
                    _keep = true;
                    break;
                }
                case 108: {
                    String level = g.getOptarg();
                    try {
                        _level = Integer.parseInt(level);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("fuku.eb4j.tool.EBZip: invalid compression level `" + level + "'");
                        System.exit(1);
                    }
                    if (_level <= 3 && _level >= 0) continue block23;
                    System.err.println("fuku.eb4j.tool.EBZip: invalid compression level `" + level + "'");
                    System.exit(1);
                    break;
                }
                case 103: {
                    String gzip = g.getOptarg();
                    try {
                        _gzip = Integer.parseInt(gzip);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("fuku.eb4j.tool.EBZip: invalid gzip level `" + gzip + "'");
                        System.exit(1);
                    }
                    if (_gzip <= 9 && _gzip >= 0) continue block23;
                    System.err.println("fuku.eb4j.tool.EBZip: invalid gzip level `" + gzip + "'");
                    System.exit(1);
                    break;
                }
                case 111: {
                    _outDir = g.getOptarg();
                    break;
                }
                case 113: {
                    _quiet = true;
                    break;
                }
                case 115: {
                    st = new StringTokenizer(g.getOptarg(), ",");
                    while (st.hasMoreTokens()) {
                        String skip = st.nextToken().trim().toLowerCase();
                        if (skip.equals("font")) {
                            _skipFont = true;
                            continue;
                        }
                        if (skip.equals("sound")) {
                            _skipSound = true;
                            continue;
                        }
                        if (skip.equals("graphic")) {
                            _skipGraphic = true;
                            continue;
                        }
                        if (skip.equals("movie")) {
                            _skipMovie = true;
                            continue;
                        }
                        System.err.println("fuku.eb4j.tool.EBZip: invalid content name `" + skip + "'");
                        System.exit(1);
                    }
                    continue block23;
                }
                case 83: {
                    st = new StringTokenizer(g.getOptarg(), ",");
                    while (st.hasMoreTokens()) {
                        list.add(st.nextToken().trim().toLowerCase());
                    }
                    continue block23;
                }
                case 122: {
                    action = 0;
                    break;
                }
                case 117: {
                    action = 1;
                    break;
                }
                case 116: {
                    _test = true;
                    break;
                }
                case 104: {
                    EBZip._usage(0);
                    break;
                }
                case 118: {
                    EBZip._version();
                    break;
                }
                default: {
                    EBZip._usage(1);
                }
            }
        }
        if (!list.isEmpty()) {
            _subbooks = list.toArray(new String[0]);
        }
        if ((idx = g.getOptind()) + 1 == args.length) {
            _bookDir = args[idx];
        } else if (idx + 1 < args.length) {
            System.err.println("fuku.eb4j.tool.EBZip: too many arguments");
            EBZip._usage(1);
        }
        EBZip ebzip = new EBZip();
        try {
            ebzip._exec(action);
        }
        catch (EBException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
    }

    private static void _usage(int status) {
        if (status != 0) {
            System.out.println("Try `java fuku.eb4j.tool.EBZip --help' for more information");
        } else {
            System.out.println("Usage: java fuku.eb4j.tool.EBZip [option...] [book-directory]");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("  -f, --force-overwrite      force overwrite of output files");
            System.out.println("  -n, --no-overwrite         don't overwrite output files");
            System.out.println("  -i, --information          list information of compressed files");
            System.out.println("  -k, --keep                 keep (don't delete) original files");
            System.out.println("  -l INTEGER, --level INTEGER");
            System.out.println("                             compression level; 0..3");
            System.out.println("                             (default: 0)");
            System.out.println("  -g INTEGER, --gzip INTEGER");
            System.out.println("                             gzip level; 0..9");
            System.out.println("                             (default: 6)");
            System.out.println("  -o DIRECTORY, --output-directory DIRECTORY");
            System.out.println("                             output files under DIRECTORY");
            System.out.println("                             (default: .)");
            System.out.println("  -q, --quiet                suppress all warnings");
            System.out.println("  -s TYPE[,TYPE], --skip-content TYPE[,TYPE]");
            System.out.println("                             skip content; font, graphic, sound or movie");
            System.out.println("                             (default: none is skipped)");
            System.out.println("  -S SUBBOOK[,SUBBOOK], --subbook SUBBOOK[,SUBBOOK]");
            System.out.println("                             target subbook");
            System.out.println("                             (default: all subbook)");
            System.out.println("  -z, --compress             compress files");
            System.out.println("  -u, --uncompress           uncompress files");
            System.out.println("  -t, --test                 only check for input files");
            System.out.println("  -h, --help                 display this help and exit");
            System.out.println("  -v, --version              output version information and exit");
            System.out.println("");
            System.out.println("Argument:");
            System.out.println("  book-directory             top directory of a book");
            System.out.println("                             (default: .)");
            System.out.println("");
            System.out.println("Report bugs to <fukumoto@users.sourceforge.jp>.");
        }
        System.exit(status);
    }

    private static void _version() {
        System.out.println("fuku.eb4j.tool.EBZip 0.3.3");
        System.out.println("Copyright (c) 2002-2003 by Hisaya FUKUMOTO.");
        System.out.println("All right reserved.");
        System.exit(0);
    }

    private void _exec(int action) throws EBException {
        Book book = new Book(_bookDir);
        File root = new File(_bookDir);
        SubBook[] sub = book.getSubBooks();
        EBFile file = null;
        int i = 0;
        while (i < sub.length) {
            block30: {
                block29: {
                    if (_subbooks == null) break block29;
                    boolean show = false;
                    String dir = sub[i].getName().toLowerCase();
                    int j = 0;
                    while (j < _subbooks.length) {
                        if (_subbooks[j].equals(dir)) {
                            show = true;
                            break;
                        }
                        ++j;
                    }
                    if (!show) break block30;
                }
                if (book.getBookType() == 0) {
                    file = sub[i].getTextFile();
                    this._act(action, file);
                    if (action == 1 && file.getFormat() == 4) {
                        this._fixSEBXA(this._getOutFile(file, ".org"));
                    }
                } else {
                    File[] files;
                    file = sub[i].getTextFile();
                    this._act(action, file);
                    if (file.getName().compareToIgnoreCase("honmon2") == 0) {
                        if (!_skipSound && (file = sub[i].getSoundFile()) != null) {
                            this._act(action, file);
                        }
                        if (!_skipGraphic && (file = sub[i].getGraphicFile()) != null) {
                            if (action == 0) {
                                this._copy(file);
                            } else {
                                this._act(action, file);
                            }
                        }
                    }
                    if (!_skipFont) {
                        int j = 0;
                        while (j < 4) {
                            ExtFont font = sub[i].getFont(j);
                            if (font.hasWideFont()) {
                                file = font.getWideFontFile();
                                this._act(action, file);
                            }
                            if (font.hasNarrowFont()) {
                                file = font.getNarrowFontFile();
                                this._act(action, file);
                            }
                            ++j;
                        }
                    }
                    if (!_skipMovie && action != 2 && (files = sub[i].getMovieFileList()) != null) {
                        int j = 0;
                        while (j < files.length) {
                            this._copy(this._getOutFile(files[j], null), files[j]);
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        if (book.getBookType() == 0) {
            try {
                file = new EBFile(root, "language", 0);
                this._act(action, file);
            }
            catch (EBException eBException) {
                // empty catch block
            }
            file = new EBFile(root, "catalog", 0);
            if (action == 0) {
                this._copy(file);
            } else {
                this._act(action, file);
            }
        } else {
            file = new EBFile(root, "catalogs", 0);
            if (action == 0) {
                this._copy(file);
            } else {
                this._act(action, file);
            }
        }
    }

    private void _act(int action, EBFile file) {
        switch (action) {
            case 0: {
                this._zip(file);
                break;
            }
            case 1: {
                this._unzip(file);
                break;
            }
            case 2: {
                this._info(file);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _zip(EBFile file) {
        block39: {
            if (!EBZip._test) {
                this._mkdir(file);
            }
            f = this._getOutFile(file, ".ebz");
            if (!EBZip._quiet) {
                System.out.println("==> compress " + file.getPath() + " <==");
                System.out.println("output to " + f.getPath());
            }
            if (f.equals(file.getFile())) {
                if (EBZip._quiet != false) return;
                System.out.println("the input and output files are the same, skipped.");
                System.out.println("");
                return;
            }
            if (!EBZip._test && !this._isOverwrite(f)) {
                return;
            }
            bis = null;
            channel = null;
            try {
                try {
                    bis = file.getInputStream();
                    sliceSize = 2048 << EBZip._level;
                    fileSize = bis.getFileSize();
                    indexSize = 0;
                    indexSize = fileSize < 65536L ? 2 : (fileSize < 0x1000000L ? 3 : 4);
                    totalSlice = (int)((fileSize + (long)sliceSize - 1L) / (long)sliceSize);
                    indexLength = (totalSlice + 1) * indexSize;
                    in = new byte[sliceSize];
                    out = new byte[sliceSize + 1024];
                    slicePos = 22L + indexLength;
                    if (!EBZip._test) {
                        channel = new FileOutputStream(f).getChannel();
                        Arrays.fill(out, 0, out.length, (byte)0);
                        i = slicePos;
                        while (i >= (long)sliceSize) {
                            channel.write(ByteBuffer.wrap(out, 0, sliceSize));
                            i -= (long)sliceSize;
                        }
                        if (i > 0L) {
                            channel.write(ByteBuffer.wrap(out, 0, (int)i));
                        }
                    }
                    inTotalLength = 0L;
                    outTotalLength = 0L;
                    interval = 1024 >>> EBZip._level;
                    crc32 = new Adler32();
                    def = new Deflater(EBZip._gzip);
                    i = 0;
                    while (i < totalSlice) {
                        block38: {
                            bis.seek(inTotalLength);
                            inLen = bis.read(in, 0, in.length);
                            if (inLen >= 0) ** GOTO lbl58
                            System.err.println("fuku.eb4j.tool.EBZip: failed to read the file: " + f.getPath());
                            var30_30 = null;
                            bis.close();
                            if (channel == null) return;
                            try {
                                channel.close();
                                return;
lbl58:
                                // 1 sources

                                if (inLen == 0) {
                                    System.err.println("fuku.eb4j.tool.EBZip: unexpected EOF: " + f.getPath());
                                    var30_31 = null;
                                    bis.close();
                                    if (channel == null) return;
                                    ** try [egrp 2[TRYBLOCK] [5 : 1694->1702)] { 
lbl65:
                                    // 1 sources

                                    channel.close();
                                    return;
                                }
                                if (inLen != in.length && inTotalLength + (long)inLen != fileSize) {
                                    System.err.println("fuku.eb4j.tool.EBZip: unexpected EOF: " + f.getPath());
                                    var30_32 = null;
                                    bis.close();
                                    if (channel == null) return;
                                    ** try [egrp 2[TRYBLOCK] [5 : 1694->1702)] { 
lbl74:
                                    // 1 sources

                                    channel.close();
                                    return;
                                }
                                crc32.update(in, 0, inLen);
                                if (inLen >= sliceSize) break block38;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            Arrays.fill(in, inLen, in.length, (byte)0);
                            inLen = sliceSize;
                        }
                        def.reset();
                        def.setInput(in, 0, inLen);
                        def.finish();
                        outLen = 0;
                        if (true) ** GOTO lbl98
                        return;
lbl89:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
lbl92:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                        do {
                            n = def.deflate(out, outLen, out.length - outLen);
                            outLen += n;
lbl98:
                            // 2 sources

                        } while (!def.needsInput());
                        if (outLen >= sliceSize) {
                            System.arraycopy(in, 0, out, 0, sliceSize);
                            outLen = sliceSize;
                        }
                        if (!EBZip._test) {
                            channel.position(channel.size());
                            channel.write(ByteBuffer.wrap(out, 0, outLen));
                        }
                        nextPos = slicePos + (long)outLen;
                        switch (indexSize) {
                            case 2: {
                                out[0] = (byte)(slicePos >>> 8 & 255L);
                                out[1] = (byte)(slicePos & 255L);
                                out[2] = (byte)(nextPos >>> 8 & 255L);
                                out[3] = (byte)(nextPos & 255L);
                                break;
                            }
                            case 3: {
                                out[0] = (byte)(slicePos >>> 16 & 255L);
                                out[1] = (byte)(slicePos >>> 8 & 255L);
                                out[2] = (byte)(slicePos & 255L);
                                out[3] = (byte)(nextPos >>> 16 & 255L);
                                out[4] = (byte)(nextPos >>> 8 & 255L);
                                out[5] = (byte)(nextPos & 255L);
                                break;
                            }
                            case 4: {
                                out[0] = (byte)(slicePos >>> 24 & 255L);
                                out[1] = (byte)(slicePos >>> 16 & 255L);
                                out[2] = (byte)(slicePos >>> 8 & 255L);
                                out[3] = (byte)(slicePos & 255L);
                                out[4] = (byte)(nextPos >>> 24 & 255L);
                                out[5] = (byte)(nextPos >>> 16 & 255L);
                                out[6] = (byte)(nextPos >>> 8 & 255L);
                                out[7] = (byte)(nextPos & 255L);
                                break;
                            }
                        }
                        if (!EBZip._test) {
                            channel.position(22 + i * indexSize);
                            channel.write(ByteBuffer.wrap(out, 0, indexSize * 2));
                        }
                        inTotalLength += (long)inLen;
                        outTotalLength += (long)(outLen + indexSize);
                        slicePos = nextPos;
                        if (!EBZip._quiet && i % interval + 1 == interval) {
                            rate = (double)(i + 1) / (double)totalSlice * 100.0;
                            System.out.println(String.valueOf(EBZip.FMT.format(rate)) + " done (" + inTotalLength + " / " + fileSize + " bytes)");
                        }
                        ++i;
                    }
                    def.end();
                    out[0] = 69;
                    out[1] = 66;
                    out[2] = 90;
                    out[3] = 105;
                    out[4] = 112;
                    out[5] = (byte)(16 | EBZip._level & 15);
                    out[6] = 0;
                    out[7] = 0;
                    out[8] = 0;
                    out[9] = 0;
                    out[10] = (byte)(fileSize >>> 24 & 255L);
                    out[11] = (byte)(fileSize >>> 16 & 255L);
                    out[12] = (byte)(fileSize >>> 8 & 255L);
                    out[13] = (byte)(fileSize & 255L);
                    crc = crc32.getValue();
                    out[14] = (byte)(crc >>> 24 & 255L);
                    out[15] = (byte)(crc >>> 16 & 255L);
                    out[16] = (byte)(crc >>> 8 & 255L);
                    out[17] = (byte)(crc & 255L);
                    mtime = System.currentTimeMillis();
                    out[18] = (byte)(mtime >>> 24 & 255L);
                    out[19] = (byte)(mtime >>> 16 & 255L);
                    out[20] = (byte)(mtime >>> 8 & 255L);
                    out[21] = (byte)(mtime & 255L);
                    if (!EBZip._test) {
                        channel.position(0L);
                        channel.write(ByteBuffer.wrap(out, 0, 22));
                    }
                    outTotalLength += (long)(22 + indexSize);
                    if (!EBZip._quiet) {
                        System.out.println("completed (" + fileSize + " / " + fileSize + " bytes)");
                        if (inTotalLength != 0L) {
                            rate = (double)outTotalLength / (double)bis.getRealFileSize() * 100.0;
                            System.out.println(String.valueOf(bis.getRealFileSize()) + " -> " + outTotalLength + " bytes (" + EBZip.FMT.format(rate) + ")");
                        }
                    }
                    ** GOTO lbl204
                }
                catch (EBException e) {
                    System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                }
                catch (FileNotFoundException e) {
                    System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                }
                catch (IOException e) {
                    System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                }
                catch (SecurityException e) {
                    System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                }
                ** GOTO lbl204
            }
            catch (Throwable var31_41) {
                var30_33 = null;
                bis.close();
                if (channel == null) throw var31_41;
                ** try [egrp 2[TRYBLOCK] [5 : 1694->1702)] { 
lbl202:
                // 1 sources

                channel.close();
                throw var31_41;
lbl204:
                // 6 sources

                var30_34 = null;
                bis.close();
                if (channel != null) {
                    ** try [egrp 2[TRYBLOCK] [5 : 1694->1702)] { 
lbl208:
                    // 1 sources

                    channel.close();
                }
                break block39;
lbl210:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                throw var31_41;
            }
lbl213:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
        }
        if (!EBZip._test && !EBZip._keep) {
            this._delete(file.getFile());
        }
        if (EBZip._quiet != false) return;
        System.out.println("");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _unzip(EBFile file) {
        block37: {
            block32: {
                block33: {
                    block36: {
                        block35: {
                            if (file.getFormat() == 0) {
                                this._copy(file);
                                return;
                            }
                            if (!EBZip._test) {
                                this._mkdir(file);
                            }
                            suffix = null;
                            if (file.getFormat() != 1) {
                                suffix = ".org";
                            }
                            f = this._getOutFile(file, suffix);
                            if (!EBZip._quiet) {
                                System.out.println("==> uncompress " + file.getPath() + " <==");
                                System.out.println("output to " + f.getPath());
                            }
                            if (f.equals(file.getFile())) {
                                if (EBZip._quiet != false) return;
                                System.out.println("the input and output files are the same, skipped.");
                                System.out.println("");
                                return;
                            }
                            if (!EBZip._test && !this._isOverwrite(f)) {
                                return;
                            }
                            bis = null;
                            channel = null;
                            try {
                                try {
                                    bis = file.getInputStream();
                                    b = new byte[bis.getSliceSize()];
                                    if (!EBZip._test) {
                                        channel = new FileOutputStream(f).getChannel();
                                    }
                                    totalLength = 0L;
                                    totalSlice = (int)((bis.getFileSize() + (long)bis.getSliceSize() - 1L) / (long)bis.getSliceSize());
                                    crc32 = new Adler32();
                                    i = 0;
                                    while (true) {
                                        if (i >= totalSlice) {
                                            if (!EBZip._quiet) {
                                                System.out.println("completed (" + bis.getFileSize() + " / " + bis.getFileSize() + " bytes)");
                                                System.out.println(String.valueOf(bis.getRealFileSize()) + " -> " + totalLength + " bytes");
                                            }
                                            if (!(bis instanceof EBZipInputStream) || crc32.getValue() == ((EBZipInputStream)bis).getCRC()) break block32;
                                            System.err.println("fuku.eb4j.tool.EBZip: CRC error: " + f.getPath());
                                            break block33;
                                        }
                                        bis.seek(totalLength);
                                        n = bis.read(b, 0, b.length);
                                        if (n < 0) {
                                            System.err.println("fuku.eb4j.tool.EBZip: failed to read the file: " + f.getPath());
                                            var15_17 = null;
                                            break;
                                        }
                                        if (n == 0) {
                                            System.err.println("fuku.eb4j.tool.EBZip: unexpected EOF: " + f.getPath());
                                            break block35;
                                        }
                                        if (n != b.length && totalLength + (long)n != bis.getFileSize()) {
                                            System.err.println("fuku.eb4j.tool.EBZip: unexpected EOF: " + f.getPath());
                                            break block36;
                                        }
                                        if (bis instanceof EBZipInputStream) {
                                            crc32.update(b, 0, n);
                                        }
                                        if (!EBZip._test) {
                                            channel.write(ByteBuffer.wrap(b, 0, n));
                                        }
                                        totalLength += (long)n;
                                        if (!EBZip._quiet && i % 1024 + 1 == 1024) {
                                            rate = (double)(i + 1) / (double)totalSlice * 100.0;
                                            System.out.println(String.valueOf(EBZip.FMT.format(rate)) + " done (" + totalLength + " / " + bis.getFileSize() + " bytes)");
                                        }
                                        ++i;
                                    }
                                }
                                catch (EBException e) {
                                    System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                                    break block32;
                                }
                                catch (FileNotFoundException e) {
                                    System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                                    break block32;
                                }
                                catch (IOException e) {
                                    System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                                    break block32;
                                }
                                catch (SecurityException e) {
                                    System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                                    break block32;
                                }
                                bis.close();
                                if (channel == null) return;
                            }
                            catch (Throwable var16_29) {
                                var15_21 = null;
                                bis.close();
                                if (channel == null) throw var16_29;
                                try {
                                    channel.close();
                                    throw var16_29;
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                throw var16_29;
                            }
                            ** try [egrp 2[TRYBLOCK] [5 : 836->844)] { 
lbl95:
                            // 1 sources

                            channel.close();
                            return;
lbl97:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            return;
                        }
                        var15_18 = null;
                        bis.close();
                        if (channel == null) return;
                        ** try [egrp 2[TRYBLOCK] [5 : 836->844)] { 
lbl105:
                        // 1 sources

                        channel.close();
                        return;
lbl107:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                    }
                    var15_19 = null;
                    bis.close();
                    if (channel == null) return;
                    ** try [egrp 2[TRYBLOCK] [5 : 836->844)] { 
lbl115:
                    // 1 sources

                    channel.close();
                    return;
lbl117:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                var15_20 = null;
                bis.close();
                if (channel == null) return;
                ** try [egrp 2[TRYBLOCK] [5 : 836->844)] { 
lbl125:
                // 1 sources

                channel.close();
                return;
lbl127:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            var15_22 = null;
            bis.close();
            if (channel != null) {
                ** try [egrp 2[TRYBLOCK] [5 : 836->844)] { 
lbl135:
                // 1 sources

                channel.close();
                break block37;
lbl137:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (!EBZip._test && !EBZip._keep) {
            this._delete(file.getFile());
        }
        if (EBZip._quiet != false) return;
        System.out.println("");
    }

    private void _info(EBFile file) {
        System.out.println("==> " + file.getPath() + " <==");
        BookInputStream bis = null;
        try {
            try {
                bis = file.getInputStream();
            }
            catch (EBException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                System.out.println("");
                Object var4_5 = null;
                bis.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            bis.close();
            throw throwable;
        }
        Object var4_7 = null;
        bis.close();
        StringBuffer buf = new StringBuffer();
        String text = null;
        switch (file.getFormat()) {
            case 0: {
                buf.append(bis.getFileSize());
                buf.append(" bytes (not compressed)");
                break;
            }
            case 1: {
                int level = ((EBZipInputStream)bis).getLevel();
                text = "ebzip level " + level + " compression)";
                break;
            }
            case 4: {
                text = "S-EBXA compression)";
                break;
            }
            default: {
                text = "EPWING compression)";
            }
        }
        if (text != null) {
            long size = bis.getFileSize();
            long real = bis.getRealFileSize();
            buf.append(Long.toString(size)).append(" -> ");
            buf.append(Long.toString(real)).append(" bytes (");
            if (size == 0L) {
                System.out.print("empty original file, ");
            } else {
                double rate = (double)real / (double)size * 100.0;
                buf.append(FMT.format(rate));
                buf.append(", ");
            }
            buf.append(text);
        }
        System.out.println(buf.toString());
        System.out.println("");
    }

    private void _fixSEBXA(File file) {
        if (!_quiet) {
            System.out.println("==> fix " + file.getPath() + " <==");
        }
        FileChannel channel = null;
        boolean err = false;
        try {
            try {
                channel = new RandomAccessFile(file, "rw").getChannel();
                MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_WRITE, 0L, 2048L);
                int indexCount = buf.get(1) & 0xFF;
                int removeCount = 0;
                int inOff = 16;
                int outOff = 16;
                int i = 0;
                while (i < indexCount) {
                    int index = buf.get(inOff) & 0xFF;
                    if (index == 33 || index == 34) {
                        ++removeCount;
                    } else {
                        if (inOff != outOff) {
                            int j = 0;
                            while (j < 16) {
                                buf.put(outOff + j, buf.get(inOff + j));
                                ++j;
                            }
                        }
                        outOff += 16;
                    }
                    inOff += 16;
                    ++i;
                }
                i = 0;
                while (i < removeCount) {
                    int j = 0;
                    while (j < 16) {
                        buf.put(outOff + j, (byte)0);
                        ++j;
                    }
                    outOff += 16;
                    ++i;
                }
                buf.force();
            }
            catch (FileNotFoundException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                err = true;
            }
            catch (IOException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                err = true;
            }
            catch (SecurityException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
                err = true;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        Object var12_17 = null;
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!_quiet) {
            if (!err) {
                System.out.println("complated");
            }
            System.out.println("");
        }
    }

    private File _getOutFile(EBFile file, String suffix) {
        return this._getOutFile(file.getFile(), suffix);
    }

    private File _getOutFile(File file, String suffix) {
        String bookDir = null;
        String inFile = null;
        try {
            bookDir = new File(_bookDir).getCanonicalPath();
            inFile = file.getCanonicalPath();
        }
        catch (IOException e) {
            System.err.println("fuku.eb4j.tool.EBZip: can't get canonical path");
            System.exit(1);
        }
        String fname = inFile.substring(bookDir.length());
        if (fname.length() > 4) {
            String s = fname.substring(fname.length() - 4);
            if (s.compareToIgnoreCase(".ebz") == 0) {
                fname = fname.substring(0, fname.length() - 4);
            } else if (s.compareToIgnoreCase(".org") == 0) {
                fname = fname.substring(0, fname.length() - 4);
            }
        }
        if (suffix != null) {
            fname = String.valueOf(fname) + suffix;
        }
        return new File(_outDir, fname);
    }

    private void _mkdir(EBFile file) {
        this._mkdir(this._getOutFile(file, null));
    }

    private void _mkdir(File file) {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException e) {
                System.err.println("fuku.eb4j.tool.EBZip: can't create directory (" + e.getMessage() + ")");
                System.exit(1);
            }
        }
    }

    private void _copy(EBFile file) {
        this._copy(file.getFile(), this._getOutFile(file, null));
    }

    private void _copy(File file1, File file2) {
        if (!_test) {
            this._mkdir(file2);
        }
        if (!_quiet) {
            System.out.println("==> copy " + file1.getPath() + " <==");
            System.out.println("output to " + file2.getPath());
        }
        if (file1.equals(file2)) {
            if (!_quiet) {
                System.out.println("the input and output files are the same, skipped.");
                System.out.println("");
            }
            return;
        }
        if (_test) {
            if (!_quiet) {
                System.out.println("");
            }
            return;
        }
        if (!this._isOverwrite(file2)) {
            return;
        }
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            try {
                in = new FileInputStream(file1).getChannel();
                out = new FileOutputStream(file2).getChannel();
                in.transferTo(0L, (int)in.size(), (WritableByteChannel)((Object)out));
                if (!_quiet) {
                    System.out.println("completed (" + in.size() + " / " + ((FileChannel)out).size() + " bytes)");
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            }
            catch (IOException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            }
            catch (SecurityException e) {
                System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        Object var6_10 = null;
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!_keep) {
            this._delete(file1);
        }
        if (!_quiet) {
            System.out.println("");
        }
    }

    private void _delete(File file) {
        try {
            if (!file.delete()) {
                System.err.println("fuku.eb4j.tool.EBZip: failed to delete the file: " + file.getPath());
            }
        }
        catch (SecurityException e) {
            System.err.println("fuku.eb4j.tool.EBZip: " + e.getMessage());
        }
    }

    private boolean _isOverwrite(File file) {
        if (!file.exists()) {
            return true;
        }
        if (_overwrite == 0) {
            if (!_quiet) {
                System.err.println("already exists, skip the file");
                System.err.println("");
            }
            return false;
        }
        if (_overwrite == 1) {
            while (true) {
                System.err.println("");
                System.err.println("the file already exists: " + file.getPath());
                System.err.print("do you wish to overwrite (y or n)? ");
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader(System.in));
                    String line = br.readLine();
                    if (line == null) continue;
                    if ((line = line.trim()).compareToIgnoreCase("y") != 0) {
                        if (line.compareToIgnoreCase("n") != 0) continue;
                        System.err.println("");
                        return false;
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            System.err.println("");
        }
        return true;
    }
}

