/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.tool;

import fuku.eb4j.Book;
import fuku.eb4j.EBException;
import fuku.eb4j.ExtFont;
import fuku.eb4j.SubBook;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

public final class EBInfo {
    private static final String _PROGRAM = "fuku.eb4j.tool.EBInfo";
    private static final String DEFAULT_BOOK_DIR = ".";
    private static final LongOpt[] LONGOPT = new LongOpt[]{new LongOpt("multi-search", 0, null, 109), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118)};
    private Book _book = null;

    public static void main(String[] args) {
        int c;
        Getopt g = new Getopt(_PROGRAM, args, "mhv", LONGOPT);
        boolean multi = false;
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 109: {
                    multi = true;
                    break;
                }
                case 104: {
                    EBInfo._usage(0);
                    break;
                }
                case 118: {
                    EBInfo._version();
                    break;
                }
                default: {
                    EBInfo._usage(1);
                }
            }
        }
        String path = null;
        int idx = g.getOptind();
        if (idx + 1 == args.length) {
            path = args[idx];
        } else if (idx + 1 > args.length) {
            path = DEFAULT_BOOK_DIR;
        } else {
            System.err.println("fuku.eb4j.tool.EBInfo: too many arguments");
            EBInfo._usage(1);
        }
        try {
            EBInfo ebinfo = new EBInfo(path);
            ebinfo._show(multi);
        }
        catch (EBException e) {
            System.err.println("fuku.eb4j.tool.EBInfo: " + e.getMessage());
        }
    }

    private static void _usage(int status) {
        if (status != 0) {
            System.out.println("Try `java fuku.eb4j.tool.EBInfo --help' for more information");
        } else {
            System.out.println("Usage: java fuku.eb4j.tool.EBInfo [option...] [book-directory]");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("  -m, --multi-search         also output multi-search information");
            System.out.println("  -h, --help                 display this help and exit");
            System.out.println("  -v, --version              output version information and exit");
            System.out.println("");
            System.out.println("Argument:");
            System.out.println("  book-directory             top directory of a book");
            System.out.println("                             (default: .)");
            System.out.println("");
            System.out.println("Report bugs to <fukumoto@users.sourceforge.jp>.");
        }
        System.exit(status);
    }

    private static void _version() {
        System.out.println("fuku.eb4j.tool.EBInfo 0.3.3");
        System.out.println("Copyright (c) 2002-2003 by Hisaya FUKUMOTO.");
        System.out.println("All right reserved.");
        System.exit(0);
    }

    public EBInfo(String path) throws EBException {
        this._book = new Book(path);
    }

    private void _show(boolean multi) {
        String text = null;
        System.out.print("disc type: ");
        text = this._book.getBookType() == 0 ? "EB/EBG/EBXA/EBXA-C/S-EBXA" : (this._book.getBookType() == 1 ? "EPWING V" + this._book.getVersion() : "unknown");
        System.out.println(text);
        System.out.print("character code: ");
        switch (this._book.getCharCode()) {
            case 1: {
                text = "ISO 8859-1";
                break;
            }
            case 2: {
                text = "JIS X 0208";
                break;
            }
            case 3: {
                text = "JIS X 0208 + GB 2312";
                break;
            }
            default: {
                text = "unknown";
            }
        }
        System.out.println(text);
        System.out.print("the number of subbooks: ");
        System.out.println(this._book.getSubBookCount());
        System.out.println("");
        SubBook[] subs = this._book.getSubBooks();
        int i = 0;
        while (i < subs.length) {
            int j;
            int len;
            String hex;
            System.out.println("subbook " + (i + 1) + ":");
            System.out.println("  title: " + subs[i].getTitle());
            System.out.println("  directory: " + subs[i].getName());
            System.out.print("  search methods:");
            if (subs[i].hasWordSearch()) {
                System.out.print(" word");
            }
            if (subs[i].hasEndwordSearch()) {
                System.out.print(" endword");
            }
            if (subs[i].hasExactwordSearch()) {
                System.out.print(" exactword");
            }
            if (subs[i].hasKeywordSearch()) {
                System.out.print(" keyword");
            }
            if (subs[i].hasMultiSearch()) {
                System.out.print(" multi");
            }
            if (subs[i].hasMenu()) {
                System.out.print(" menu");
            }
            if (subs[i].hasCopyright()) {
                System.out.print(" copyright");
            }
            System.out.println("");
            System.out.print("  font sizes:");
            int j2 = 0;
            while (j2 < 4) {
                ExtFont font = subs[i].getFont(j2);
                if (font.hasFont()) {
                    System.out.print(" " + font.getFontHeight());
                }
                ++j2;
            }
            System.out.println("");
            ExtFont font = subs[i].getFont();
            System.out.print("  narrow font characters:");
            if (font.hasNarrowFont()) {
                System.out.print(" 0x");
                int code = font.getNarrowFontStart();
                hex = Integer.toHexString(code).toUpperCase();
                len = 4 - hex.length();
                if (len > 0) {
                    j = 0;
                    while (j < len) {
                        System.out.print("0");
                        ++j;
                    }
                }
                System.out.print(String.valueOf(hex) + " -- ");
                System.out.print(" 0x");
                code = font.getNarrowFontEnd();
                hex = Integer.toHexString(code).toUpperCase();
                len = 4 - hex.length();
                if (len > 0) {
                    j = 0;
                    while (j < len) {
                        System.out.print("0");
                        ++j;
                    }
                }
                System.out.print(hex);
            }
            System.out.println("");
            System.out.print("  wide font characters:");
            if (font.hasWideFont()) {
                System.out.print(" 0x");
                int code = font.getWideFontStart();
                hex = Integer.toHexString(code).toUpperCase();
                len = 4 - hex.length();
                if (len > 0) {
                    j = 0;
                    while (j < len) {
                        System.out.print("0");
                        ++j;
                    }
                }
                System.out.print(String.valueOf(hex) + " -- ");
                System.out.print(" 0x");
                code = font.getWideFontEnd();
                hex = Integer.toHexString(code).toUpperCase();
                len = 4 - hex.length();
                if (len > 0) {
                    j = 0;
                    while (j < len) {
                        System.out.print("0");
                        ++j;
                    }
                }
                System.out.print(hex);
            }
            System.out.println("");
            if (multi) {
                this._showMulti(subs[i]);
            }
            ++i;
        }
    }

    private void _showMulti(SubBook sub) {
        if (!sub.hasMultiSearch()) {
            return;
        }
        System.out.println("");
        int count = sub.getMultiCount();
        int i = 0;
        while (i < count) {
            System.out.println("  multi search " + Integer.toString(i + 1) + ":");
            int entry = sub.getMultiEntryCount(i);
            int j = 0;
            while (j < entry) {
                System.out.println("    label " + Integer.toString(j + 1) + ": " + sub.getMultiEntryLabel(i, j));
                String text = null;
                text = sub.hasMultiEntryCandidate(i, j) ? "exist" : "not-exist";
                System.out.println("     candidates: " + text);
                ++j;
            }
            ++i;
        }
    }
}

