/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.FileInfo;
import fuku.eb4j.util.ByteUtil;
import java.io.IOException;

public final class SEBXAInputStream
extends BookInputStream {
    private static final int SEBXA_SLICE_SIZE = 4096;

    SEBXAInputStream(FileInfo info) throws EBException {
        super(info);
        FileInfo fileInfo = info;
        synchronized (fileInfo) {
            if (info.realFileSize <= 0L) {
                try {
                    try {
                        this.open();
                        info.realFileSize = this._stream.length();
                    }
                    catch (IOException e) {
                        throw new EBException(4, info.file.getPath(), e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.close();
                    throw throwable;
                }
                Object var4_6 = null;
                this.close();
            }
        }
    }

    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            int n;
            if (this._info.fileSize <= this._filePos) {
                if (rlen == 0) {
                    return -1;
                }
                return rlen;
            }
            if (this._filePos < this._info.sebxaStartPos) {
                n = 0;
                n = this._info.sebxaStartPos - this._filePos < (long)(len - rlen) ? (int)(this._info.sebxaStartPos - this._filePos) : len - rlen;
                try {
                    this._stream.seek(this._filePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this._info.file.getPath(), e);
                }
                n = this.readRaw(b, off + rlen, n);
                rlen += n;
                this._filePos += (long)n;
                continue;
            }
            if (this._filePos >= this._info.sebxaEndPos) {
                try {
                    this._stream.seek(this._filePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this._info.file.getPath(), e);
                }
                this.readRawFully(b, off + rlen, len - rlen);
                this._filePos += (long)(len - rlen);
                rlen = len;
                continue;
            }
            if (this._cachePos < 0L || this._filePos < this._cachePos || this._cachePos + 4096L <= this._filePos) {
                this._cachePos = this._filePos - this._filePos % 4096L;
                long sliceIndex = (this._filePos - this._info.sebxaStartPos) / 4096L;
                long slicePos = 0L;
                if (sliceIndex == 0L) {
                    slicePos = this._info.sebxaBasePos;
                } else {
                    long pos = (sliceIndex - 1L) * 4L + this._info.sebxaIndexPos;
                    try {
                        this._stream.seek(pos);
                    }
                    catch (IOException e) {
                        throw new EBException(6, this._info.file.getPath(), e);
                    }
                    byte[] tmp = new byte[4];
                    this.readRawFully(tmp, 0, tmp.length);
                    slicePos = this._info.sebxaBasePos + ByteUtil.getLong4(tmp, 0);
                }
                try {
                    this._stream.seek(slicePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this._info.file.getPath(), e);
                }
                this._decode();
            }
            if (len - rlen < (n = (int)(4096L - this._filePos % 4096L))) {
                n = len - rlen;
            }
            if (this._info.fileSize - this._filePos < (long)n) {
                n = (int)(this._info.fileSize - this._filePos);
            }
            int p = (int)(this._filePos - this._cachePos);
            System.arraycopy(this._cache, p, b, off + rlen, n);
            rlen += n;
            this._filePos += (long)n;
        }
        return rlen;
    }

    private void _decode() throws EBException {
        int inRest = 0;
        int inOff = 0;
        int outLen = 0;
        int outOff = 0;
        byte[] b = new byte[4096];
        int len = 8;
        boolean[] flags = new boolean[len];
        boolean loop = true;
        block0: while (loop) {
            if (inRest <= 0) {
                inRest = this.readRaw(b, 0, b.length);
                if (inRest <= 0) {
                    throw new EBException(6, this._info.file.getPath());
                }
                inOff = 0;
            }
            int mask = 1;
            int i = 0;
            while (i < len) {
                flags[i] = (b[inOff] & mask) == 0;
                mask <<= 1;
                ++i;
            }
            ++inOff;
            --inRest;
            i = 0;
            while (i < len) {
                if (flags[i]) {
                    int j;
                    if (inRest <= 1) {
                        throw new EBException(6, this._info.file.getPath());
                    }
                    int c0 = b[inOff] & 0xFF;
                    int c1 = b[inOff + 1] & 0xFF;
                    int copyOff = (((c1 & 0xF0) << 4) + c0 + 18) % 4096;
                    int copyLen = (c1 & 0xF) + 3;
                    if (outLen + copyLen > 4096) {
                        copyLen = 4096 - outLen;
                    }
                    if (copyOff < outLen) {
                        j = 0;
                        while (j < copyLen) {
                            this._cache[outOff++] = b[copyOff++];
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < copyLen) {
                            this._cache[outOff++] = 0;
                            ++j;
                        }
                    }
                    inRest -= 2;
                    inOff += 2;
                    outLen += copyLen;
                } else {
                    --inRest;
                    this._cache[outOff++] = b[inOff++];
                    ++outLen;
                }
                if (outLen >= 4096) {
                    loop = false;
                    continue block0;
                }
                ++i;
            }
        }
    }
}

