/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import java.util.Collections;
import java.util.List;

final class HuffmanNode
implements Comparable {
    static final int LEAF_EOF = 0;
    static final int LEAF_8 = 1;
    static final int LEAF_16 = 2;
    static final int LEAF_32 = 3;
    private int _leafType = -1;
    private long _value = -1L;
    private int _frequency = 0;
    private HuffmanNode _left = null;
    private HuffmanNode _right = null;

    HuffmanNode(long value, int frequency, int leafType) {
        this._value = value;
        this._frequency = frequency;
        this._leafType = leafType;
    }

    HuffmanNode(HuffmanNode left, HuffmanNode right) {
        this._left = left;
        this._right = right;
        this._frequency = this._left.getFrequency() + this._right.getFrequency();
    }

    int getLeafType() {
        return this._leafType;
    }

    long getValue() {
        return this._value;
    }

    int getFrequency() {
        return this._frequency;
    }

    HuffmanNode getLeft() {
        return this._left;
    }

    HuffmanNode getRight() {
        return this._right;
    }

    boolean isLeaf() {
        return this._right == null && this._left == null;
    }

    public int compareTo(Object obj) {
        int ret = this._frequency - ((HuffmanNode)obj).getFrequency();
        return ret;
    }

    static HuffmanNode makeTree(List list) {
        while (list.size() > 1) {
            HuffmanNode node1 = (HuffmanNode)Collections.min(list);
            list.remove(node1);
            HuffmanNode node2 = (HuffmanNode)Collections.min(list);
            list.remove(node2);
            list.add(new HuffmanNode(node1, node2));
        }
        return (HuffmanNode)list.get(0);
    }
}

