/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBZipConstants;
import fuku.eb4j.io.FileInfo;
import fuku.eb4j.util.ByteUtil;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class EBZipInputStream
extends BookInputStream
implements EBZipConstants {
    EBZipInputStream(FileInfo info) throws EBException {
        super(info);
        FileInfo fileInfo = info;
        synchronized (fileInfo) {
            if (info.realFileSize <= 0L) {
                try {
                    this.open();
                    this._init();
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.close();
                    throw throwable;
                }
                Object var3_5 = null;
                this.close();
            }
        }
    }

    private void _init() throws EBException {
        try {
            this._info.realFileSize = this._stream.length();
        }
        catch (IOException e) {
            throw new EBException(4, this._info.file.getPath(), e);
        }
        byte[] b = new byte[22];
        this.readRawFully(b, 0, b.length);
        this._info.zipLevel = b[5] & 0xF;
        this._info.sliceSize = 2048 << this._info.zipLevel;
        this._info.fileSize = ByteUtil.getLong4(b, 10);
        this._info.zipCrc = ByteUtil.getLong4(b, 14);
        this._info.zipIndexSize = this._info.fileSize < 65536L ? 2 : (this._info.fileSize < 0x1000000L ? 3 : 4);
        String str = new String(b, 0, 5);
        if (!str.equals("EBZip") || b[5] >>> 4 != 1 || this._info.sliceSize > 16384) {
            throw new EBException(5, this._info.file.getPath());
        }
    }

    public int getLevel() {
        return this._info.zipLevel;
    }

    public long getCRC() {
        return this._info.zipCrc;
    }

    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            int n;
            if (this._info.fileSize <= this._filePos) {
                if (rlen == 0) {
                    return -1;
                }
                return rlen;
            }
            if (this._cachePos < 0L || this._filePos < this._cachePos || this._cachePos + 2048L <= this._filePos) {
                this._cachePos = this._filePos - this._filePos % 2048L;
                long pos = this._filePos / (long)this._info.sliceSize * (long)this._info.zipIndexSize + 22L;
                try {
                    this._stream.seek(pos);
                }
                catch (IOException e) {
                    throw new EBException(6, this._info.file.getPath(), e);
                }
                byte[] buf = new byte[this._info.zipIndexSize * 2];
                this.readRawFully(buf, 0, buf.length);
                long slicePos = 0L;
                long nextSlicePos = 0L;
                switch (this._info.zipIndexSize) {
                    case 2: {
                        slicePos = ByteUtil.getInt2(buf, 0);
                        nextSlicePos = ByteUtil.getInt2(buf, 2);
                        break;
                    }
                    case 3: {
                        slicePos = ByteUtil.getInt3(buf, 0);
                        nextSlicePos = ByteUtil.getInt3(buf, 3);
                        break;
                    }
                    case 4: {
                        slicePos = ByteUtil.getLong4(buf, 0);
                        nextSlicePos = ByteUtil.getLong4(buf, 4);
                        break;
                    }
                }
                int sliceSize = (int)(nextSlicePos - slicePos);
                int offset = (int)(this._filePos % (long)this._info.sliceSize / 2048L);
                if (sliceSize <= 0 || this._info.sliceSize < sliceSize) {
                    return -1;
                }
                try {
                    this._stream.seek(slicePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this._info.file.getPath(), e);
                }
                this._decode(offset, sliceSize);
            }
            if (len - rlen < (n = (int)(2048L - this._filePos % 2048L))) {
                n = len - rlen;
            }
            if (this._info.fileSize - this._filePos < (long)n) {
                n = (int)(this._info.fileSize - this._filePos);
            }
            int p = (int)(this._filePos % 2048L);
            System.arraycopy(this._cache, p, b, off + rlen, n);
            rlen += n;
            this._filePos += (long)n;
        }
        return rlen;
    }

    private void _decode(int offset, int size) throws EBException {
        if (size == this._info.sliceSize) {
            int i = 0;
            while (i < offset) {
                try {
                    if (this._stream.skipBytes(2048) != 2048) {
                        throw new EBException(6, this._info.file.getPath());
                    }
                }
                catch (IOException e) {
                    throw new EBException(6, this._info.file.getPath(), e);
                }
                ++i;
            }
            this.readRawFully(this._cache, 0, 2048);
        } else {
            byte[] b = new byte[2048];
            Inflater inf = new Inflater();
            inf.setInput(b, 0, 0);
            try {
                try {
                    while (inf.getTotalOut() < (offset + 1) * 2048) {
                        int tout = inf.getTotalOut();
                        int off = 0;
                        int len = 0;
                        if (tout >= offset * 2048) {
                            off = tout - offset * 2048;
                            len = 2048 - off;
                        } else {
                            len = tout < (offset - 1) * 2048 ? 2048 : offset * 2048 - tout;
                        }
                        inf.inflate(this._cache, off, len);
                        if (inf.finished() || inf.needsDictionary()) {
                            if (inf.getTotalOut() != (offset + 1) * 2048) {
                                throw new EBException(5, this._info.file.getPath());
                            }
                            Object var9_12 = null;
                            inf.end();
                            return;
                        }
                        if (!inf.needsInput()) continue;
                        int in = inf.getTotalIn();
                        len = size - in < 2048 ? size - in : 2048;
                        this.readRawFully(b, 0, len);
                        inf.setInput(b, 0, len);
                    }
                }
                catch (DataFormatException e) {
                    throw new EBException(5, this._info.file.getPath(), e);
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                inf.end();
                throw throwable;
            }
            Object var9_14 = null;
            inf.end();
        }
    }
}

