/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.EBException;
import fuku.eb4j.IndexStyle;
import fuku.eb4j.Result;
import fuku.eb4j.SearchMethod;
import fuku.eb4j.SearchSingle;
import fuku.eb4j.SubBook;
import fuku.eb4j.io.EBFile;
import java.util.ArrayList;

final class SearchMultiple
extends SearchMethod {
    private SubBook _sub = null;
    private IndexStyle _style = null;
    private IndexStyle[] _entry = null;
    private SearchSingle[] _searcher = null;

    SearchMultiple(SubBook sub, IndexStyle style) {
        this._sub = sub;
        this._style = style;
    }

    SearchMultiple(SubBook sub, IndexStyle multi, IndexStyle[] entry) {
        this._sub = sub;
        this._style = multi;
        this._entry = entry;
    }

    void search(byte[][] word, EBFile file) throws EBException {
        int len = word.length;
        ArrayList<SearchSingle> list = new ArrayList<SearchSingle>(len);
        if (this._entry == null) {
            int i = 0;
            while (i < len) {
                if (word[i] != null && word[i].length > 0) {
                    SearchSingle search = new SearchSingle(this._sub, this._style, 3);
                    search.search(word[i], file);
                    list.add(search);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (word[i] != null && word[i].length > 0) {
                    SearchSingle search = new SearchSingle(this._sub, this._entry[i], 4);
                    search.search(word[i], file);
                    list.add(search);
                }
                ++i;
            }
        }
        this._searcher = list.toArray(new SearchSingle[0]);
    }

    Result getNextResult() throws EBException {
        if (this._searcher == null || this._searcher.length <= 0) {
            return null;
        }
        Result[] result = new Result[this._searcher.length];
        return this._getAndResult(result, -1);
    }

    private Result _getAndResult(Result[] result, int index) throws EBException {
        int i;
        long pos1 = -1L;
        long pos2 = -1L;
        int max = 0;
        int len = result.length;
        if (index < 0) {
            i = 0;
            while (i < len) {
                result[i] = this._searcher[i].getNextResult();
                if (result[i] == null) {
                    return null;
                }
                pos2 = result[i].getTextPosition();
                if (pos1 < 0L) {
                    pos1 = pos2;
                    max = i;
                } else if (pos1 < pos2) {
                    pos1 = pos2;
                    max = i;
                }
                ++i;
            }
        } else {
            pos1 = result[index].getTextPosition();
            max = index;
            i = 0;
            while (i < len) {
                if (pos1 != result[i].getTextPosition()) {
                    result[i] = this._searcher[i].getNextResult();
                    if (result[i] == null) {
                        return null;
                    }
                    pos2 = result[i].getTextPosition();
                    if (pos1 < pos2) {
                        pos1 = pos2;
                        max = i;
                    }
                }
                ++i;
            }
        }
        int count = 0;
        pos1 = result[max].getTextPosition();
        int i2 = 0;
        while (i2 < len) {
            if (pos1 == result[i2].getTextPosition()) {
                ++count;
            }
            ++i2;
        }
        if (count != len) {
            return this._getAndResult(result, max);
        }
        return result[max];
    }
}

