/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.util.ByteUtil;

final class IndexStyle {
    static final int CONVERT = 0;
    static final int ASIS = 1;
    static final int REVERSE = 2;
    static final int DELETE = 2;
    private int _indexID = 0;
    private long _startPage = 0L;
    private long _endPage = 0L;
    private long _candidatePage = 0L;
    private int _space = 2;
    private int _katakana = 0;
    private int _lower = 0;
    private int _mark = 2;
    private int _longVowel = 0;
    private int _doubleConsonant = 0;
    private int _contractedSound = 0;
    private int _voicedConsonant = 0;
    private int _smallVowel = 0;
    private int _psound = 0;
    private String _label = null;

    IndexStyle() {
    }

    void setIndexID(int indexID) {
        this._indexID = indexID;
    }

    int getIndexID() {
        return this._indexID;
    }

    void setStartPage(long startPage) {
        this._startPage = startPage;
    }

    long getStartPage() {
        return this._startPage;
    }

    void setEndPage(long endPage) {
        this._endPage = endPage;
    }

    long getEndPage() {
        return this._endPage;
    }

    void setCandidatePage(long candidatePage) {
        this._candidatePage = candidatePage;
    }

    long getCandidatePage() {
        return this._candidatePage;
    }

    void setSpaceStyle(int style) {
        this._space = style;
    }

    void setKatakanaStyle(int style) {
        this._katakana = style;
    }

    void setLowerStyle(int style) {
        this._lower = style;
    }

    void setMarkStyle(int style) {
        this._mark = style;
    }

    void setLongVowelStyle(int style) {
        this._longVowel = style;
    }

    void setDoubleConsonantStyle(int style) {
        this._doubleConsonant = style;
    }

    void setContractedSoundStyle(int style) {
        this._contractedSound = style;
    }

    void setVoicedConsonantStyle(int style) {
        this._voicedConsonant = style;
    }

    void setSmallVowelStyle(int style) {
        this._smallVowel = style;
    }

    void setPSoundStyle(int style) {
        this._psound = style;
    }

    void setLabel(String label) {
        this._label = label;
    }

    String getLabel() {
        return this._label;
    }

    void fixWordLatin(byte[] b) {
        if (this._indexID == 161 && this._candidatePage != 0L) {
            return;
        }
        if (this._space == 2) {
            ByteUtil.deleteSpaceLatin(b);
        }
        if (this._lower == 0) {
            ByteUtil.lowerToUpperLatin(b);
        }
    }

    void fixWord(byte[] b) {
        if (this._indexID == 161 && this._candidatePage != 0L) {
            return;
        }
        if (this._space == 2) {
            ByteUtil.deleteSpace(b);
        }
        if (this._katakana == 0) {
            ByteUtil.katakanaToHiragana(b);
        } else if (this._katakana == 2) {
            ByteUtil.hiraganaToKatakana(b);
        }
        if (this._lower == 0) {
            ByteUtil.lowerToUpper(b);
        }
        if (this._mark == 2) {
            ByteUtil.deleteMark(b);
        }
        if (this._longVowel == 0) {
            ByteUtil.convertLongVowel(b);
        } else if (this._longVowel == 2) {
            ByteUtil.deleteLongVowel(b);
        }
        if (this._doubleConsonant == 0) {
            ByteUtil.convertDoubleConsonant(b);
        }
        if (this._contractedSound == 0) {
            ByteUtil.convertContractedSound(b);
        }
        if (this._smallVowel == 0) {
            ByteUtil.convertSmallVowel(b);
        }
        if (this._voicedConsonant == 0) {
            ByteUtil.convertVoicedConsonant(b);
        }
        if (this._psound == 0) {
            ByteUtil.convertPSound(b);
        }
    }
}

