/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.EBException;
import fuku.eb4j.SubBook;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.util.ByteUtil;

public final class ExtFont {
    static final int WIDE = 0;
    static final int NARROW = 1;
    public static final int FONT_16 = 0;
    public static final int FONT_24 = 1;
    public static final int FONT_30 = 2;
    public static final int FONT_48 = 3;
    private static final int[][] FONT_SIZE = new int[][]{{32, 72, 120, 288}, {16, 48, 60, 144}};
    private static final int[][] FONT_WIDTH = new int[][]{{16, 24, 32, 48}, {8, 16, 16, 24}};
    private static final int[] FONT_HEIGHT = new int[]{16, 24, 30, 48};
    private SubBook _sub = null;
    private int _fontType = -1;
    private EBFile[] _file = new EBFile[2];
    private long[] _page = new long[2];
    private int[] _start = new int[2];
    private int[] _end = new int[2];

    ExtFont(SubBook sub, int type) {
        this._sub = sub;
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Illegal font type: " + Integer.toString(type));
        }
        this._fontType = type;
    }

    private void _loadFont(int kind) throws EBException {
        byte[] b = new byte[16];
        BookInputStream bis = this._file[kind].getInputStream();
        try {
            bis.seek(this._page[kind], 0);
            bis.readFully(b, 0, b.length);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            bis.close();
            throw throwable;
        }
        Object var4_6 = null;
        bis.close();
        int charCount = ByteUtil.getInt2(b, 12);
        if (charCount == 0) {
            this._file[kind] = null;
            return;
        }
        this._start[kind] = ByteUtil.getInt2(b, 10);
        if (this._sub.getBook().getCharCode() == 1) {
            this._end[kind] = this._start[kind] + (charCount / 254 << 8) + charCount % 254 - 1;
            if ((this._end[kind] & 0xFF) > 254) {
                int n = kind;
                this._end[n] = this._end[n] + 3;
            }
            if ((this._start[kind] & 0xFF) < 1 || (this._start[kind] & 0xFF) > 254 || this._start[kind] < 1 || this._end[kind] > 7934) {
                throw new EBException(5, this._file[kind].getPath());
            }
        } else {
            this._end[kind] = this._start[kind] + (charCount / 94 << 8) + charCount % 94 - 1;
            if ((this._end[kind] & 0xFF) > 126) {
                int n = kind;
                this._end[n] = this._end[n] + 163;
            }
            if ((this._start[kind] & 0xFF) < 33 || (this._start[kind] & 0xFF) > 126 || this._start[kind] < 41249 || this._end[kind] > 65150) {
                throw new EBException(5, this._file[kind].getPath());
            }
        }
    }

    public EBFile getNarrowFontFile() {
        if (this._file[1] == null) {
            return null;
        }
        return this._file[1];
    }

    public EBFile getWideFontFile() {
        if (this._file[0] == null) {
            return null;
        }
        return this._file[0];
    }

    void setNarrowFont(EBFile file, long page) throws EBException {
        this._file[1] = file;
        this._page[1] = page;
        this._loadFont(1);
    }

    void setWideFont(EBFile file, long page) throws EBException {
        this._file[0] = file;
        this._page[0] = page;
        this._loadFont(0);
    }

    public boolean hasFont() {
        return this._file[1] != null || this._file[0] != null;
    }

    public boolean hasNarrowFont() {
        return this._file[1] != null;
    }

    public boolean hasWideFont() {
        return this._file[0] != null;
    }

    public int getFontType() {
        return this._fontType;
    }

    public int getFontHeight() {
        return FONT_HEIGHT[this._fontType];
    }

    public int getNarrowFontStart() {
        return this._start[1];
    }

    public int getWideFontStart() {
        return this._start[0];
    }

    public int getNarrowFontEnd() {
        return this._end[1];
    }

    public int getWideFontEnd() {
        return this._end[0];
    }

    public int getNarrowFontWidth() {
        return FONT_WIDTH[1][this._fontType];
    }

    public int getWideFontWidth() {
        return FONT_WIDTH[0][this._fontType];
    }

    public int getNarrowFontSize() {
        return FONT_SIZE[1][this._fontType];
    }

    public int getWideFontSize() {
        return FONT_SIZE[0][this._fontType];
    }

    public byte[] getNarrowFont(int code) throws EBException {
        return this._getFont(1, code);
    }

    public byte[] getWideFont(int code) throws EBException {
        return this._getFont(0, code);
    }

    private byte[] _getFont(int kind, int code) throws EBException {
        if (this._file[kind] == null) {
            return null;
        }
        if (code < this._start[kind] || code > this._end[kind]) {
            return null;
        }
        int index = 0;
        if (this._sub.getBook().getCharCode() == 1) {
            if ((code & 0xFF) < 1 || (code & 0xFF) > 254) {
                return null;
            }
            index = ((code >>> 8) - (this._start[kind] >>> 8)) * 254 + ((code & 0xFF) - (this._start[kind] & 0xFF));
        } else {
            if ((code & 0xFF) < 33 || (code & 0xFF) > 126) {
                return null;
            }
            index = ((code >>> 8) - (this._start[kind] >>> 8)) * 94 + ((code & 0xFF) - (this._start[kind] & 0xFF));
        }
        int size = FONT_SIZE[kind][this._fontType];
        int off = index / (1024 / size) * 1024 + index % (1024 / size) * size;
        byte[] b = new byte[size];
        BookInputStream bis = this._file[kind].getInputStream();
        try {
            bis.seek(this._page[kind] + 1L, off);
            bis.readFully(b, 0, b.length);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            bis.close();
            throw throwable;
        }
        Object var8_10 = null;
        bis.close();
        return b;
    }
}

