/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.Appendix;
import fuku.eb4j.EBException;
import fuku.eb4j.SubAppendix;
import fuku.eb4j.SubBook;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.util.ByteUtil;
import java.io.File;

public final class Book {
    public static final int DISC_EB = 0;
    public static final int DISC_EPWING = 1;
    public static final int CHARCODE_ISO8859_1 = 1;
    public static final int CHARCODE_JISX0208 = 2;
    public static final int CHARCODE_JISX0208_GB2312 = 3;
    static final int[] SIZE_CATALOG = new int[]{40, 164};
    static final int[] SIZE_TITLE = new int[]{30, 80};
    static final int SIZE_DIRNAME = 8;
    private static final String[] MISLEADED = new String[]{"%;%s%A%e%j!\\%S%8%M%9!\\%/%i%&%s", "8&5f<R!!?71QOBCf<-E5", "#E#B2J3X5;=QMQ8lBg<-E5", "#E#N#G!?#J#A#N!J!\\#S#P#A!K"};
    private String _bookPath = null;
    private int _bookType = -1;
    private int _charCode = -1;
    private int _version = -1;
    private SubBook[] _sub = null;

    public Book(String bookPath) throws EBException {
        this(bookPath, null);
    }

    public Book(String bookPath, String appendixPath) throws EBException {
        Appendix appendix;
        SubAppendix[] sa;
        this._bookPath = bookPath;
        File dir = new File(bookPath);
        if (!dir.exists()) {
            throw new EBException(0, bookPath);
        }
        if (!dir.canRead()) {
            throw new EBException(1, bookPath);
        }
        this._loadLanguage(dir);
        this._loadCatalog(dir);
        if (appendixPath != null && appendixPath.length() > 0 && (sa = (appendix = new Appendix(appendixPath)).getSubAppendixes()) != null) {
            int len = sa.length;
            if (len > this._sub.length) {
                len = this._sub.length;
            }
            int i = 0;
            while (i < len) {
                this._sub[i].setAppendix(sa[i]);
                ++i;
            }
        }
    }

    public String getPath() {
        return this._bookPath;
    }

    public int getBookType() {
        return this._bookType;
    }

    public int getCharCode() {
        return this._charCode;
    }

    public int getSubBookCount() {
        int ret = 0;
        if (this._sub != null) {
            ret = this._sub.length;
        }
        return ret;
    }

    public SubBook[] getSubBooks() {
        return this._sub;
    }

    public SubBook getSubBook(int index) {
        if (index < 0 || index >= this._sub.length) {
            return null;
        }
        return this._sub[index];
    }

    public int getVersion() {
        return this._version;
    }

    private void _loadCatalog(File dir) throws EBException {
        EBFile file = null;
        try {
            file = new EBFile(dir, "catalog", 0);
            this._bookType = 0;
            this._loadCatalogEB(file);
        }
        catch (EBException e) {
            file = new EBFile(dir, "catalogs", 0);
            this._bookType = 1;
            this._loadCatalogEPWING(file);
        }
    }

    private void _loadCatalogEB(EBFile file) throws EBException {
        BookInputStream bis = file.getInputStream();
        try {
            byte[] b = new byte[16];
            bis.readFully(b, 0, b.length);
            int subCount = ByteUtil.getInt2(b, 0);
            if (subCount <= 0) {
                throw new EBException(5, file.getPath());
            }
            this._sub = new SubBook[subCount];
            b = new byte[SIZE_CATALOG[0]];
            int i = 0;
            while (i < subCount) {
                bis.readFully(b, 0, b.length);
                int off = 2;
                String title = null;
                if (this._charCode == 1) {
                    title = new String(b, off, SIZE_TITLE[0]).trim();
                    int j = 0;
                    while (j < MISLEADED.length) {
                        if (title.equals(MISLEADED[j])) {
                            this._charCode = 2;
                            byte[] tmp = title.getBytes();
                            title = ByteUtil.jisx0208ToString(tmp, 0, tmp.length);
                            break;
                        }
                        ++j;
                    }
                } else {
                    title = ByteUtil.jisx0208ToString(b, off, SIZE_TITLE[0]);
                }
                String name = new String(b, off += SIZE_TITLE[0], 8).trim();
                off += 8;
                String[] fname = new String[3];
                int[] format = new int[3];
                fname[0] = "start";
                format[0] = 0;
                this._sub[i] = new SubBook(this, title, name, 1, fname, format, null, null);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            bis.close();
            throw throwable;
        }
        Object var11_14 = null;
        bis.close();
    }

    private void _loadCatalogEPWING(EBFile file) throws EBException {
        BookInputStream bis = file.getInputStream();
        try {
            byte[] b = new byte[16];
            bis.readFully(b, 0, b.length);
            int subCount = ByteUtil.getInt2(b, 0);
            if (subCount <= 0) {
                throw new EBException(5, file.getPath());
            }
            this._version = b[3] & 0xFF;
            this._sub = new SubBook[subCount];
            b = new byte[SIZE_CATALOG[1]];
            int i = 0;
            while (i < subCount) {
                bis.seek(16 + i * b.length);
                bis.readFully(b, 0, b.length);
                int off = 2;
                String title = null;
                if (this._charCode == 1) {
                    title = new String(b, off, SIZE_TITLE[1]).trim();
                    int j = 0;
                    while (j < MISLEADED.length) {
                        if (title.equals(MISLEADED[j])) {
                            this._charCode = 2;
                            byte[] tmp = title.getBytes();
                            title = ByteUtil.jisx0208ToString(tmp, 0, tmp.length);
                            break;
                        }
                        ++j;
                    }
                } else {
                    title = ByteUtil.jisx0208ToString(b, off, SIZE_TITLE[1]);
                }
                String name = new String(b, off += SIZE_TITLE[1], 8).trim();
                int index = ByteUtil.getInt2(b, (off += 8) + 4);
                off += 6;
                String[] narrow = new String[4];
                String[] wide = new String[4];
                off += 4;
                int j = 0;
                while (j < 4) {
                    if (b[off] != 0 && b[off] < 128) {
                        wide[j] = new String(b, off, 8).trim();
                    }
                    if (b[off + 32] != 0 && b[off + 32] < 128) {
                        narrow[j] = new String(b, off + 32, 8).trim();
                    }
                    off += 8;
                    ++j;
                }
                bis.seek(16 + (subCount + i) * b.length);
                bis.readFully(b, 0, b.length);
                String[] fname = new String[3];
                int[] format = new int[3];
                if ((b[4] & 0xFF) != 0) {
                    fname[0] = new String(b, 4, 8).trim();
                    format[0] = b[55] & 0xFF;
                    int dataType = ByteUtil.getInt2(b, 41);
                    if ((dataType & 3) == 2) {
                        fname[1] = new String(b, 44, 8).trim();
                        format[1] = b[54] & 0xFF;
                    } else if ((dataType >>> 8 & 3) == 2) {
                        fname[1] = new String(b, 56, 8).trim();
                        format[1] = b[53] & 0xFF;
                    }
                    if ((dataType & 3) == 1) {
                        fname[2] = new String(b, 44, 8).trim();
                        format[2] = b[54] & 0xFF;
                    } else if ((dataType >>> 8 & 3) == 1) {
                        fname[2] = new String(b, 56, 8).trim();
                        format[2] = b[53] & 0xFF;
                    }
                    int j2 = 0;
                    while (j2 < 3) {
                        switch (format[j2]) {
                            case 0: {
                                format[j2] = 0;
                                break;
                            }
                            case 17: {
                                format[j2] = 2;
                                break;
                            }
                            case 18: {
                                format[j2] = 3;
                                break;
                            }
                            default: {
                                throw new EBException(5, file.getPath());
                            }
                        }
                        ++j2;
                    }
                } else {
                    fname[0] = "honmon";
                    format[0] = 0;
                }
                this._sub[i] = new SubBook(this, title, name, index, fname, format, narrow, wide);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            bis.close();
            throw throwable;
        }
        Object var16_21 = null;
        bis.close();
    }

    private void _loadLanguage(File dir) throws EBException {
        block8: {
            this._charCode = 2;
            EBFile file = null;
            try {
                file = new EBFile(dir, "language", 0);
            }
            catch (EBException eBException) {
                // empty catch block
            }
            if (file == null) {
                return;
            }
            BookInputStream bis = file.getInputStream();
            try {
                byte[] b = new byte[16];
                if (bis.read(b, 0, b.length) != b.length) {
                    Object var5_6 = null;
                    if (bis != null) {
                        bis.close();
                    }
                    return;
                }
                this._charCode = ByteUtil.getInt2(b, 0);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (bis != null) {
                    bis.close();
                }
                throw throwable;
            }
            Object var5_8 = null;
            if (bis == null) break block8;
            bis.close();
        }
    }
}

