/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.EBException;
import fuku.eb4j.IndexStyle;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.util.ByteUtil;

public final class BinaryData {
    private static final int COLOR_GRAPHIC_HEADER = 8;
    private EBFile _file = null;
    private IndexStyle _style = null;

    BinaryData(EBFile file, IndexStyle style) {
        this._file = file;
        this._style = style;
    }

    public byte[] getMonoGraphic(long pos, int width, int height) throws EBException {
        byte[] img = null;
        BookInputStream bis = this._file.getInputStream();
        try {
            if (width == 0 && height == 0) {
                byte[] b = new byte[22];
                bis.seek(pos);
                bis.readFully(b, 0, b.length);
                if (ByteUtil.getInt2(b, 0) != 8005 || ByteUtil.getInt2(b, 4) != 7985) {
                    throw new EBException(5, this._file.getPath());
                }
                width = ByteUtil.getBCD2(b, 8);
                height = ByteUtil.getBCD2(b, 10);
                if (ByteUtil.getInt2(b, 12) == 8017) {
                    pos = BookInputStream.getPosition(ByteUtil.getBCD4(b, 14), ByteUtil.getBCD2(b, 18));
                } else if (ByteUtil.getInt2(b, 14) == 8017) {
                    pos = BookInputStream.getPosition(ByteUtil.getBCD4(b, 16), ByteUtil.getBCD2(b, 20));
                } else {
                    throw new EBException(5, this._file.getPath());
                }
            }
            if (width <= 0 || height <= 0) {
                byte[] byArray = null;
                Object var8_9 = null;
                bis.close();
                return byArray;
            }
            bis.seek(pos);
            int size = (width + 7) / 8 * height;
            img = new byte[size];
            bis.readFully(img, 0, img.length);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            bis.close();
            throw throwable;
        }
        Object var8_11 = null;
        bis.close();
        return img;
    }

    public byte[] getColorGraphic(long pos) throws EBException {
        byte[] img = null;
        BookInputStream bis = this._file.getInputStream();
        try {
            bis.seek(pos);
            byte[] b = new byte[8];
            bis.readFully(b, 0, b.length);
            int size = 0;
            if (new String(b, 0, 4).equals("data")) {
                size = (int)ByteUtil.getLongLE4(b, 4);
            }
            img = new byte[size];
            bis.readFully(img, 0, img.length);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            bis.close();
            throw throwable;
        }
        Object var7_8 = null;
        bis.close();
        return img;
    }

    public byte[] getWaveSound(long pos1, long pos2) throws EBException {
        long size = 0L;
        if (pos1 >= pos2) {
            throw new EBException(5, this._file.getPath());
        }
        size = pos2 - pos1;
        byte[] wave = new byte[(int)(44L + size)];
        wave[0] = 82;
        wave[1] = 73;
        wave[2] = 70;
        wave[3] = 70;
        wave[4] = (byte)(36L + size & 0xFFL);
        wave[5] = (byte)(36L + size >>> 8 & 0xFFL);
        wave[6] = (byte)(36L + size >>> 16 & 0xFFL);
        wave[7] = (byte)(36L + size >>> 24 & 0xFFL);
        wave[8] = 87;
        wave[9] = 65;
        wave[10] = 86;
        wave[11] = 69;
        BookInputStream bis = this._file.getInputStream();
        try {
            bis.seek(pos1);
            byte[] b = new byte[4];
            bis.readFully(b, 0, b.length);
            int off = 0;
            if (new String(b, 0, 4).equals("fmt ")) {
                System.arraycopy(b, 0, wave, 12, 4);
                off = 16;
            } else {
                bis.seek(this._style.getStartPage(), 32);
                b = new byte[28];
                bis.readFully(b, 0, b.length);
                wave[40] = (byte)(size & 0xFFL);
                wave[41] = (byte)(size >>> 8 & 0xFFL);
                wave[42] = (byte)(size >>> 16 & 0xFFL);
                wave[43] = (byte)(size >>> 24 & 0xFFL);
                off = 44;
                bis.seek(pos1);
            }
            bis.readFully(wave, off, wave.length - off);
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            bis.close();
            throw throwable;
        }
        Object var11_10 = null;
        bis.close();
        return wave;
    }
}

