/*
 * Decompiled with CFR 0.152.
 */
package org.ocharake.matobaa.dictionary.pdicw;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.ocharake.matobaa.dictionary.IDictionary;
import org.ocharake.matobaa.dictionary.pdicw.Header;
import org.ocharake.matobaa.dictionary.pdicw.Index;
import org.ocharake.matobaa.dictionary.pdicw.RandomAccessFileBigEndian;

public class PDICW
implements IDictionary {
    private String heading;
    Index[] index = null;
    private RandomAccessFileBigEndian file;
    private Header header;

    public static void main(String[] args) {
        PDICW dict = new PDICW();
        dict.setDictionary("c:\\PDIC\\gene.DIC");
        long start = System.currentTimeMillis();
        System.out.println("GENE>>> " + dict.query("eclipse"));
        System.out.println(System.currentTimeMillis() - start);
        dict.setDictionary("c:\\PDIC\\EIJIRO52.DIC");
        start = System.currentTimeMillis();
        System.out.println("Eijiro>>> " + dict.query("cost"));
        System.out.println(System.currentTimeMillis() - start);
    }

    public String query(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.file == null) {
            this.setDictionary("c:\\PDIC\\EIJIRO39.DIC");
        }
        try {
            long pos;
            if (this.file == null) {
                System.err.println("No Dictionary");
                return null;
            }
            int i = 0;
            while (i < this.index.length && this.index[i].indexWord.compareTo(string) < 0) {
                ++i;
            }
            if (i == this.index.length) {
                System.err.println("Block not found fot string [" + string + "]");
                return null;
            }
            int blockIndexPhysical = this.index[i - 1].blockIndexPhysical;
            this.file.seek(this.header.size + this.header.extheader + this.header.index_block * this.header.block_size + blockIndexPhysical * this.header.block_size);
            short numBlocks = this.file.readShortBigEndian();
            if (numBlocks == 0) {
                System.err.println("Empty block found");
                return null;
            }
            boolean longData = numBlocks < 0;
            StringBuffer lookingWord = new StringBuffer(20);
            int fieldLength = 0;
            String word = null;
            do {
                fieldLength = !longData ? this.file.readShortBigEndian() & 0xFFFF : this.file.readIntBigEndian();
                byte prefixLength = this.file.readByte();
                word = this.file.readNullTerminatedString();
                lookingWord.setLength(prefixLength + word.length());
                lookingWord.replace(prefixLength, lookingWord.length(), word);
                pos = this.file.getFilePointer();
                this.file.seek(pos + (long)fieldLength - (long)word.length() - 1L);
            } while (string.compareTo(lookingWord.toString()) > 0);
            this.file.seek(pos);
            this.heading = lookingWord.toString();
            byte attribute = this.file.readByte();
            if ((attribute & 0x10) == 0) {
                byte[] meaning = new byte[fieldLength - word.length() - 2];
                this.file.read(meaning);
                return new String(meaning, "Shift_JIS");
            }
            String meaning = this.file.readNullTerminatedString();
            meaning = new String(meaning.getBytes("ISO-8859-1"), "Shift_JIS");
            this.file.readByte();
            byte[] rest = new byte[256];
            this.file.read(rest);
            return meaning;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setDictionary(String dictionary) {
        block10: {
            if (this.file != null) {
                this.closeDictionary();
            }
            try {
                this.header = new Header();
                this.file = new RandomAccessFileBigEndian(dictionary, "r");
                if (this.file.length() < 256L) {
                    return;
                }
                this.file.seek(0L);
                this.file.readFully(this.header.headername);
                this.file.readFully(this.header.dictitle);
                this.header.version = this.file.readShortBigEndian();
                this.header.lword = this.file.readShortBigEndian();
                this.header.ljapa = this.file.readShortBigEndian();
                this.header.block_size = this.file.readShortBigEndian();
                this.header.index_block = this.file.readShortBigEndian();
                this.header.header_size = this.file.readShortBigEndian();
                this.header.index_size = this.file.readShortBigEndian();
                this.header.empty_block = this.file.readShortBigEndian();
                this.header.nindex = this.file.readShortBigEndian();
                this.header.nblock = this.file.readShortBigEndian();
                this.header.nword = this.file.readIntBigEndian();
                this.header.dicorder = this.file.readByte();
                this.header.dictype = this.file.readByte();
                this.header.attrlen = this.file.readByte();
                this.header.olenumber = this.file.readIntBigEndian();
                this.header.os = this.file.readByte();
                this.header.lid_word = this.file.readShortBigEndian();
                this.header.lid_japa = this.file.readShortBigEndian();
                this.header.lid_exp = this.file.readShortBigEndian();
                this.header.lid_pron = this.file.readShortBigEndian();
                this.header.lid_other = this.file.readShortBigEndian();
                this.header.extheader = this.file.readIntBigEndian();
                this.header.empty_block2 = this.file.readIntBigEndian();
                this.header.nindex2 = this.file.readIntBigEndian();
                this.header.nblock2 = this.file.readIntBigEndian();
                this.header.index_blkbit = this.file.readByte();
                this.file.readFully(this.header.reserved);
                this.header.update_count = this.file.readIntBigEndian();
                this.header.charcode = this.file.readByte();
                this.file.readFully(this.header.dummy);
                if (this.header.version != 1024) {
                    System.err.println("Unsupported Dictionary version");
                    return;
                }
                this.file.skipBytes(this.header.extheader);
                if (this.header.index_blkbit == 0) {
                    this.index = new Index[this.header.nindex2];
                    int blockIndexLogical = 0;
                    while (blockIndexLogical < this.header.nindex2) {
                        short blockIndexPhysical = this.file.readShortBigEndian();
                        String indexWord = this.file.readNullTerminatedString();
                        this.index[blockIndexLogical] = new Index(blockIndexPhysical, indexWord);
                        ++blockIndexLogical;
                    }
                    break block10;
                }
                if (this.header.index_blkbit == 1) {
                    this.index = new Index[this.header.nindex2];
                    int blockIndexLogical = 0;
                    while (blockIndexLogical < this.header.nindex2) {
                        int blockIndexPhysical = this.file.readIntBigEndian();
                        String indexWord = this.file.readNullTerminatedString();
                        this.index[blockIndexLogical] = new Index(blockIndexPhysical, indexWord);
                        ++blockIndexLogical;
                    }
                    break block10;
                }
                System.err.println("invalid block size");
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void closeDictionary() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.index = null;
        this.file = null;
    }

    protected void finalize() throws Throwable {
        this.closeDictionary();
    }

    public String getHeading() {
        return this.heading;
    }

    public String getSupportType() {
        return "PDIC";
    }

    public String next() {
        return null;
    }
}

