/*
 * Decompiled with CFR 0.152.
 */
package org.ocharake.matobaa.dictionary.pdictext;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ocharake.matobaa.dictionary.IDictionary;
import org.ocharake.matobaa.dictionary.pdictext.FromTo;

public class PDICText
implements IDictionary {
    static final char SENTINEL = '\u0000';
    RandomAccessFile file;
    List[] index = null;

    public PDICText() {
        this.setDictionary("c:\\PDIC\\gene.txt");
    }

    public static void main(String[] args) throws IOException {
        PDICText dict = new PDICText();
        dict.setDictionary("c:\\PDIC\\gene.txt");
        System.out.println(dict.query("Eclipse"));
        dict.closeDictionary();
    }

    public void closeDictionary() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.file = null;
        this.index = null;
    }

    public String getHeading() {
        return null;
    }

    public String getSupportType() {
        return "PDIC Text";
    }

    public String next() {
        return null;
    }

    public String query(String inputString) {
        if (inputString == null || inputString.length() == 0) {
            return null;
        }
        char indexChar = Character.toLowerCase(inputString.charAt(0));
        if (indexChar < 'a' || indexChar > 'z') {
            return null;
        }
        Iterator indexes = this.index[indexChar - 97].iterator();
        try {
            while (indexes.hasNext()) {
                FromTo index = (FromTo)indexes.next();
                this.file.seek(index.from);
                String fLine = this.file.readLine();
                while (this.file.getFilePointer() < index.to) {
                    if (inputString.equalsIgnoreCase(fLine)) {
                        return new String(this.file.readLine().getBytes("ISO-8859-1"), "Shift_JIS");
                    }
                    this.file.readLine();
                    fLine = this.file.readLine();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setDictionary(String filename) {
        try {
            this.file = new RandomAccessFile(filename, "r");
            char indexChar = '\u0000';
            long pos = 0L;
            FromTo fromTo = null;
            this.index = new ArrayList[26];
            int i = 0;
            while (i < this.index.length) {
                this.index[i] = new ArrayList(2);
                ++i;
            }
            String aLine = this.file.readLine();
            while (aLine != null) {
                char headOfLine = Character.toLowerCase(aLine.charAt(0));
                this.file.readLine();
                if (Character.isLowerCase(headOfLine)) {
                    if (headOfLine != indexChar) {
                        if (fromTo != null) {
                            fromTo.to = pos;
                            this.index[indexChar - 97].add(fromTo);
                        }
                        indexChar = headOfLine;
                        fromTo = new FromTo();
                        fromTo.from = pos;
                    }
                    pos = this.file.getFilePointer();
                }
                aLine = this.file.readLine();
            }
            fromTo.to = this.file.getFilePointer();
            this.index[indexChar - 97].add(fromTo);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

