/*
 * Decompiled with CFR 0.152.
 */
package org.ocharake.matobaa.dictionary;

import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.ocharake.matobaa.dictionary.DictionaryPlugin;

public class ViewPart1
extends ViewPart
implements ModifyListener {
    private Text queryWord;
    private Text result;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Dictionary");
        ViewPart1 me = new ViewPart1();
        me.createPartControl((Composite)shell);
        shell.setSize(200, 200);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        this.queryWord = new Text(parent, 2052);
        this.queryWord.setText("input word to query");
        this.queryWord.selectAll();
        this.queryWord.addModifyListener((ModifyListener)this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.queryWord.setLayoutData((Object)gridData);
        this.result = new Text(parent, 2626);
        this.result.setText("Result will be shown here");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.result.setLayoutData((Object)gridData);
        parent.layout();
    }

    public void modifyText(ModifyEvent e) {
        String resultString = DictionaryPlugin.getDefault().query(this.queryWord.getText());
        this.result.setText(resultString);
    }

    public void setFocus() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        if (!(editorPart instanceof AbstractTextEditor)) {
            return;
        }
        AbstractTextEditor textEditor = (AbstractTextEditor)editorPart;
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        if (!(selection instanceof TextSelection)) {
            return;
        }
        TextSelection textSelection = (TextSelection)selection;
        this.queryWord.setText(textSelection.getText());
    }
}

