/*
 * Decompiled with CFR 0.152.
 */
package org.ocharake.matobaa.dictionary;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.ocharake.matobaa.dictionary.IDictionary;

public class DictionaryPlugin
extends AbstractUIPlugin {
    IDictionary[] extensions = null;
    private static DictionaryPlugin plugin;
    private ResourceBundle resourceBundle;

    public IDictionary[] getExtentions() {
        if (this.extensions == null) {
            this.extensions = this.searchExtentions();
        }
        return this.extensions;
    }

    protected IDictionary[] searchExtentions() {
        ArrayList<IDictionary> dictionaries = new ArrayList<IDictionary>();
        try {
            IPluginRegistry registry = Platform.getPluginRegistry();
            IExtensionPoint point = registry.getExtensionPoint("org.ocharake.matobaa.dictionary.externalDictionary");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if ("dictionary".equals(elements[j].getName())) {
                        IDictionary dictionary = (IDictionary)elements[j].createExecutableExtension("class");
                        dictionaries.add(dictionary);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IDictionary[] result = new IDictionary[dictionaries.size()];
        dictionaries.toArray(result);
        return result;
    }

    public DictionaryPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.ocharake.matobaa.SelectionReporter.SelectionReporterPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static DictionaryPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = DictionaryPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String query(String string) {
        String result = "";
        IDictionary[] dictionaries = this.getExtentions();
        int i = 0;
        while (i < dictionaries.length) {
            String eachResult = dictionaries[i].query(string);
            if (eachResult != null) {
                result = String.valueOf(result) + eachResult;
                result = String.valueOf(result) + '\n';
            }
            ++i;
        }
        return result;
    }
}

