class CreateLocationMonsters < ActiveRecord::Migration
  def self.up
    create_table :location_monsters do |t|
      t.column :location_id, :integer
      t.column :monster_id, :integer
      t.column :probability, :integer
    end
    loc = Location.find_by_location_name('᤯ο')
    Monster.find_all.each do |m|
      LocationMonster.create( :location_id => loc.id,
                              :monster_id => m.id,
                              :probability => 1
                              )
    end

    add_index :location_monsters, :location_id
  end

  def self.down
    drop_table :location_monsters
  end
end
