class CreateLocations < ImportMigration
  def self.up
    create_table :locations do |t|
      # t.column :name, :string
      t.column :location_name, :string
      t.column :has_guild, :boolean, :default => 'FALSE'
      t.column :has_library, :boolean, :default => 'FALSE'
      t.column :parent_id, :integer
    end

    Location.create( :location_name => '', :parent_id => nil )
    do_file_import( "input_location.csv" ) do |arr|
      pn = arr.shift
      pl = Location.find_by_location_name( pn )
      unless pl
        log.warn "unknown location parent name '#{pn}' on '#{ln}' skipped."
        next
      end
      ln = arr.shift
      l = Location.create( :location_name => ln, :parent_id => pl.id )
      arr.each do |p|
        case p
        when ''
          l.has_guild = TRUE
          l.save!
        when '޽'
          l.has_library = TRUE
          l.save!
        else
          log.warn("unknown term '#{p}' found in '#{l.location_name}'.")
        end
      end
    end
  end

  def self.down
    drop_table :locations
  end
end
