class GameController < ApplicationController

  def home
    @title = 'ۡ'
    @item_kind_count = Item.count_kind
    @experience_count = Experience.count( @user.id )
  end

  def blending
    @title = ''
    unless session[:selected]
      inventory
      render 'game/inventory'
    end
  end
  def inventory
    @title = 'ʪϣ'
    @stocks = Experience.find_all_by_user_id( session[:user_id] )
    
    session[:select_type] = params[:select_type].to_i if params[:select_type]
    if session[:select_type] and session[:select_type] != 0
      @stocks.delete_if{|s| s.item.item_type.id != session[:select_type]}
    end
  end

  def calcMaterialHash(items)
    material_hash = 0
    items.each do |i|
      material_hash += i.mat_hash.hex
    end
    return material_hash & HASH_MASK
  end
  private :calcMaterialHash

  def blend
    @title = ''
    @items = session[:selected]
    if @items and @items.size > 0
      result = Recipe.find_by_recipe_result_source( @items.collect{|i| i.item_name}.sort.join ',' )
      if result
        @blend_result = result.item
        Experience.add( session[:user_id], result.recipe_result_id )
      else
        temp = Recipe.find_by_recipe_material_hash( '%X' % calcMaterialHash(@items) )
        @title = ''
        if temp
          render 'game/blend_almost'
        else
          render 'game/blend_fail'
        end
      end
    else
      flash.now[:error] = "˥ƥ򤷤Ƥ"
      inventory
      render 'game/inventory'
    end
  end
  
  def select_clear
    session[:selected] = nil
    inventory
    render 'game/inventory'
  end

  def select_item_sub(item)
    break unless item
    session[:selected] ||= []
    if session[:selected].size >= ITEM_BLEND_MAX
      flash[:error] = "ƥ#{ITEM_BLEND_MAX}ޤǤǤ"
    else
      session[:selected] << item
    end
    session[:selected].sort!{|l,r| l.id <=> r.id}.uniq!
  end
  def item_select
    if params[:item_id]
      item_id = params[:item_id].to_i
      item = Item.find( item_id )
      select_item_sub( item )
      flash[:info] = "Ǥʷϵ" if Recipe.find_by_recipe_material_hash( '%X' % calcMaterialHash(session[:selected]) )
    end
    redirect_to :action => params[:next_page] || :home
  end

  def recipe_select
    if params[:recipe_id]
      if Experience.blended?(session[:user_id], params[:recipe_id])
        session[:selected] = nil
        r = Recipe.find_by_recipe_result_id( params[:recipe_id].to_i )
        if r
          r.recipe_result_source.split(',').each do |name|
            item = Item.find_by_item_name( name )
            select_item_sub( item )
          end
        else
          flash.now[:error] = "ƥIDǤ"
        end
      else
        flash.now[:error] = "ƥιиޤ"
      end
      inventory
      render 'game/inventory'
    else
      redirect_to :action => params[:next_page] || :home
    end
  end

  def item_unselect
    if params[:item_id]
      item_id = params[:item_id].to_i
      item = Item.find( item_id )
      break unless item
      session[:selected].delete(item)
    end
    redirect_to :action => params[:next_page] || :home
  end

  private
  
  def stock_check(user_id, items, num)
    ret = true
    return ret
  end
  def blend_item_use(user_id, items, num)
  end
end
