class DeqParser
prechigh
  nonassoc UMINUS
  right '^'
  nonassoc 'd' 'D'
  left '*' '/' '%'
  left '+' '-'
preclow
rule
target: exp
      | /* none */ { result = 0 }
exp: exp '+' exp { result += val[2] }
   | exp '-' exp { result -= val[2] }
   | exp '*' exp { result *= val[2] }
   | exp '/' exp { result /= val[2] }
   | exp '%' exp { result %= val[2] }
   | exp 'd' exp { result = 0; val[0].times{|i| result += rand(val[2]) + 1 } }
   | exp '^' exp { result **= val[2] }
   | '-' NUMBER =UMINUS { result = -val[1] }
   | NUMBER
   | '(' exp ')' { result = val[1] }
end

---- inner

def parse(str)
  @q = []
  until str.empty?
    case str
    when /\A\s+/
    when /\A\d+/
      @q.push [:NUMBER, $&.to_i]
    when /\A.|\n/o
      s = $&.downcase
      @q.push [s, s]
    end
    str = $'
  end
  @q.push [false, '$end']
  do_parse
end

def next_token
  @q.shift
end

---- footer

if __FILE__ == $0
  parser = DeqParser.new
  puts
  puts 'type "Q" to quie.'
  puts
  while true
    puts
    print '? '
    str = gets.chop!
    break if /q/i =~ str
    begin
      puts "= #{parser.parse(str)}"
    rescue ParseError
      puts $!
    end
  end
end
