class ShopStock < ActiveRecord::Base
  belongs_to :shop
  belongs_to :item

  def self.supply_shop_stocks
    usernum = User.getUserNum
    stocks = self.find( :all )
    stocks.each do |stock|
      left = stock.stock
      max = (stock.maximum * usernum / 100).to_i
      stock.rest += stock.supply * usernum
      stock.stock += (stock.rest / 100).to_i
      stock.rest = stock.rest % 100
      if stock.stock > max
        stock.stock = left
        stock.rest = 0
      end
      stock.save
    end
    true
  end
end
