class LocationPick < ActiveRecord::Base
  belongs_to :location
  belongs_to :item

  def self.supply_location_stocks
    usernum = User.getUserNum
    picks = self.find( :all )
    picks.each do |pick|
      num = 0
      (pick.supply * usernum / 100).ceil.times do
        num += 1 if rand(1000) < pick.supply_permill
      end
      pick.stock += num
      limit = (pick.max_per_user * usernum / 100).ceil
      if pick.stock > limit
        pick.stock = limit
      end
      pick.save
    end
    true
  end
end
