class Location < ActiveRecord::Base
  has_many :picks, :class_name => 'LocationPick'
  has_many :shops, :class_name => 'Shop', :foreign_key => 'shop_location'
  has_many :users, :foreign_key => 'user_location'

  def self.get_random_location_has_guild(has_guild)
    loop do
      index = rand( self.count.to_i ) + 1
      loc = self.find( index )
      if loc.has_guild? == has_guild
        return loc
      end
    end
  end
end
