class Letter < ActiveRecord::Base
  belongs_to :user_from, :class_name => 'User', :foreign_key => 'src_id'
  belongs_to :user_to, :class_name => 'User', :foreign_key => 'dest_id'

  def self.isRecentExist?(user_id)
    r = self.find( :first, :conditions => ['(dest_id = ? OR dest_id IS NULL) AND is_read = FALSE', user_id], :order => 'send_at DESC' )
    return r && (r.send_at > 1.hours.ago)
  end

  def self.getLetters(user_id)
    self.find( :all, :conditions => [ 'dest_id = ? OR dest_id IS NULL', user_id ], :order => 'send_at ASC' )
  end

  def self.sendMessage( dest, src, title, msg )
    self.create!( :dest_id => dest,
                  :src_id => src,
                  :title => title,
                  :contents => msg,
                  :send_at => Time.now,
                  :is_read => false
                  )
  end
end
