# Filters added to this controller will be run for all controllers in the application.
# Likewise, all the methods added will be available for all controllers.
class ApplicationController < ActionController::Base
  before_filter :check_authentication

  after_filter :set_charset

  helper :application
  HASH_MASK = 0xffffffffffffffffffffffffffffffff

  ITEM_BLEND_MAX = 5 # Ǥ륢ƥκ
  APP_DIR = "/home/fumiu/rails/marry"

  def check_authentication
    unless session[:user_id]
      session[:intended_action] = action_name
      session[:intended_controller] = controller_name
      redirect_to :controller => 'login', :action => 'login'
    else
      @user = User.find( session[:user_id] )
    end
  end

  def set_charset
    @headers["Content-Type"] ||= 'text/html'
    @headers["Content-Type"] += '; charset=EUC-JP'
  end
end
