/*
 * Unify pred program copyright (C) 2009 - 2010 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __UNIFY_H
#define __UNIFY_H

extern List* Module;

/* operators */
#define	CUTOP	("!")
#define	TRUEOP	("true")
#define	FALSEOP	("false")
#define	UNKNOWNOP ("unknown")
#define	BREAKOP	("break")
#define	BRKOP	("brk")
#define	WCARD	("*")

/* make a atom */
#define mka(s)	(new Atom(s))


extern Node* Dup(Node* n);

extern void SetEnv(Node* env, Node* udef);
extern void UnsetEnv(Node* env1);

extern int Unification(Node* pred1, Node* pred2, Node* env, Context* cx);
extern int Unify(Node* goals);
extern int Unify(Context* &cx, Node* goals);
extern int Unify(Context* &cx, Node* goals, List* module);

/* enable/disable trace flag */
extern int TraceFlag;

/* enable/disable step trace flag */
extern int StepFlag;

/* enable/disable display result flag */
extern int DResultFlag;


#endif // __UNIFY_H
