/*
 * matrix program copyright (C) 2009 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __MATRIX_H__
#define __MATRIX_H__

extern int DoMatrix(Context* cx, Node* goalscar, List* module);
extern int DoSetMatrix(Context* cx, Node* goalscar, List* module);
extern int DoGetMatrix(Context* cx, Node* goalscar, List* module);

extern int matrix_rowno(Context* cx, Node* goalscar, List* module);
extern int matrix_colno(Context* cx, Node* goalscar, List* module);
extern int matrix_equal(Context* cx, Node* goalscar, List* module);
extern int matrix_notequal(Context* cx, Node* goalscar, List* module);
extern int matrix_add(Context* cx, Node* goalscar, List* module);
extern int matrix_sub(Context* cx, Node* goalscar, List* module);
extern int matrix_mul(Context* cx, Node* goalscar, List* module);
extern int matrix_expr(Context* cx, Node* goalscar, List* module);
extern int matrix_mulscalar(Context* cx, Node* goalscar, List* module);
extern int matrix_divscalar(Context* cx, Node* goalscar, List* module);
extern int matrix_tra(Context* cx, Node* goalscar, List* module);
extern int matrix_inv(Context* cx, Node* goalscar, List* module);
extern int matrix_solve(Context* cx, Node* goalscar, List* module);
extern int matrix_det(Context* cx, Node* goalscar, List* module);
extern int matrix_norm(Context* cx, Node* goalscar, List* module);
extern int matrix_cofact(Context* cx, Node* goalscar, List* module);
extern int matrix_adj(Context* cx, Node* goalscar, List* module);
extern int matrix_issquare(Context* cx, Node* goalscar, List* module);
extern int matrix_issingular(Context* cx, Node* goalscar, List* module);
extern int matrix_isdiagonal(Context* cx, Node* goalscar, List* module);
extern int matrix_issymmetric(Context* cx, Node* goalscar, List* module);
extern int matrix_isnull(Context* cx, Node* goalscar, List* module);
extern int matrix_(Context* cx, Node* goalscar, List* module);

#endif
