/*
 * Copyright 2014 Yuichiro Moriguchi
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * morilib Nina Version: 0.4.13.498
 *
 * Nina homepage:      http://nina.morilib.net/
 * Plugin update site: http://nina.morilib.net/update-site/
 */

package net.morilib.deculture.parser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.morilib.automata.lr.Associativity;
import net.morilib.automata.lr.Terminal;
import net.morilib.deculture.misc.CharacterTerminal;
import net.morilib.deculture.misc.ConstantTerminal;

/**
 */
public  class DecultureDefinition   {

	/* @@@-PARSER-CODE-START-@@@ */
	public static class TokenException extends RuntimeException {
	}

	static abstract class Engine {
		abstract int step(int c) throws java.io.IOException;
		abstract boolean accepted();
		abstract boolean isDead();
		abstract boolean isEmptyTransition();
		abstract int execaction(int c);
		abstract boolean isend();
		abstract int recover(Exception e);
		abstract int deadState();
		abstract int stateSize();
		abstract int finallyState();
	}
	static final int INVALIDTOKEN = 0x7fff7fff;
	private static final int NINA_BEGIN = -2;
	private static final int NINA_EOF = -1;
	private static final int NINA_ACCEPT = -8;
	private static final int NINA_FAIL = -9;
	private static final int NINA_HALT_ACCEPT = -91;
	private static final int NINA_HALT_REJECT = -72;
	private static final int NINA_YIELD = -85;
	private static final int NINA_STACKLEN = 72;
	static final int NINA_DISCARDSTATE = 0x40000000;
	static final int INITIAL = 0;
	static final int INDENT = 1;

	private int STATE;
	private int[] __sts = new int[NINA_STACKLEN];
	private Engine[] __stk = new Engine[NINA_STACKLEN];
	private Object[][] __stv = new Object[NINA_STACKLEN][];
	private int __slen = 0;
	private int unread = -1;

	Object _;
	java.util.List<Object> _l;
	Object yieldObject;
	Throwable exception;

	StringBuffer $buffer;
	int $int;
	java.math.BigInteger $bigint;
	Number $num;

	java.util.Stack<java.io.Reader> streamStack =
			new java.util.Stack<java.io.Reader>();

	void _initlist() {
		_l = new java.util.ArrayList<Object>();
	}

	void _addlist(Object x) {
		_l.add(x);
	}

	private int __lookahead_state;
	private int __lookahead_mark = -1;
	private int[] __lookahead = null;
	private int __lookahead_ptr = -1;
	private int[] __lookaheadw = null;
	private int __lookaheadw_ptr = -1;
	private boolean __lookahead_ok = true;

	private int _unreadl = -1;

	void INCLUDE(java.io.Reader rd) {
		if(__lookahead_ptr >= 0) {
			throw new IllegalStateException();
		}
		streamStack.push(rd);
	}

	void INCLUDE(String name) throws java.io.IOException {
		java.io.InputStream ins;

		ins = new java.io.FileInputStream(name);
		INCLUDE(new java.io.InputStreamReader(ins));
	}

	int _read1l() throws java.io.IOException {
		int c;

		while(streamStack.size() > 0) {
			if((c = streamStack.peek().read()) >= 0) {
				return c;
			} else if(streamStack.size() > 1) {
				streamStack.pop().close();
			} else {
				streamStack.pop();
			}
		}
		return NINA_EOF;
	}

	int _read1() throws java.io.IOException {
		int c;

		if(_unreadl != -1) {
			c = _unreadl;
			_unreadl = -1;
		} else if((c = _read1l()) == '\r' && (c = _read1l()) != '\n') {
			_unreadl = c;
			c = '\r';
		}
		return c;
	}

	private int _read() throws java.io.IOException {
		int c;

		while(true) {
			if(unread != -1) {

				c = unread;
				unread = -1;
				__logprint("Read unread: ", c);
			} else if(__lookahead_ptr >= 0) {
				if(__lookahead_ptr < __lookahead.length) {
					c = __lookahead[__lookahead_ptr++];
				} else {
					__lookahead = null;
					__lookahead_ptr = -1;
					c = _read();
				}
				__logprint("Read Lookahead: ", c);
			} else if((c = _read1()) != -1) {
				__logprint("Read: ", c);
			} else {
				__logprint("Read end-of-file");
			}
			return c;
		}
	}

	void UNGET(int c) {
		unread = c;
		__logprint("Set unread: ", c);
	}

	void __sleep(int m) {
		try {
			Thread.sleep(m);
		} catch(InterruptedException e) {
			throw new RuntimeException(e);
		}
	}

	private void __logprint(String s, int c) {
	}

	private void __logopen() {
	}

	private void __logprint(String s) {
	}

	private void __logclose() {
	}

	private void __puttrace() {
	}

	void LOOKAHEAD(int c) {
		int[] a;

		if(__lookaheadw == null) {
			__lookahead_state = STATE;
			__lookaheadw = new int[72];
			__lookaheadw_ptr = 0;
			__lookaheadw[__lookaheadw_ptr++] = c;
		} else if(__lookaheadw_ptr < __lookaheadw.length) {
			__lookaheadw[__lookaheadw_ptr++] = c;
		} else {
			a = new int[__lookaheadw.length * 2];
			System.arraycopy(__lookaheadw, 0, a, 0,
					__lookaheadw.length);
			__lookaheadw = a;
			__lookaheadw[__lookaheadw_ptr++] = c;
		}
	}

	private void __copy_lookahead(int p) {
		int[] a;

		if(__lookahead_ptr > 0) {
			a = new int[__lookahead.length - __lookahead_ptr];
			System.arraycopy(__lookahead, __lookahead_ptr, a, 0, a.length);
			__lookahead = a;
		}

		if(__lookahead == null) {
			a = new int[__lookaheadw_ptr];
		} else if(__lookaheadw_ptr < __lookahead.length) {
			a = __lookahead;
		} else {
			a = new int[__lookaheadw_ptr];
		}
		System.arraycopy(__lookaheadw, 0, a, 0, __lookaheadw_ptr);
		__lookahead = a;
		__lookahead_ptr = p;
		__lookaheadw = null;
		__lookaheadw_ptr = -1;
	}

	void LOOKAHEAD_COMMIT() {
		if(__lookahead_mark < 0) {
			__lookaheadw = null;
			__lookaheadw_ptr = -1;
		} else {
			__copy_lookahead(__lookahead_mark);
		}
		__lookahead_mark = -1;
		__logprint("Commit Lookahead");
	}

	void LOOKAHEAD_RB() {
		__copy_lookahead(0);
		STATE = __lookahead_state;
		__lookahead_ok = false;
		__lookahead_mark = -1;
		__logprint("Rollback Lookahead");
	}

	void LOOKAHEAD_MARK() {
		__lookahead_mark = __lookaheadw_ptr;
	}

	void LOOKAHEAD_MARK_INIT() {
		__lookahead_mark = 0;
	}


	private int decultureDefinition_step(int  $c)  throws java.io.IOException {
		boolean __l__ = __lookahead_ok;

		__lookahead_ok = true;
		switch(STATE) {
		case 0:
			if(($c == '\n')) {
				STATE = 0;
				return 1;
			} else if(($c == '%')) {
				STATE = 1;
				return 1;
			} else if($c >= 0) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 2:
			if(($c == '\n')) {
				STATE = 0;
				return 1;
			}
			return 0;
		case 1:
			if((__l__ && $c == 'n')) {
				LOOKAHEAD($c);
				STATE = 3;
				return 1;
			} else if((__l__ && $c == 't')) {
				LOOKAHEAD($c);
				STATE = 4;
				return 1;
			} else if((__l__ && $c == 'l')) {
				LOOKAHEAD($c);
				STATE = 5;
				return 1;
			} else if((__l__ && $c == 'r')) {
				LOOKAHEAD($c);
				STATE = 6;
				return 1;
			} else if((__l__ && $c == 's')) {
				LOOKAHEAD($c);
				STATE = 7;
				return 1;
			} else if(($c == '{')) {
				LOOKAHEAD_COMMIT();
				STATE = 8;
				return 1;
			}
			return 0;
		case 8:
			if(($c == '%')) {
				STATE = 9;
				return 1;
			} else if($c >= 0) {
				STATE = 10;
				return 1;
			}
			return 0;
		case 10:
			if(($c == '%')) {
				STATE = 9;
				return 1;
			} else if($c >= 0) {
				STATE = 10;
				return 1;
			}
			return 0;
		case 9:
			if(($c == '}')) {
				STATE = 0;
				return 1;
			} else if($c >= 0) {
				_d('%');
				STATE = 10;
				return 1;
			}
			return 0;
		case 7:
			if((__l__ && $c == 't')) {
				LOOKAHEAD($c);
				STATE = 11;
				return 1;
			}
			return 0;
		case 11:
			if((__l__ && $c == 'a')) {
				LOOKAHEAD($c);
				STATE = 12;
				return 1;
			}
			return 0;
		case 12:
			if((__l__ && $c == 'r')) {
				LOOKAHEAD($c);
				STATE = 13;
				return 1;
			}
			return 0;
		case 13:
			if((__l__ && $c == 't')) {
				LOOKAHEAD($c);
				STATE = 14;
				return 1;
			}
			return 0;
		case 14:
			if(($c >= 0 && $c <= '@') || ($c >= '[' && $c <= '`') || ($c >= '{' && $c <= 169) || ($c >= 171 && $c <= 180) || ($c >= 182 && $c <= 185) || ($c >= 187 && $c <= 191) || ($c == 215) || ($c == 247) || ($c >= 706 && $c <= 709) || ($c >= 722 && $c <= 735) || ($c >= 741 && $c <= 747) || ($c == 749) || ($c >= 751 && $c <= 879) || ($c == 885) || ($c >= 888 && $c <= 889) || ($c >= 894 && $c <= 901) || ($c == 903) || ($c == 907) || ($c == 909) || ($c == 930) || ($c == 1014) || ($c >= 1154 && $c <= 1161) || ($c >= 1320 && $c <= 1328) || ($c >= 1367 && $c <= 1368) || ($c >= 1370 && $c <= 1376) || ($c >= 1416 && $c <= 1487) || ($c >= 1515 && $c <= 1519) || ($c >= 1523 && $c <= 1567) || ($c >= 1611 && $c <= 1645) || ($c == 1648) || ($c == 1748) || ($c >= 1750 && $c <= 1764) || ($c >= 1767 && $c <= 1773) || ($c >= 1776 && $c <= 1785) || ($c >= 1789 && $c <= 1790) || ($c >= 1792 && $c <= 1807) || ($c == 1809) || ($c >= 1840 && $c <= 1868) || ($c >= 1958 && $c <= 1968) || ($c >= 1970 && $c <= 1993) || ($c >= 2027 && $c <= 2035) || ($c >= 2038 && $c <= 2041) || ($c >= 2043 && $c <= 2047) || ($c >= 2070 && $c <= 2073) || ($c >= 2075 && $c <= 2083) || ($c >= 2085 && $c <= 2087) || ($c >= 2089 && $c <= 2111) || ($c >= 2137 && $c <= 2307) || ($c >= 2362 && $c <= 2364) || ($c >= 2366 && $c <= 2383) || ($c >= 2385 && $c <= 2391) || ($c >= 2402 && $c <= 2416) || ($c == 2424) || ($c >= 2432 && $c <= 2436) || ($c >= 2445 && $c <= 2446) || ($c >= 2449 && $c <= 2450) || ($c == 2473) || ($c == 2481) || ($c >= 2483 && $c <= 2485) || ($c >= 2490 && $c <= 2492) || ($c >= 2494 && $c <= 2509) || ($c >= 2511 && $c <= 2523) || ($c == 2526) || ($c >= 2530 && $c <= 2543) || ($c >= 2546 && $c <= 2564) || ($c >= 2571 && $c <= 2574) || ($c >= 2577 && $c <= 2578) || ($c == 2601) || ($c == 2609) || ($c == 2612) || ($c == 2615) || ($c >= 2618 && $c <= 2648) || ($c == 2653) || ($c >= 2655 && $c <= 2673) || ($c >= 2677 && $c <= 2692) || ($c == 2702) || ($c == 2706) || ($c == 2729) || ($c == 2737) || ($c == 2740) || ($c >= 2746 && $c <= 2748) || ($c >= 2750 && $c <= 2767) || ($c >= 2769 && $c <= 2783) || ($c >= 2786 && $c <= 2820) || ($c >= 2829 && $c <= 2830) || ($c >= 2833 && $c <= 2834) || ($c == 2857) || ($c == 2865) || ($c == 2868) || ($c >= 2874 && $c <= 2876) || ($c >= 2878 && $c <= 2907) || ($c == 2910) || ($c >= 2914 && $c <= 2928) || ($c >= 2930 && $c <= 2946) || ($c == 2948) || ($c >= 2955 && $c <= 2957) || ($c == 2961) || ($c >= 2966 && $c <= 2968) || ($c == 2971) || ($c == 2973) || ($c >= 2976 && $c <= 2978) || ($c >= 2981 && $c <= 2983) || ($c >= 2987 && $c <= 2989) || ($c >= 3002 && $c <= 3023) || ($c >= 3025 && $c <= 3076) || ($c == 3085) || ($c == 3089) || ($c == 3113) || ($c == 3124) || ($c >= 3130 && $c <= 3132) || ($c >= 3134 && $c <= 3159) || ($c >= 3162 && $c <= 3167) || ($c >= 3170 && $c <= 3204) || ($c == 3213) || ($c == 3217) || ($c == 3241) || ($c == 3252) || ($c >= 3258 && $c <= 3260) || ($c >= 3262 && $c <= 3293) || ($c == 3295) || ($c >= 3298 && $c <= 3312) || ($c >= 3315 && $c <= 3332) || ($c == 3341) || ($c == 3345) || ($c >= 3387 && $c <= 3388) || ($c >= 3390 && $c <= 3405) || ($c >= 3407 && $c <= 3423) || ($c >= 3426 && $c <= 3449) || ($c >= 3456 && $c <= 3460) || ($c >= 3479 && $c <= 3481) || ($c == 3506) || ($c == 3516) || ($c >= 3518 && $c <= 3519) || ($c >= 3527 && $c <= 3584) || ($c == 3633) || ($c >= 3636 && $c <= 3647) || ($c >= 3655 && $c <= 3712) || ($c == 3715) || ($c >= 3717 && $c <= 3718) || ($c == 3721) || ($c >= 3723 && $c <= 3724) || ($c >= 3726 && $c <= 3731) || ($c == 3736) || ($c == 3744) || ($c == 3748) || ($c == 3750) || ($c >= 3752 && $c <= 3753) || ($c == 3756) || ($c == 3761) || ($c >= 3764 && $c <= 3772) || ($c >= 3774 && $c <= 3775) || ($c == 3781) || ($c >= 3783 && $c <= 3803) || ($c >= 3806 && $c <= 3839) || ($c >= 3841 && $c <= 3903) || ($c == 3912) || ($c >= 3949 && $c <= 3975) || ($c >= 3981 && $c <= 4095) || ($c >= 4139 && $c <= 4158) || ($c >= 4160 && $c <= 4175) || ($c >= 4182 && $c <= 4185) || ($c >= 4190 && $c <= 4192) || ($c >= 4194 && $c <= 4196) || ($c >= 4199 && $c <= 4205) || ($c >= 4209 && $c <= 4212) || ($c >= 4226 && $c <= 4237) || ($c >= 4239 && $c <= 4255) || ($c >= 4294 && $c <= 4303) || ($c == 4347) || ($c >= 4349 && $c <= 4351) || ($c == 4681) || ($c >= 4686 && $c <= 4687) || ($c == 4695) || ($c == 4697) || ($c >= 4702 && $c <= 4703) || ($c == 4745) || ($c >= 4750 && $c <= 4751) || ($c == 4785) || ($c >= 4790 && $c <= 4791) || ($c == 4799) || ($c == 4801) || ($c >= 4806 && $c <= 4807) || ($c == 4823) || ($c == 4881) || ($c >= 4886 && $c <= 4887) || ($c >= 4955 && $c <= 4991) || ($c >= 5008 && $c <= 5023) || ($c >= 5109 && $c <= 5120) || ($c >= 5741 && $c <= 5742) || ($c == 5760) || ($c >= 5787 && $c <= 5791) || ($c >= 5867 && $c <= 5887) || ($c == 5901) || ($c >= 5906 && $c <= 5919) || ($c >= 5938 && $c <= 5951) || ($c >= 5970 && $c <= 5983) || ($c == 5997) || ($c >= 6001 && $c <= 6015) || ($c >= 6068 && $c <= 6102) || ($c >= 6104 && $c <= 6107) || ($c >= 6109 && $c <= 6175) || ($c >= 6264 && $c <= 6271) || ($c == 6313) || ($c >= 6315 && $c <= 6319) || ($c >= 6390 && $c <= 6399) || ($c >= 6429 && $c <= 6479) || ($c >= 6510 && $c <= 6511) || ($c >= 6517 && $c <= 6527) || ($c >= 6572 && $c <= 6592) || ($c >= 6600 && $c <= 6655) || ($c >= 6679 && $c <= 6687) || ($c >= 6741 && $c <= 6822) || ($c >= 6824 && $c <= 6916) || ($c >= 6964 && $c <= 6980) || ($c >= 6988 && $c <= 7042) || ($c >= 7073 && $c <= 7085) || ($c >= 7088 && $c <= 7103) || ($c >= 7142 && $c <= 7167) || ($c >= 7204 && $c <= 7244) || ($c >= 7248 && $c <= 7257) || ($c >= 7294 && $c <= 7400) || ($c == 7405) || ($c >= 7410 && $c <= 7423) || ($c >= 7616 && $c <= 7679) || ($c >= 7958 && $c <= 7959) || ($c >= 7966 && $c <= 7967) || ($c >= 8006 && $c <= 8007) || ($c >= 8014 && $c <= 8015) || ($c == 8024) || ($c == 8026) || ($c == 8028) || ($c == 8030) || ($c >= 8062 && $c <= 8063) || ($c == 8117) || ($c == 8125) || ($c >= 8127 && $c <= 8129) || ($c == 8133) || ($c >= 8141 && $c <= 8143) || ($c >= 8148 && $c <= 8149) || ($c >= 8156 && $c <= 8159) || ($c >= 8173 && $c <= 8177) || ($c == 8181) || ($c >= 8189 && $c <= 8304) || ($c >= 8306 && $c <= 8318) || ($c >= 8320 && $c <= 8335) || ($c >= 8349 && $c <= 8449) || ($c >= 8451 && $c <= 8454) || ($c >= 8456 && $c <= 8457) || ($c == 8468) || ($c >= 8470 && $c <= 8472) || ($c >= 8478 && $c <= 8483) || ($c == 8485) || ($c == 8487) || ($c == 8489) || ($c == 8494) || ($c >= 8506 && $c <= 8507) || ($c >= 8512 && $c <= 8516) || ($c >= 8522 && $c <= 8525) || ($c >= 8527 && $c <= 8578) || ($c >= 8581 && $c <= 11263) || ($c == 11311) || ($c == 11359) || ($c >= 11493 && $c <= 11498) || ($c >= 11503 && $c <= 11519) || ($c >= 11558 && $c <= 11567) || ($c >= 11622 && $c <= 11630) || ($c >= 11632 && $c <= 11647) || ($c >= 11671 && $c <= 11679) || ($c == 11687) || ($c == 11695) || ($c == 11703) || ($c == 11711) || ($c == 11719) || ($c == 11727) || ($c == 11735) || ($c >= 11743 && $c <= 11822) || ($c >= 11824 && $c <= 12292) || ($c >= 12295 && $c <= 12336) || ($c >= 12342 && $c <= 12346) || ($c >= 12349 && $c <= 12352) || ($c >= 12439 && $c <= 12444) || ($c == 12448) || ($c == 12539) || ($c >= 12544 && $c <= 12548) || ($c >= 12590 && $c <= 12592) || ($c >= 12687 && $c <= 12703) || ($c >= 12731 && $c <= 12783) || ($c >= 12800 && $c <= 13311) || ($c >= 19894 && $c <= 19967) || ($c >= 40908 && $c <= 40959) || ($c >= 42125 && $c <= 42191) || ($c >= 42238 && $c <= 42239) || ($c >= 42509 && $c <= 42511) || ($c >= 42528 && $c <= 42537) || ($c >= 42540 && $c <= 42559) || ($c >= 42607 && $c <= 42622) || ($c >= 42648 && $c <= 42655) || ($c >= 42726 && $c <= 42774) || ($c >= 42784 && $c <= 42785) || ($c >= 42889 && $c <= 42890) || ($c == 42895) || ($c >= 42898 && $c <= 42911) || ($c >= 42922 && $c <= 43001) || ($c == 43010) || ($c == 43014) || ($c == 43019) || ($c >= 43043 && $c <= 43071) || ($c >= 43124 && $c <= 43137) || ($c >= 43188 && $c <= 43249) || ($c >= 43256 && $c <= 43258) || ($c >= 43260 && $c <= 43273) || ($c >= 43302 && $c <= 43311) || ($c >= 43335 && $c <= 43359) || ($c >= 43389 && $c <= 43395) || ($c >= 43443 && $c <= 43470) || ($c >= 43472 && $c <= 43519) || ($c >= 43561 && $c <= 43583) || ($c == 43587) || ($c >= 43596 && $c <= 43615) || ($c >= 43639 && $c <= 43641) || ($c >= 43643 && $c <= 43647) || ($c == 43696) || ($c >= 43698 && $c <= 43700) || ($c >= 43703 && $c <= 43704) || ($c >= 43710 && $c <= 43711) || ($c == 43713) || ($c >= 43715 && $c <= 43738) || ($c >= 43742 && $c <= 43776) || ($c >= 43783 && $c <= 43784) || ($c >= 43791 && $c <= 43792) || ($c >= 43799 && $c <= 43807) || ($c == 43815) || ($c >= 43823 && $c <= 43967) || ($c >= 44003 && $c <= 44031) || ($c >= 55204 && $c <= 55215) || ($c >= 55239 && $c <= 55242) || ($c >= 55292 && $c <= 63743) || ($c >= 64046 && $c <= 64047) || ($c >= 64110 && $c <= 64111) || ($c >= 64218 && $c <= 64255) || ($c >= 64263 && $c <= 64274) || ($c >= 64280 && $c <= 64284) || ($c == 64286) || ($c == 64297) || ($c == 64311) || ($c == 64317) || ($c == 64319) || ($c == 64322) || ($c == 64325) || ($c >= 64434 && $c <= 64466) || ($c >= 64830 && $c <= 64847) || ($c >= 64912 && $c <= 64913) || ($c >= 64968 && $c <= 65007) || ($c >= 65020 && $c <= 65135) || ($c == 65141) || ($c >= 65277 && $c <= 65312) || ($c >= 65339 && $c <= 65344) || ($c >= 65371 && $c <= 65381) || ($c >= 65471 && $c <= 65473) || ($c >= 65480 && $c <= 65481) || ($c >= 65488 && $c <= 65489) || ($c >= 65496 && $c <= 65497) || ($c >= 65501 && $c <= 2147483647)) {
				LOOKAHEAD_COMMIT();UNGET($c);
				STATE = 15;
				return 1;
			}
			return 0;
		case 15:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 16;
				return 1;
			}
			return 0;
		case 16:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 16;
				return 1;
			} else if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 17;
				return 1;
			}
			return 0;
		case 17:
			if(($c == ';')) {
				STATE = 2;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 18;
				return 1;
			} else if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 17;
				return 1;
			}
			return 0;
		case 18:
			if(($c == ';')) {
				STATE = 2;
				return 1;
			} else if($c >= 0) {
				STATE = 18;
				return 1;
			}
			return 0;
		case 6:
			if((__l__ && $c == 'i')) {
				LOOKAHEAD($c);
				STATE = 19;
				return 1;
			}
			return 0;
		case 19:
			if((__l__ && $c == 'g')) {
				LOOKAHEAD($c);
				STATE = 20;
				return 1;
			}
			return 0;
		case 20:
			if((__l__ && $c == 'h')) {
				LOOKAHEAD($c);
				STATE = 21;
				return 1;
			}
			return 0;
		case 21:
			if((__l__ && $c == 't')) {
				LOOKAHEAD($c);
				STATE = 22;
				return 1;
			}
			return 0;
		case 22:
			if(($c >= 0 && $c <= '@') || ($c >= '[' && $c <= '`') || ($c >= '{' && $c <= 169) || ($c >= 171 && $c <= 180) || ($c >= 182 && $c <= 185) || ($c >= 187 && $c <= 191) || ($c == 215) || ($c == 247) || ($c >= 706 && $c <= 709) || ($c >= 722 && $c <= 735) || ($c >= 741 && $c <= 747) || ($c == 749) || ($c >= 751 && $c <= 879) || ($c == 885) || ($c >= 888 && $c <= 889) || ($c >= 894 && $c <= 901) || ($c == 903) || ($c == 907) || ($c == 909) || ($c == 930) || ($c == 1014) || ($c >= 1154 && $c <= 1161) || ($c >= 1320 && $c <= 1328) || ($c >= 1367 && $c <= 1368) || ($c >= 1370 && $c <= 1376) || ($c >= 1416 && $c <= 1487) || ($c >= 1515 && $c <= 1519) || ($c >= 1523 && $c <= 1567) || ($c >= 1611 && $c <= 1645) || ($c == 1648) || ($c == 1748) || ($c >= 1750 && $c <= 1764) || ($c >= 1767 && $c <= 1773) || ($c >= 1776 && $c <= 1785) || ($c >= 1789 && $c <= 1790) || ($c >= 1792 && $c <= 1807) || ($c == 1809) || ($c >= 1840 && $c <= 1868) || ($c >= 1958 && $c <= 1968) || ($c >= 1970 && $c <= 1993) || ($c >= 2027 && $c <= 2035) || ($c >= 2038 && $c <= 2041) || ($c >= 2043 && $c <= 2047) || ($c >= 2070 && $c <= 2073) || ($c >= 2075 && $c <= 2083) || ($c >= 2085 && $c <= 2087) || ($c >= 2089 && $c <= 2111) || ($c >= 2137 && $c <= 2307) || ($c >= 2362 && $c <= 2364) || ($c >= 2366 && $c <= 2383) || ($c >= 2385 && $c <= 2391) || ($c >= 2402 && $c <= 2416) || ($c == 2424) || ($c >= 2432 && $c <= 2436) || ($c >= 2445 && $c <= 2446) || ($c >= 2449 && $c <= 2450) || ($c == 2473) || ($c == 2481) || ($c >= 2483 && $c <= 2485) || ($c >= 2490 && $c <= 2492) || ($c >= 2494 && $c <= 2509) || ($c >= 2511 && $c <= 2523) || ($c == 2526) || ($c >= 2530 && $c <= 2543) || ($c >= 2546 && $c <= 2564) || ($c >= 2571 && $c <= 2574) || ($c >= 2577 && $c <= 2578) || ($c == 2601) || ($c == 2609) || ($c == 2612) || ($c == 2615) || ($c >= 2618 && $c <= 2648) || ($c == 2653) || ($c >= 2655 && $c <= 2673) || ($c >= 2677 && $c <= 2692) || ($c == 2702) || ($c == 2706) || ($c == 2729) || ($c == 2737) || ($c == 2740) || ($c >= 2746 && $c <= 2748) || ($c >= 2750 && $c <= 2767) || ($c >= 2769 && $c <= 2783) || ($c >= 2786 && $c <= 2820) || ($c >= 2829 && $c <= 2830) || ($c >= 2833 && $c <= 2834) || ($c == 2857) || ($c == 2865) || ($c == 2868) || ($c >= 2874 && $c <= 2876) || ($c >= 2878 && $c <= 2907) || ($c == 2910) || ($c >= 2914 && $c <= 2928) || ($c >= 2930 && $c <= 2946) || ($c == 2948) || ($c >= 2955 && $c <= 2957) || ($c == 2961) || ($c >= 2966 && $c <= 2968) || ($c == 2971) || ($c == 2973) || ($c >= 2976 && $c <= 2978) || ($c >= 2981 && $c <= 2983) || ($c >= 2987 && $c <= 2989) || ($c >= 3002 && $c <= 3023) || ($c >= 3025 && $c <= 3076) || ($c == 3085) || ($c == 3089) || ($c == 3113) || ($c == 3124) || ($c >= 3130 && $c <= 3132) || ($c >= 3134 && $c <= 3159) || ($c >= 3162 && $c <= 3167) || ($c >= 3170 && $c <= 3204) || ($c == 3213) || ($c == 3217) || ($c == 3241) || ($c == 3252) || ($c >= 3258 && $c <= 3260) || ($c >= 3262 && $c <= 3293) || ($c == 3295) || ($c >= 3298 && $c <= 3312) || ($c >= 3315 && $c <= 3332) || ($c == 3341) || ($c == 3345) || ($c >= 3387 && $c <= 3388) || ($c >= 3390 && $c <= 3405) || ($c >= 3407 && $c <= 3423) || ($c >= 3426 && $c <= 3449) || ($c >= 3456 && $c <= 3460) || ($c >= 3479 && $c <= 3481) || ($c == 3506) || ($c == 3516) || ($c >= 3518 && $c <= 3519) || ($c >= 3527 && $c <= 3584) || ($c == 3633) || ($c >= 3636 && $c <= 3647) || ($c >= 3655 && $c <= 3712) || ($c == 3715) || ($c >= 3717 && $c <= 3718) || ($c == 3721) || ($c >= 3723 && $c <= 3724) || ($c >= 3726 && $c <= 3731) || ($c == 3736) || ($c == 3744) || ($c == 3748) || ($c == 3750) || ($c >= 3752 && $c <= 3753) || ($c == 3756) || ($c == 3761) || ($c >= 3764 && $c <= 3772) || ($c >= 3774 && $c <= 3775) || ($c == 3781) || ($c >= 3783 && $c <= 3803) || ($c >= 3806 && $c <= 3839) || ($c >= 3841 && $c <= 3903) || ($c == 3912) || ($c >= 3949 && $c <= 3975) || ($c >= 3981 && $c <= 4095) || ($c >= 4139 && $c <= 4158) || ($c >= 4160 && $c <= 4175) || ($c >= 4182 && $c <= 4185) || ($c >= 4190 && $c <= 4192) || ($c >= 4194 && $c <= 4196) || ($c >= 4199 && $c <= 4205) || ($c >= 4209 && $c <= 4212) || ($c >= 4226 && $c <= 4237) || ($c >= 4239 && $c <= 4255) || ($c >= 4294 && $c <= 4303) || ($c == 4347) || ($c >= 4349 && $c <= 4351) || ($c == 4681) || ($c >= 4686 && $c <= 4687) || ($c == 4695) || ($c == 4697) || ($c >= 4702 && $c <= 4703) || ($c == 4745) || ($c >= 4750 && $c <= 4751) || ($c == 4785) || ($c >= 4790 && $c <= 4791) || ($c == 4799) || ($c == 4801) || ($c >= 4806 && $c <= 4807) || ($c == 4823) || ($c == 4881) || ($c >= 4886 && $c <= 4887) || ($c >= 4955 && $c <= 4991) || ($c >= 5008 && $c <= 5023) || ($c >= 5109 && $c <= 5120) || ($c >= 5741 && $c <= 5742) || ($c == 5760) || ($c >= 5787 && $c <= 5791) || ($c >= 5867 && $c <= 5887) || ($c == 5901) || ($c >= 5906 && $c <= 5919) || ($c >= 5938 && $c <= 5951) || ($c >= 5970 && $c <= 5983) || ($c == 5997) || ($c >= 6001 && $c <= 6015) || ($c >= 6068 && $c <= 6102) || ($c >= 6104 && $c <= 6107) || ($c >= 6109 && $c <= 6175) || ($c >= 6264 && $c <= 6271) || ($c == 6313) || ($c >= 6315 && $c <= 6319) || ($c >= 6390 && $c <= 6399) || ($c >= 6429 && $c <= 6479) || ($c >= 6510 && $c <= 6511) || ($c >= 6517 && $c <= 6527) || ($c >= 6572 && $c <= 6592) || ($c >= 6600 && $c <= 6655) || ($c >= 6679 && $c <= 6687) || ($c >= 6741 && $c <= 6822) || ($c >= 6824 && $c <= 6916) || ($c >= 6964 && $c <= 6980) || ($c >= 6988 && $c <= 7042) || ($c >= 7073 && $c <= 7085) || ($c >= 7088 && $c <= 7103) || ($c >= 7142 && $c <= 7167) || ($c >= 7204 && $c <= 7244) || ($c >= 7248 && $c <= 7257) || ($c >= 7294 && $c <= 7400) || ($c == 7405) || ($c >= 7410 && $c <= 7423) || ($c >= 7616 && $c <= 7679) || ($c >= 7958 && $c <= 7959) || ($c >= 7966 && $c <= 7967) || ($c >= 8006 && $c <= 8007) || ($c >= 8014 && $c <= 8015) || ($c == 8024) || ($c == 8026) || ($c == 8028) || ($c == 8030) || ($c >= 8062 && $c <= 8063) || ($c == 8117) || ($c == 8125) || ($c >= 8127 && $c <= 8129) || ($c == 8133) || ($c >= 8141 && $c <= 8143) || ($c >= 8148 && $c <= 8149) || ($c >= 8156 && $c <= 8159) || ($c >= 8173 && $c <= 8177) || ($c == 8181) || ($c >= 8189 && $c <= 8304) || ($c >= 8306 && $c <= 8318) || ($c >= 8320 && $c <= 8335) || ($c >= 8349 && $c <= 8449) || ($c >= 8451 && $c <= 8454) || ($c >= 8456 && $c <= 8457) || ($c == 8468) || ($c >= 8470 && $c <= 8472) || ($c >= 8478 && $c <= 8483) || ($c == 8485) || ($c == 8487) || ($c == 8489) || ($c == 8494) || ($c >= 8506 && $c <= 8507) || ($c >= 8512 && $c <= 8516) || ($c >= 8522 && $c <= 8525) || ($c >= 8527 && $c <= 8578) || ($c >= 8581 && $c <= 11263) || ($c == 11311) || ($c == 11359) || ($c >= 11493 && $c <= 11498) || ($c >= 11503 && $c <= 11519) || ($c >= 11558 && $c <= 11567) || ($c >= 11622 && $c <= 11630) || ($c >= 11632 && $c <= 11647) || ($c >= 11671 && $c <= 11679) || ($c == 11687) || ($c == 11695) || ($c == 11703) || ($c == 11711) || ($c == 11719) || ($c == 11727) || ($c == 11735) || ($c >= 11743 && $c <= 11822) || ($c >= 11824 && $c <= 12292) || ($c >= 12295 && $c <= 12336) || ($c >= 12342 && $c <= 12346) || ($c >= 12349 && $c <= 12352) || ($c >= 12439 && $c <= 12444) || ($c == 12448) || ($c == 12539) || ($c >= 12544 && $c <= 12548) || ($c >= 12590 && $c <= 12592) || ($c >= 12687 && $c <= 12703) || ($c >= 12731 && $c <= 12783) || ($c >= 12800 && $c <= 13311) || ($c >= 19894 && $c <= 19967) || ($c >= 40908 && $c <= 40959) || ($c >= 42125 && $c <= 42191) || ($c >= 42238 && $c <= 42239) || ($c >= 42509 && $c <= 42511) || ($c >= 42528 && $c <= 42537) || ($c >= 42540 && $c <= 42559) || ($c >= 42607 && $c <= 42622) || ($c >= 42648 && $c <= 42655) || ($c >= 42726 && $c <= 42774) || ($c >= 42784 && $c <= 42785) || ($c >= 42889 && $c <= 42890) || ($c == 42895) || ($c >= 42898 && $c <= 42911) || ($c >= 42922 && $c <= 43001) || ($c == 43010) || ($c == 43014) || ($c == 43019) || ($c >= 43043 && $c <= 43071) || ($c >= 43124 && $c <= 43137) || ($c >= 43188 && $c <= 43249) || ($c >= 43256 && $c <= 43258) || ($c >= 43260 && $c <= 43273) || ($c >= 43302 && $c <= 43311) || ($c >= 43335 && $c <= 43359) || ($c >= 43389 && $c <= 43395) || ($c >= 43443 && $c <= 43470) || ($c >= 43472 && $c <= 43519) || ($c >= 43561 && $c <= 43583) || ($c == 43587) || ($c >= 43596 && $c <= 43615) || ($c >= 43639 && $c <= 43641) || ($c >= 43643 && $c <= 43647) || ($c == 43696) || ($c >= 43698 && $c <= 43700) || ($c >= 43703 && $c <= 43704) || ($c >= 43710 && $c <= 43711) || ($c == 43713) || ($c >= 43715 && $c <= 43738) || ($c >= 43742 && $c <= 43776) || ($c >= 43783 && $c <= 43784) || ($c >= 43791 && $c <= 43792) || ($c >= 43799 && $c <= 43807) || ($c == 43815) || ($c >= 43823 && $c <= 43967) || ($c >= 44003 && $c <= 44031) || ($c >= 55204 && $c <= 55215) || ($c >= 55239 && $c <= 55242) || ($c >= 55292 && $c <= 63743) || ($c >= 64046 && $c <= 64047) || ($c >= 64110 && $c <= 64111) || ($c >= 64218 && $c <= 64255) || ($c >= 64263 && $c <= 64274) || ($c >= 64280 && $c <= 64284) || ($c == 64286) || ($c == 64297) || ($c == 64311) || ($c == 64317) || ($c == 64319) || ($c == 64322) || ($c == 64325) || ($c >= 64434 && $c <= 64466) || ($c >= 64830 && $c <= 64847) || ($c >= 64912 && $c <= 64913) || ($c >= 64968 && $c <= 65007) || ($c >= 65020 && $c <= 65135) || ($c == 65141) || ($c >= 65277 && $c <= 65312) || ($c >= 65339 && $c <= 65344) || ($c >= 65371 && $c <= 65381) || ($c >= 65471 && $c <= 65473) || ($c >= 65480 && $c <= 65481) || ($c >= 65488 && $c <= 65489) || ($c >= 65496 && $c <= 65497) || ($c >= 65501 && $c <= 2147483647)) {
				LOOKAHEAD_COMMIT();UNGET($c);
				STATE = 23;
				return 1;
			}
			return 0;
		case 23:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 24;
				return 1;
			}
			return 0;
		case 24:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 24;
				return 1;
			} else if(($c == ';')) {
				STATE = 2;
				return 1;
			} else if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 25;
				return 1;
			} else if(($c == '\'')) {
				STATE = 26;
				return 1;
			}
			return 0;
		case 26:
			if(($c == '\\')) {
				STATE = 27;
				return 1;
			} else if($c >= 0) {
				STATE = 28;
				return 1;
			}
			return 0;
		case 28:
			if(($c == '\'')) {
				STATE = 29;
				return 1;
			}
			return 0;
		case 29:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 24;
				return 1;
			} else if(($c == ';')) {
				STATE = 30;
				return 1;
			}
			return 0;
		case 30:
			if($c >= 0) {
				UNGET($c);
				STATE = 2;
				return 1;
			}
			return 0;
		case 27:
			if($c >= 0) {
				STATE = 28;
				return 1;
			}
			return 0;
		case 25:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 24;
				return 1;
			} else if(($c == ';')) {
				STATE = 30;
				return 1;
			} else if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 25;
				return 1;
			}
			return 0;
		case 5:
			if((__l__ && $c == 'a')) {
				LOOKAHEAD($c);
				STATE = 31;
				return 1;
			} else if((__l__ && $c == 'e')) {
				LOOKAHEAD($c);
				STATE = 32;
				return 1;
			}
			return 0;
		case 32:
			if((__l__ && $c == 'f')) {
				LOOKAHEAD($c);
				STATE = 33;
				return 1;
			}
			return 0;
		case 33:
			if((__l__ && $c == 't')) {
				LOOKAHEAD($c);
				STATE = 34;
				return 1;
			}
			return 0;
		case 34:
			if(($c >= 0 && $c <= '@') || ($c >= '[' && $c <= '`') || ($c >= '{' && $c <= 169) || ($c >= 171 && $c <= 180) || ($c >= 182 && $c <= 185) || ($c >= 187 && $c <= 191) || ($c == 215) || ($c == 247) || ($c >= 706 && $c <= 709) || ($c >= 722 && $c <= 735) || ($c >= 741 && $c <= 747) || ($c == 749) || ($c >= 751 && $c <= 879) || ($c == 885) || ($c >= 888 && $c <= 889) || ($c >= 894 && $c <= 901) || ($c == 903) || ($c == 907) || ($c == 909) || ($c == 930) || ($c == 1014) || ($c >= 1154 && $c <= 1161) || ($c >= 1320 && $c <= 1328) || ($c >= 1367 && $c <= 1368) || ($c >= 1370 && $c <= 1376) || ($c >= 1416 && $c <= 1487) || ($c >= 1515 && $c <= 1519) || ($c >= 1523 && $c <= 1567) || ($c >= 1611 && $c <= 1645) || ($c == 1648) || ($c == 1748) || ($c >= 1750 && $c <= 1764) || ($c >= 1767 && $c <= 1773) || ($c >= 1776 && $c <= 1785) || ($c >= 1789 && $c <= 1790) || ($c >= 1792 && $c <= 1807) || ($c == 1809) || ($c >= 1840 && $c <= 1868) || ($c >= 1958 && $c <= 1968) || ($c >= 1970 && $c <= 1993) || ($c >= 2027 && $c <= 2035) || ($c >= 2038 && $c <= 2041) || ($c >= 2043 && $c <= 2047) || ($c >= 2070 && $c <= 2073) || ($c >= 2075 && $c <= 2083) || ($c >= 2085 && $c <= 2087) || ($c >= 2089 && $c <= 2111) || ($c >= 2137 && $c <= 2307) || ($c >= 2362 && $c <= 2364) || ($c >= 2366 && $c <= 2383) || ($c >= 2385 && $c <= 2391) || ($c >= 2402 && $c <= 2416) || ($c == 2424) || ($c >= 2432 && $c <= 2436) || ($c >= 2445 && $c <= 2446) || ($c >= 2449 && $c <= 2450) || ($c == 2473) || ($c == 2481) || ($c >= 2483 && $c <= 2485) || ($c >= 2490 && $c <= 2492) || ($c >= 2494 && $c <= 2509) || ($c >= 2511 && $c <= 2523) || ($c == 2526) || ($c >= 2530 && $c <= 2543) || ($c >= 2546 && $c <= 2564) || ($c >= 2571 && $c <= 2574) || ($c >= 2577 && $c <= 2578) || ($c == 2601) || ($c == 2609) || ($c == 2612) || ($c == 2615) || ($c >= 2618 && $c <= 2648) || ($c == 2653) || ($c >= 2655 && $c <= 2673) || ($c >= 2677 && $c <= 2692) || ($c == 2702) || ($c == 2706) || ($c == 2729) || ($c == 2737) || ($c == 2740) || ($c >= 2746 && $c <= 2748) || ($c >= 2750 && $c <= 2767) || ($c >= 2769 && $c <= 2783) || ($c >= 2786 && $c <= 2820) || ($c >= 2829 && $c <= 2830) || ($c >= 2833 && $c <= 2834) || ($c == 2857) || ($c == 2865) || ($c == 2868) || ($c >= 2874 && $c <= 2876) || ($c >= 2878 && $c <= 2907) || ($c == 2910) || ($c >= 2914 && $c <= 2928) || ($c >= 2930 && $c <= 2946) || ($c == 2948) || ($c >= 2955 && $c <= 2957) || ($c == 2961) || ($c >= 2966 && $c <= 2968) || ($c == 2971) || ($c == 2973) || ($c >= 2976 && $c <= 2978) || ($c >= 2981 && $c <= 2983) || ($c >= 2987 && $c <= 2989) || ($c >= 3002 && $c <= 3023) || ($c >= 3025 && $c <= 3076) || ($c == 3085) || ($c == 3089) || ($c == 3113) || ($c == 3124) || ($c >= 3130 && $c <= 3132) || ($c >= 3134 && $c <= 3159) || ($c >= 3162 && $c <= 3167) || ($c >= 3170 && $c <= 3204) || ($c == 3213) || ($c == 3217) || ($c == 3241) || ($c == 3252) || ($c >= 3258 && $c <= 3260) || ($c >= 3262 && $c <= 3293) || ($c == 3295) || ($c >= 3298 && $c <= 3312) || ($c >= 3315 && $c <= 3332) || ($c == 3341) || ($c == 3345) || ($c >= 3387 && $c <= 3388) || ($c >= 3390 && $c <= 3405) || ($c >= 3407 && $c <= 3423) || ($c >= 3426 && $c <= 3449) || ($c >= 3456 && $c <= 3460) || ($c >= 3479 && $c <= 3481) || ($c == 3506) || ($c == 3516) || ($c >= 3518 && $c <= 3519) || ($c >= 3527 && $c <= 3584) || ($c == 3633) || ($c >= 3636 && $c <= 3647) || ($c >= 3655 && $c <= 3712) || ($c == 3715) || ($c >= 3717 && $c <= 3718) || ($c == 3721) || ($c >= 3723 && $c <= 3724) || ($c >= 3726 && $c <= 3731) || ($c == 3736) || ($c == 3744) || ($c == 3748) || ($c == 3750) || ($c >= 3752 && $c <= 3753) || ($c == 3756) || ($c == 3761) || ($c >= 3764 && $c <= 3772) || ($c >= 3774 && $c <= 3775) || ($c == 3781) || ($c >= 3783 && $c <= 3803) || ($c >= 3806 && $c <= 3839) || ($c >= 3841 && $c <= 3903) || ($c == 3912) || ($c >= 3949 && $c <= 3975) || ($c >= 3981 && $c <= 4095) || ($c >= 4139 && $c <= 4158) || ($c >= 4160 && $c <= 4175) || ($c >= 4182 && $c <= 4185) || ($c >= 4190 && $c <= 4192) || ($c >= 4194 && $c <= 4196) || ($c >= 4199 && $c <= 4205) || ($c >= 4209 && $c <= 4212) || ($c >= 4226 && $c <= 4237) || ($c >= 4239 && $c <= 4255) || ($c >= 4294 && $c <= 4303) || ($c == 4347) || ($c >= 4349 && $c <= 4351) || ($c == 4681) || ($c >= 4686 && $c <= 4687) || ($c == 4695) || ($c == 4697) || ($c >= 4702 && $c <= 4703) || ($c == 4745) || ($c >= 4750 && $c <= 4751) || ($c == 4785) || ($c >= 4790 && $c <= 4791) || ($c == 4799) || ($c == 4801) || ($c >= 4806 && $c <= 4807) || ($c == 4823) || ($c == 4881) || ($c >= 4886 && $c <= 4887) || ($c >= 4955 && $c <= 4991) || ($c >= 5008 && $c <= 5023) || ($c >= 5109 && $c <= 5120) || ($c >= 5741 && $c <= 5742) || ($c == 5760) || ($c >= 5787 && $c <= 5791) || ($c >= 5867 && $c <= 5887) || ($c == 5901) || ($c >= 5906 && $c <= 5919) || ($c >= 5938 && $c <= 5951) || ($c >= 5970 && $c <= 5983) || ($c == 5997) || ($c >= 6001 && $c <= 6015) || ($c >= 6068 && $c <= 6102) || ($c >= 6104 && $c <= 6107) || ($c >= 6109 && $c <= 6175) || ($c >= 6264 && $c <= 6271) || ($c == 6313) || ($c >= 6315 && $c <= 6319) || ($c >= 6390 && $c <= 6399) || ($c >= 6429 && $c <= 6479) || ($c >= 6510 && $c <= 6511) || ($c >= 6517 && $c <= 6527) || ($c >= 6572 && $c <= 6592) || ($c >= 6600 && $c <= 6655) || ($c >= 6679 && $c <= 6687) || ($c >= 6741 && $c <= 6822) || ($c >= 6824 && $c <= 6916) || ($c >= 6964 && $c <= 6980) || ($c >= 6988 && $c <= 7042) || ($c >= 7073 && $c <= 7085) || ($c >= 7088 && $c <= 7103) || ($c >= 7142 && $c <= 7167) || ($c >= 7204 && $c <= 7244) || ($c >= 7248 && $c <= 7257) || ($c >= 7294 && $c <= 7400) || ($c == 7405) || ($c >= 7410 && $c <= 7423) || ($c >= 7616 && $c <= 7679) || ($c >= 7958 && $c <= 7959) || ($c >= 7966 && $c <= 7967) || ($c >= 8006 && $c <= 8007) || ($c >= 8014 && $c <= 8015) || ($c == 8024) || ($c == 8026) || ($c == 8028) || ($c == 8030) || ($c >= 8062 && $c <= 8063) || ($c == 8117) || ($c == 8125) || ($c >= 8127 && $c <= 8129) || ($c == 8133) || ($c >= 8141 && $c <= 8143) || ($c >= 8148 && $c <= 8149) || ($c >= 8156 && $c <= 8159) || ($c >= 8173 && $c <= 8177) || ($c == 8181) || ($c >= 8189 && $c <= 8304) || ($c >= 8306 && $c <= 8318) || ($c >= 8320 && $c <= 8335) || ($c >= 8349 && $c <= 8449) || ($c >= 8451 && $c <= 8454) || ($c >= 8456 && $c <= 8457) || ($c == 8468) || ($c >= 8470 && $c <= 8472) || ($c >= 8478 && $c <= 8483) || ($c == 8485) || ($c == 8487) || ($c == 8489) || ($c == 8494) || ($c >= 8506 && $c <= 8507) || ($c >= 8512 && $c <= 8516) || ($c >= 8522 && $c <= 8525) || ($c >= 8527 && $c <= 8578) || ($c >= 8581 && $c <= 11263) || ($c == 11311) || ($c == 11359) || ($c >= 11493 && $c <= 11498) || ($c >= 11503 && $c <= 11519) || ($c >= 11558 && $c <= 11567) || ($c >= 11622 && $c <= 11630) || ($c >= 11632 && $c <= 11647) || ($c >= 11671 && $c <= 11679) || ($c == 11687) || ($c == 11695) || ($c == 11703) || ($c == 11711) || ($c == 11719) || ($c == 11727) || ($c == 11735) || ($c >= 11743 && $c <= 11822) || ($c >= 11824 && $c <= 12292) || ($c >= 12295 && $c <= 12336) || ($c >= 12342 && $c <= 12346) || ($c >= 12349 && $c <= 12352) || ($c >= 12439 && $c <= 12444) || ($c == 12448) || ($c == 12539) || ($c >= 12544 && $c <= 12548) || ($c >= 12590 && $c <= 12592) || ($c >= 12687 && $c <= 12703) || ($c >= 12731 && $c <= 12783) || ($c >= 12800 && $c <= 13311) || ($c >= 19894 && $c <= 19967) || ($c >= 40908 && $c <= 40959) || ($c >= 42125 && $c <= 42191) || ($c >= 42238 && $c <= 42239) || ($c >= 42509 && $c <= 42511) || ($c >= 42528 && $c <= 42537) || ($c >= 42540 && $c <= 42559) || ($c >= 42607 && $c <= 42622) || ($c >= 42648 && $c <= 42655) || ($c >= 42726 && $c <= 42774) || ($c >= 42784 && $c <= 42785) || ($c >= 42889 && $c <= 42890) || ($c == 42895) || ($c >= 42898 && $c <= 42911) || ($c >= 42922 && $c <= 43001) || ($c == 43010) || ($c == 43014) || ($c == 43019) || ($c >= 43043 && $c <= 43071) || ($c >= 43124 && $c <= 43137) || ($c >= 43188 && $c <= 43249) || ($c >= 43256 && $c <= 43258) || ($c >= 43260 && $c <= 43273) || ($c >= 43302 && $c <= 43311) || ($c >= 43335 && $c <= 43359) || ($c >= 43389 && $c <= 43395) || ($c >= 43443 && $c <= 43470) || ($c >= 43472 && $c <= 43519) || ($c >= 43561 && $c <= 43583) || ($c == 43587) || ($c >= 43596 && $c <= 43615) || ($c >= 43639 && $c <= 43641) || ($c >= 43643 && $c <= 43647) || ($c == 43696) || ($c >= 43698 && $c <= 43700) || ($c >= 43703 && $c <= 43704) || ($c >= 43710 && $c <= 43711) || ($c == 43713) || ($c >= 43715 && $c <= 43738) || ($c >= 43742 && $c <= 43776) || ($c >= 43783 && $c <= 43784) || ($c >= 43791 && $c <= 43792) || ($c >= 43799 && $c <= 43807) || ($c == 43815) || ($c >= 43823 && $c <= 43967) || ($c >= 44003 && $c <= 44031) || ($c >= 55204 && $c <= 55215) || ($c >= 55239 && $c <= 55242) || ($c >= 55292 && $c <= 63743) || ($c >= 64046 && $c <= 64047) || ($c >= 64110 && $c <= 64111) || ($c >= 64218 && $c <= 64255) || ($c >= 64263 && $c <= 64274) || ($c >= 64280 && $c <= 64284) || ($c == 64286) || ($c == 64297) || ($c == 64311) || ($c == 64317) || ($c == 64319) || ($c == 64322) || ($c == 64325) || ($c >= 64434 && $c <= 64466) || ($c >= 64830 && $c <= 64847) || ($c >= 64912 && $c <= 64913) || ($c >= 64968 && $c <= 65007) || ($c >= 65020 && $c <= 65135) || ($c == 65141) || ($c >= 65277 && $c <= 65312) || ($c >= 65339 && $c <= 65344) || ($c >= 65371 && $c <= 65381) || ($c >= 65471 && $c <= 65473) || ($c >= 65480 && $c <= 65481) || ($c >= 65488 && $c <= 65489) || ($c >= 65496 && $c <= 65497) || ($c >= 65501 && $c <= 2147483647)) {
				LOOKAHEAD_COMMIT();UNGET($c);
				STATE = 35;
				return 1;
			}
			return 0;
		case 35:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 24;
				return 1;
			}
			return 0;
		case 31:
			if((__l__ && $c == 'n')) {
				LOOKAHEAD($c);
				STATE = 36;
				return 1;
			}
			return 0;
		case 36:
			if((__l__ && $c == 'g')) {
				LOOKAHEAD($c);
				STATE = 37;
				return 1;
			}
			return 0;
		case 37:
			if((__l__ && $c == 'u')) {
				LOOKAHEAD($c);
				STATE = 38;
				return 1;
			}
			return 0;
		case 38:
			if((__l__ && $c == 'a')) {
				LOOKAHEAD($c);
				STATE = 39;
				return 1;
			}
			return 0;
		case 39:
			if((__l__ && $c == 'g')) {
				LOOKAHEAD($c);
				STATE = 40;
				return 1;
			}
			return 0;
		case 40:
			if((__l__ && $c == 'e')) {
				LOOKAHEAD($c);
				STATE = 41;
				return 1;
			}
			return 0;
		case 41:
			if(($c >= 0 && $c <= '@') || ($c >= '[' && $c <= '`') || ($c >= '{' && $c <= 169) || ($c >= 171 && $c <= 180) || ($c >= 182 && $c <= 185) || ($c >= 187 && $c <= 191) || ($c == 215) || ($c == 247) || ($c >= 706 && $c <= 709) || ($c >= 722 && $c <= 735) || ($c >= 741 && $c <= 747) || ($c == 749) || ($c >= 751 && $c <= 879) || ($c == 885) || ($c >= 888 && $c <= 889) || ($c >= 894 && $c <= 901) || ($c == 903) || ($c == 907) || ($c == 909) || ($c == 930) || ($c == 1014) || ($c >= 1154 && $c <= 1161) || ($c >= 1320 && $c <= 1328) || ($c >= 1367 && $c <= 1368) || ($c >= 1370 && $c <= 1376) || ($c >= 1416 && $c <= 1487) || ($c >= 1515 && $c <= 1519) || ($c >= 1523 && $c <= 1567) || ($c >= 1611 && $c <= 1645) || ($c == 1648) || ($c == 1748) || ($c >= 1750 && $c <= 1764) || ($c >= 1767 && $c <= 1773) || ($c >= 1776 && $c <= 1785) || ($c >= 1789 && $c <= 1790) || ($c >= 1792 && $c <= 1807) || ($c == 1809) || ($c >= 1840 && $c <= 1868) || ($c >= 1958 && $c <= 1968) || ($c >= 1970 && $c <= 1993) || ($c >= 2027 && $c <= 2035) || ($c >= 2038 && $c <= 2041) || ($c >= 2043 && $c <= 2047) || ($c >= 2070 && $c <= 2073) || ($c >= 2075 && $c <= 2083) || ($c >= 2085 && $c <= 2087) || ($c >= 2089 && $c <= 2111) || ($c >= 2137 && $c <= 2307) || ($c >= 2362 && $c <= 2364) || ($c >= 2366 && $c <= 2383) || ($c >= 2385 && $c <= 2391) || ($c >= 2402 && $c <= 2416) || ($c == 2424) || ($c >= 2432 && $c <= 2436) || ($c >= 2445 && $c <= 2446) || ($c >= 2449 && $c <= 2450) || ($c == 2473) || ($c == 2481) || ($c >= 2483 && $c <= 2485) || ($c >= 2490 && $c <= 2492) || ($c >= 2494 && $c <= 2509) || ($c >= 2511 && $c <= 2523) || ($c == 2526) || ($c >= 2530 && $c <= 2543) || ($c >= 2546 && $c <= 2564) || ($c >= 2571 && $c <= 2574) || ($c >= 2577 && $c <= 2578) || ($c == 2601) || ($c == 2609) || ($c == 2612) || ($c == 2615) || ($c >= 2618 && $c <= 2648) || ($c == 2653) || ($c >= 2655 && $c <= 2673) || ($c >= 2677 && $c <= 2692) || ($c == 2702) || ($c == 2706) || ($c == 2729) || ($c == 2737) || ($c == 2740) || ($c >= 2746 && $c <= 2748) || ($c >= 2750 && $c <= 2767) || ($c >= 2769 && $c <= 2783) || ($c >= 2786 && $c <= 2820) || ($c >= 2829 && $c <= 2830) || ($c >= 2833 && $c <= 2834) || ($c == 2857) || ($c == 2865) || ($c == 2868) || ($c >= 2874 && $c <= 2876) || ($c >= 2878 && $c <= 2907) || ($c == 2910) || ($c >= 2914 && $c <= 2928) || ($c >= 2930 && $c <= 2946) || ($c == 2948) || ($c >= 2955 && $c <= 2957) || ($c == 2961) || ($c >= 2966 && $c <= 2968) || ($c == 2971) || ($c == 2973) || ($c >= 2976 && $c <= 2978) || ($c >= 2981 && $c <= 2983) || ($c >= 2987 && $c <= 2989) || ($c >= 3002 && $c <= 3023) || ($c >= 3025 && $c <= 3076) || ($c == 3085) || ($c == 3089) || ($c == 3113) || ($c == 3124) || ($c >= 3130 && $c <= 3132) || ($c >= 3134 && $c <= 3159) || ($c >= 3162 && $c <= 3167) || ($c >= 3170 && $c <= 3204) || ($c == 3213) || ($c == 3217) || ($c == 3241) || ($c == 3252) || ($c >= 3258 && $c <= 3260) || ($c >= 3262 && $c <= 3293) || ($c == 3295) || ($c >= 3298 && $c <= 3312) || ($c >= 3315 && $c <= 3332) || ($c == 3341) || ($c == 3345) || ($c >= 3387 && $c <= 3388) || ($c >= 3390 && $c <= 3405) || ($c >= 3407 && $c <= 3423) || ($c >= 3426 && $c <= 3449) || ($c >= 3456 && $c <= 3460) || ($c >= 3479 && $c <= 3481) || ($c == 3506) || ($c == 3516) || ($c >= 3518 && $c <= 3519) || ($c >= 3527 && $c <= 3584) || ($c == 3633) || ($c >= 3636 && $c <= 3647) || ($c >= 3655 && $c <= 3712) || ($c == 3715) || ($c >= 3717 && $c <= 3718) || ($c == 3721) || ($c >= 3723 && $c <= 3724) || ($c >= 3726 && $c <= 3731) || ($c == 3736) || ($c == 3744) || ($c == 3748) || ($c == 3750) || ($c >= 3752 && $c <= 3753) || ($c == 3756) || ($c == 3761) || ($c >= 3764 && $c <= 3772) || ($c >= 3774 && $c <= 3775) || ($c == 3781) || ($c >= 3783 && $c <= 3803) || ($c >= 3806 && $c <= 3839) || ($c >= 3841 && $c <= 3903) || ($c == 3912) || ($c >= 3949 && $c <= 3975) || ($c >= 3981 && $c <= 4095) || ($c >= 4139 && $c <= 4158) || ($c >= 4160 && $c <= 4175) || ($c >= 4182 && $c <= 4185) || ($c >= 4190 && $c <= 4192) || ($c >= 4194 && $c <= 4196) || ($c >= 4199 && $c <= 4205) || ($c >= 4209 && $c <= 4212) || ($c >= 4226 && $c <= 4237) || ($c >= 4239 && $c <= 4255) || ($c >= 4294 && $c <= 4303) || ($c == 4347) || ($c >= 4349 && $c <= 4351) || ($c == 4681) || ($c >= 4686 && $c <= 4687) || ($c == 4695) || ($c == 4697) || ($c >= 4702 && $c <= 4703) || ($c == 4745) || ($c >= 4750 && $c <= 4751) || ($c == 4785) || ($c >= 4790 && $c <= 4791) || ($c == 4799) || ($c == 4801) || ($c >= 4806 && $c <= 4807) || ($c == 4823) || ($c == 4881) || ($c >= 4886 && $c <= 4887) || ($c >= 4955 && $c <= 4991) || ($c >= 5008 && $c <= 5023) || ($c >= 5109 && $c <= 5120) || ($c >= 5741 && $c <= 5742) || ($c == 5760) || ($c >= 5787 && $c <= 5791) || ($c >= 5867 && $c <= 5887) || ($c == 5901) || ($c >= 5906 && $c <= 5919) || ($c >= 5938 && $c <= 5951) || ($c >= 5970 && $c <= 5983) || ($c == 5997) || ($c >= 6001 && $c <= 6015) || ($c >= 6068 && $c <= 6102) || ($c >= 6104 && $c <= 6107) || ($c >= 6109 && $c <= 6175) || ($c >= 6264 && $c <= 6271) || ($c == 6313) || ($c >= 6315 && $c <= 6319) || ($c >= 6390 && $c <= 6399) || ($c >= 6429 && $c <= 6479) || ($c >= 6510 && $c <= 6511) || ($c >= 6517 && $c <= 6527) || ($c >= 6572 && $c <= 6592) || ($c >= 6600 && $c <= 6655) || ($c >= 6679 && $c <= 6687) || ($c >= 6741 && $c <= 6822) || ($c >= 6824 && $c <= 6916) || ($c >= 6964 && $c <= 6980) || ($c >= 6988 && $c <= 7042) || ($c >= 7073 && $c <= 7085) || ($c >= 7088 && $c <= 7103) || ($c >= 7142 && $c <= 7167) || ($c >= 7204 && $c <= 7244) || ($c >= 7248 && $c <= 7257) || ($c >= 7294 && $c <= 7400) || ($c == 7405) || ($c >= 7410 && $c <= 7423) || ($c >= 7616 && $c <= 7679) || ($c >= 7958 && $c <= 7959) || ($c >= 7966 && $c <= 7967) || ($c >= 8006 && $c <= 8007) || ($c >= 8014 && $c <= 8015) || ($c == 8024) || ($c == 8026) || ($c == 8028) || ($c == 8030) || ($c >= 8062 && $c <= 8063) || ($c == 8117) || ($c == 8125) || ($c >= 8127 && $c <= 8129) || ($c == 8133) || ($c >= 8141 && $c <= 8143) || ($c >= 8148 && $c <= 8149) || ($c >= 8156 && $c <= 8159) || ($c >= 8173 && $c <= 8177) || ($c == 8181) || ($c >= 8189 && $c <= 8304) || ($c >= 8306 && $c <= 8318) || ($c >= 8320 && $c <= 8335) || ($c >= 8349 && $c <= 8449) || ($c >= 8451 && $c <= 8454) || ($c >= 8456 && $c <= 8457) || ($c == 8468) || ($c >= 8470 && $c <= 8472) || ($c >= 8478 && $c <= 8483) || ($c == 8485) || ($c == 8487) || ($c == 8489) || ($c == 8494) || ($c >= 8506 && $c <= 8507) || ($c >= 8512 && $c <= 8516) || ($c >= 8522 && $c <= 8525) || ($c >= 8527 && $c <= 8578) || ($c >= 8581 && $c <= 11263) || ($c == 11311) || ($c == 11359) || ($c >= 11493 && $c <= 11498) || ($c >= 11503 && $c <= 11519) || ($c >= 11558 && $c <= 11567) || ($c >= 11622 && $c <= 11630) || ($c >= 11632 && $c <= 11647) || ($c >= 11671 && $c <= 11679) || ($c == 11687) || ($c == 11695) || ($c == 11703) || ($c == 11711) || ($c == 11719) || ($c == 11727) || ($c == 11735) || ($c >= 11743 && $c <= 11822) || ($c >= 11824 && $c <= 12292) || ($c >= 12295 && $c <= 12336) || ($c >= 12342 && $c <= 12346) || ($c >= 12349 && $c <= 12352) || ($c >= 12439 && $c <= 12444) || ($c == 12448) || ($c == 12539) || ($c >= 12544 && $c <= 12548) || ($c >= 12590 && $c <= 12592) || ($c >= 12687 && $c <= 12703) || ($c >= 12731 && $c <= 12783) || ($c >= 12800 && $c <= 13311) || ($c >= 19894 && $c <= 19967) || ($c >= 40908 && $c <= 40959) || ($c >= 42125 && $c <= 42191) || ($c >= 42238 && $c <= 42239) || ($c >= 42509 && $c <= 42511) || ($c >= 42528 && $c <= 42537) || ($c >= 42540 && $c <= 42559) || ($c >= 42607 && $c <= 42622) || ($c >= 42648 && $c <= 42655) || ($c >= 42726 && $c <= 42774) || ($c >= 42784 && $c <= 42785) || ($c >= 42889 && $c <= 42890) || ($c == 42895) || ($c >= 42898 && $c <= 42911) || ($c >= 42922 && $c <= 43001) || ($c == 43010) || ($c == 43014) || ($c == 43019) || ($c >= 43043 && $c <= 43071) || ($c >= 43124 && $c <= 43137) || ($c >= 43188 && $c <= 43249) || ($c >= 43256 && $c <= 43258) || ($c >= 43260 && $c <= 43273) || ($c >= 43302 && $c <= 43311) || ($c >= 43335 && $c <= 43359) || ($c >= 43389 && $c <= 43395) || ($c >= 43443 && $c <= 43470) || ($c >= 43472 && $c <= 43519) || ($c >= 43561 && $c <= 43583) || ($c == 43587) || ($c >= 43596 && $c <= 43615) || ($c >= 43639 && $c <= 43641) || ($c >= 43643 && $c <= 43647) || ($c == 43696) || ($c >= 43698 && $c <= 43700) || ($c >= 43703 && $c <= 43704) || ($c >= 43710 && $c <= 43711) || ($c == 43713) || ($c >= 43715 && $c <= 43738) || ($c >= 43742 && $c <= 43776) || ($c >= 43783 && $c <= 43784) || ($c >= 43791 && $c <= 43792) || ($c >= 43799 && $c <= 43807) || ($c == 43815) || ($c >= 43823 && $c <= 43967) || ($c >= 44003 && $c <= 44031) || ($c >= 55204 && $c <= 55215) || ($c >= 55239 && $c <= 55242) || ($c >= 55292 && $c <= 63743) || ($c >= 64046 && $c <= 64047) || ($c >= 64110 && $c <= 64111) || ($c >= 64218 && $c <= 64255) || ($c >= 64263 && $c <= 64274) || ($c >= 64280 && $c <= 64284) || ($c == 64286) || ($c == 64297) || ($c == 64311) || ($c == 64317) || ($c == 64319) || ($c == 64322) || ($c == 64325) || ($c >= 64434 && $c <= 64466) || ($c >= 64830 && $c <= 64847) || ($c >= 64912 && $c <= 64913) || ($c >= 64968 && $c <= 65007) || ($c >= 65020 && $c <= 65135) || ($c == 65141) || ($c >= 65277 && $c <= 65312) || ($c >= 65339 && $c <= 65344) || ($c >= 65371 && $c <= 65381) || ($c >= 65471 && $c <= 65473) || ($c >= 65480 && $c <= 65481) || ($c >= 65488 && $c <= 65489) || ($c >= 65496 && $c <= 65497) || ($c >= 65501 && $c <= 2147483647)) {
				LOOKAHEAD_COMMIT();UNGET($c);
				STATE = 42;
				return 1;
			}
			return 0;
		case 42:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 42;
				return 1;
			} else if($c >= 0) {
				STATE = 43;
				return 1;
			}
			return 0;
		case 43:
			if(($c == '\n') || ($c == 13) || ($c == ';')) {
				STATE = 2;
				return 1;
			} else if($c >= 0) {
				STATE = 43;
				return 1;
			}
			return 0;
		case 4:
			if((__l__ && $c == 'y')) {
				LOOKAHEAD($c);
				STATE = 44;
				return 1;
			} else if((__l__ && $c == 'o')) {
				LOOKAHEAD($c);
				STATE = 45;
				return 1;
			}
			return 0;
		case 45:
			if((__l__ && $c == 'k')) {
				LOOKAHEAD($c);
				STATE = 46;
				return 1;
			}
			return 0;
		case 46:
			if((__l__ && $c == 'e')) {
				LOOKAHEAD($c);
				STATE = 47;
				return 1;
			}
			return 0;
		case 47:
			if((__l__ && $c == 'n')) {
				LOOKAHEAD($c);
				STATE = 48;
				return 1;
			}
			return 0;
		case 48:
			if(($c >= 0 && $c <= '@') || ($c >= '[' && $c <= '`') || ($c >= '{' && $c <= 169) || ($c >= 171 && $c <= 180) || ($c >= 182 && $c <= 185) || ($c >= 187 && $c <= 191) || ($c == 215) || ($c == 247) || ($c >= 706 && $c <= 709) || ($c >= 722 && $c <= 735) || ($c >= 741 && $c <= 747) || ($c == 749) || ($c >= 751 && $c <= 879) || ($c == 885) || ($c >= 888 && $c <= 889) || ($c >= 894 && $c <= 901) || ($c == 903) || ($c == 907) || ($c == 909) || ($c == 930) || ($c == 1014) || ($c >= 1154 && $c <= 1161) || ($c >= 1320 && $c <= 1328) || ($c >= 1367 && $c <= 1368) || ($c >= 1370 && $c <= 1376) || ($c >= 1416 && $c <= 1487) || ($c >= 1515 && $c <= 1519) || ($c >= 1523 && $c <= 1567) || ($c >= 1611 && $c <= 1645) || ($c == 1648) || ($c == 1748) || ($c >= 1750 && $c <= 1764) || ($c >= 1767 && $c <= 1773) || ($c >= 1776 && $c <= 1785) || ($c >= 1789 && $c <= 1790) || ($c >= 1792 && $c <= 1807) || ($c == 1809) || ($c >= 1840 && $c <= 1868) || ($c >= 1958 && $c <= 1968) || ($c >= 1970 && $c <= 1993) || ($c >= 2027 && $c <= 2035) || ($c >= 2038 && $c <= 2041) || ($c >= 2043 && $c <= 2047) || ($c >= 2070 && $c <= 2073) || ($c >= 2075 && $c <= 2083) || ($c >= 2085 && $c <= 2087) || ($c >= 2089 && $c <= 2111) || ($c >= 2137 && $c <= 2307) || ($c >= 2362 && $c <= 2364) || ($c >= 2366 && $c <= 2383) || ($c >= 2385 && $c <= 2391) || ($c >= 2402 && $c <= 2416) || ($c == 2424) || ($c >= 2432 && $c <= 2436) || ($c >= 2445 && $c <= 2446) || ($c >= 2449 && $c <= 2450) || ($c == 2473) || ($c == 2481) || ($c >= 2483 && $c <= 2485) || ($c >= 2490 && $c <= 2492) || ($c >= 2494 && $c <= 2509) || ($c >= 2511 && $c <= 2523) || ($c == 2526) || ($c >= 2530 && $c <= 2543) || ($c >= 2546 && $c <= 2564) || ($c >= 2571 && $c <= 2574) || ($c >= 2577 && $c <= 2578) || ($c == 2601) || ($c == 2609) || ($c == 2612) || ($c == 2615) || ($c >= 2618 && $c <= 2648) || ($c == 2653) || ($c >= 2655 && $c <= 2673) || ($c >= 2677 && $c <= 2692) || ($c == 2702) || ($c == 2706) || ($c == 2729) || ($c == 2737) || ($c == 2740) || ($c >= 2746 && $c <= 2748) || ($c >= 2750 && $c <= 2767) || ($c >= 2769 && $c <= 2783) || ($c >= 2786 && $c <= 2820) || ($c >= 2829 && $c <= 2830) || ($c >= 2833 && $c <= 2834) || ($c == 2857) || ($c == 2865) || ($c == 2868) || ($c >= 2874 && $c <= 2876) || ($c >= 2878 && $c <= 2907) || ($c == 2910) || ($c >= 2914 && $c <= 2928) || ($c >= 2930 && $c <= 2946) || ($c == 2948) || ($c >= 2955 && $c <= 2957) || ($c == 2961) || ($c >= 2966 && $c <= 2968) || ($c == 2971) || ($c == 2973) || ($c >= 2976 && $c <= 2978) || ($c >= 2981 && $c <= 2983) || ($c >= 2987 && $c <= 2989) || ($c >= 3002 && $c <= 3023) || ($c >= 3025 && $c <= 3076) || ($c == 3085) || ($c == 3089) || ($c == 3113) || ($c == 3124) || ($c >= 3130 && $c <= 3132) || ($c >= 3134 && $c <= 3159) || ($c >= 3162 && $c <= 3167) || ($c >= 3170 && $c <= 3204) || ($c == 3213) || ($c == 3217) || ($c == 3241) || ($c == 3252) || ($c >= 3258 && $c <= 3260) || ($c >= 3262 && $c <= 3293) || ($c == 3295) || ($c >= 3298 && $c <= 3312) || ($c >= 3315 && $c <= 3332) || ($c == 3341) || ($c == 3345) || ($c >= 3387 && $c <= 3388) || ($c >= 3390 && $c <= 3405) || ($c >= 3407 && $c <= 3423) || ($c >= 3426 && $c <= 3449) || ($c >= 3456 && $c <= 3460) || ($c >= 3479 && $c <= 3481) || ($c == 3506) || ($c == 3516) || ($c >= 3518 && $c <= 3519) || ($c >= 3527 && $c <= 3584) || ($c == 3633) || ($c >= 3636 && $c <= 3647) || ($c >= 3655 && $c <= 3712) || ($c == 3715) || ($c >= 3717 && $c <= 3718) || ($c == 3721) || ($c >= 3723 && $c <= 3724) || ($c >= 3726 && $c <= 3731) || ($c == 3736) || ($c == 3744) || ($c == 3748) || ($c == 3750) || ($c >= 3752 && $c <= 3753) || ($c == 3756) || ($c == 3761) || ($c >= 3764 && $c <= 3772) || ($c >= 3774 && $c <= 3775) || ($c == 3781) || ($c >= 3783 && $c <= 3803) || ($c >= 3806 && $c <= 3839) || ($c >= 3841 && $c <= 3903) || ($c == 3912) || ($c >= 3949 && $c <= 3975) || ($c >= 3981 && $c <= 4095) || ($c >= 4139 && $c <= 4158) || ($c >= 4160 && $c <= 4175) || ($c >= 4182 && $c <= 4185) || ($c >= 4190 && $c <= 4192) || ($c >= 4194 && $c <= 4196) || ($c >= 4199 && $c <= 4205) || ($c >= 4209 && $c <= 4212) || ($c >= 4226 && $c <= 4237) || ($c >= 4239 && $c <= 4255) || ($c >= 4294 && $c <= 4303) || ($c == 4347) || ($c >= 4349 && $c <= 4351) || ($c == 4681) || ($c >= 4686 && $c <= 4687) || ($c == 4695) || ($c == 4697) || ($c >= 4702 && $c <= 4703) || ($c == 4745) || ($c >= 4750 && $c <= 4751) || ($c == 4785) || ($c >= 4790 && $c <= 4791) || ($c == 4799) || ($c == 4801) || ($c >= 4806 && $c <= 4807) || ($c == 4823) || ($c == 4881) || ($c >= 4886 && $c <= 4887) || ($c >= 4955 && $c <= 4991) || ($c >= 5008 && $c <= 5023) || ($c >= 5109 && $c <= 5120) || ($c >= 5741 && $c <= 5742) || ($c == 5760) || ($c >= 5787 && $c <= 5791) || ($c >= 5867 && $c <= 5887) || ($c == 5901) || ($c >= 5906 && $c <= 5919) || ($c >= 5938 && $c <= 5951) || ($c >= 5970 && $c <= 5983) || ($c == 5997) || ($c >= 6001 && $c <= 6015) || ($c >= 6068 && $c <= 6102) || ($c >= 6104 && $c <= 6107) || ($c >= 6109 && $c <= 6175) || ($c >= 6264 && $c <= 6271) || ($c == 6313) || ($c >= 6315 && $c <= 6319) || ($c >= 6390 && $c <= 6399) || ($c >= 6429 && $c <= 6479) || ($c >= 6510 && $c <= 6511) || ($c >= 6517 && $c <= 6527) || ($c >= 6572 && $c <= 6592) || ($c >= 6600 && $c <= 6655) || ($c >= 6679 && $c <= 6687) || ($c >= 6741 && $c <= 6822) || ($c >= 6824 && $c <= 6916) || ($c >= 6964 && $c <= 6980) || ($c >= 6988 && $c <= 7042) || ($c >= 7073 && $c <= 7085) || ($c >= 7088 && $c <= 7103) || ($c >= 7142 && $c <= 7167) || ($c >= 7204 && $c <= 7244) || ($c >= 7248 && $c <= 7257) || ($c >= 7294 && $c <= 7400) || ($c == 7405) || ($c >= 7410 && $c <= 7423) || ($c >= 7616 && $c <= 7679) || ($c >= 7958 && $c <= 7959) || ($c >= 7966 && $c <= 7967) || ($c >= 8006 && $c <= 8007) || ($c >= 8014 && $c <= 8015) || ($c == 8024) || ($c == 8026) || ($c == 8028) || ($c == 8030) || ($c >= 8062 && $c <= 8063) || ($c == 8117) || ($c == 8125) || ($c >= 8127 && $c <= 8129) || ($c == 8133) || ($c >= 8141 && $c <= 8143) || ($c >= 8148 && $c <= 8149) || ($c >= 8156 && $c <= 8159) || ($c >= 8173 && $c <= 8177) || ($c == 8181) || ($c >= 8189 && $c <= 8304) || ($c >= 8306 && $c <= 8318) || ($c >= 8320 && $c <= 8335) || ($c >= 8349 && $c <= 8449) || ($c >= 8451 && $c <= 8454) || ($c >= 8456 && $c <= 8457) || ($c == 8468) || ($c >= 8470 && $c <= 8472) || ($c >= 8478 && $c <= 8483) || ($c == 8485) || ($c == 8487) || ($c == 8489) || ($c == 8494) || ($c >= 8506 && $c <= 8507) || ($c >= 8512 && $c <= 8516) || ($c >= 8522 && $c <= 8525) || ($c >= 8527 && $c <= 8578) || ($c >= 8581 && $c <= 11263) || ($c == 11311) || ($c == 11359) || ($c >= 11493 && $c <= 11498) || ($c >= 11503 && $c <= 11519) || ($c >= 11558 && $c <= 11567) || ($c >= 11622 && $c <= 11630) || ($c >= 11632 && $c <= 11647) || ($c >= 11671 && $c <= 11679) || ($c == 11687) || ($c == 11695) || ($c == 11703) || ($c == 11711) || ($c == 11719) || ($c == 11727) || ($c == 11735) || ($c >= 11743 && $c <= 11822) || ($c >= 11824 && $c <= 12292) || ($c >= 12295 && $c <= 12336) || ($c >= 12342 && $c <= 12346) || ($c >= 12349 && $c <= 12352) || ($c >= 12439 && $c <= 12444) || ($c == 12448) || ($c == 12539) || ($c >= 12544 && $c <= 12548) || ($c >= 12590 && $c <= 12592) || ($c >= 12687 && $c <= 12703) || ($c >= 12731 && $c <= 12783) || ($c >= 12800 && $c <= 13311) || ($c >= 19894 && $c <= 19967) || ($c >= 40908 && $c <= 40959) || ($c >= 42125 && $c <= 42191) || ($c >= 42238 && $c <= 42239) || ($c >= 42509 && $c <= 42511) || ($c >= 42528 && $c <= 42537) || ($c >= 42540 && $c <= 42559) || ($c >= 42607 && $c <= 42622) || ($c >= 42648 && $c <= 42655) || ($c >= 42726 && $c <= 42774) || ($c >= 42784 && $c <= 42785) || ($c >= 42889 && $c <= 42890) || ($c == 42895) || ($c >= 42898 && $c <= 42911) || ($c >= 42922 && $c <= 43001) || ($c == 43010) || ($c == 43014) || ($c == 43019) || ($c >= 43043 && $c <= 43071) || ($c >= 43124 && $c <= 43137) || ($c >= 43188 && $c <= 43249) || ($c >= 43256 && $c <= 43258) || ($c >= 43260 && $c <= 43273) || ($c >= 43302 && $c <= 43311) || ($c >= 43335 && $c <= 43359) || ($c >= 43389 && $c <= 43395) || ($c >= 43443 && $c <= 43470) || ($c >= 43472 && $c <= 43519) || ($c >= 43561 && $c <= 43583) || ($c == 43587) || ($c >= 43596 && $c <= 43615) || ($c >= 43639 && $c <= 43641) || ($c >= 43643 && $c <= 43647) || ($c == 43696) || ($c >= 43698 && $c <= 43700) || ($c >= 43703 && $c <= 43704) || ($c >= 43710 && $c <= 43711) || ($c == 43713) || ($c >= 43715 && $c <= 43738) || ($c >= 43742 && $c <= 43776) || ($c >= 43783 && $c <= 43784) || ($c >= 43791 && $c <= 43792) || ($c >= 43799 && $c <= 43807) || ($c == 43815) || ($c >= 43823 && $c <= 43967) || ($c >= 44003 && $c <= 44031) || ($c >= 55204 && $c <= 55215) || ($c >= 55239 && $c <= 55242) || ($c >= 55292 && $c <= 63743) || ($c >= 64046 && $c <= 64047) || ($c >= 64110 && $c <= 64111) || ($c >= 64218 && $c <= 64255) || ($c >= 64263 && $c <= 64274) || ($c >= 64280 && $c <= 64284) || ($c == 64286) || ($c == 64297) || ($c == 64311) || ($c == 64317) || ($c == 64319) || ($c == 64322) || ($c == 64325) || ($c >= 64434 && $c <= 64466) || ($c >= 64830 && $c <= 64847) || ($c >= 64912 && $c <= 64913) || ($c >= 64968 && $c <= 65007) || ($c >= 65020 && $c <= 65135) || ($c == 65141) || ($c >= 65277 && $c <= 65312) || ($c >= 65339 && $c <= 65344) || ($c >= 65371 && $c <= 65381) || ($c >= 65471 && $c <= 65473) || ($c >= 65480 && $c <= 65481) || ($c >= 65488 && $c <= 65489) || ($c >= 65496 && $c <= 65497) || ($c >= 65501 && $c <= 2147483647)) {
				LOOKAHEAD_COMMIT();UNGET($c);
				STATE = 49;
				return 1;
			}
			return 0;
		case 49:
			if(($c == '<')) {
				STATE = 50;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 51;
				return 1;
			}
			return 0;
		case 51:
			if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 52;
				return 1;
			} else if(($c == '<')) {
				STATE = 50;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 51;
				return 1;
			}
			return 0;
		case 52:
			if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 52;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 53;
				return 1;
			}
			return 0;
		case 53:
			if(($c == ';')) {
				STATE = 2;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 53;
				return 1;
			}
			return 0;
		case 50:
			if(($c == '>')) {
				STATE = 54;
				return 1;
			} else if($c >= 0) {
				STATE = 55;
				return 1;
			}
			return 0;
		case 55:
			if(($c == '>')) {
				STATE = 54;
				return 1;
			} else if($c >= 0) {
				STATE = 55;
				return 1;
			}
			return 0;
		case 54:
			if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 52;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 54;
				return 1;
			}
			return 0;
		case 44:
			if((__l__ && $c == 'p')) {
				LOOKAHEAD($c);
				STATE = 56;
				return 1;
			}
			return 0;
		case 56:
			if((__l__ && $c == 'e')) {
				LOOKAHEAD($c);
				STATE = 57;
				return 1;
			}
			return 0;
		case 57:
			if(($c >= 0 && $c <= '@') || ($c >= '[' && $c <= '`') || ($c >= '{' && $c <= 169) || ($c >= 171 && $c <= 180) || ($c >= 182 && $c <= 185) || ($c >= 187 && $c <= 191) || ($c == 215) || ($c == 247) || ($c >= 706 && $c <= 709) || ($c >= 722 && $c <= 735) || ($c >= 741 && $c <= 747) || ($c == 749) || ($c >= 751 && $c <= 879) || ($c == 885) || ($c >= 888 && $c <= 889) || ($c >= 894 && $c <= 901) || ($c == 903) || ($c == 907) || ($c == 909) || ($c == 930) || ($c == 1014) || ($c >= 1154 && $c <= 1161) || ($c >= 1320 && $c <= 1328) || ($c >= 1367 && $c <= 1368) || ($c >= 1370 && $c <= 1376) || ($c >= 1416 && $c <= 1487) || ($c >= 1515 && $c <= 1519) || ($c >= 1523 && $c <= 1567) || ($c >= 1611 && $c <= 1645) || ($c == 1648) || ($c == 1748) || ($c >= 1750 && $c <= 1764) || ($c >= 1767 && $c <= 1773) || ($c >= 1776 && $c <= 1785) || ($c >= 1789 && $c <= 1790) || ($c >= 1792 && $c <= 1807) || ($c == 1809) || ($c >= 1840 && $c <= 1868) || ($c >= 1958 && $c <= 1968) || ($c >= 1970 && $c <= 1993) || ($c >= 2027 && $c <= 2035) || ($c >= 2038 && $c <= 2041) || ($c >= 2043 && $c <= 2047) || ($c >= 2070 && $c <= 2073) || ($c >= 2075 && $c <= 2083) || ($c >= 2085 && $c <= 2087) || ($c >= 2089 && $c <= 2111) || ($c >= 2137 && $c <= 2307) || ($c >= 2362 && $c <= 2364) || ($c >= 2366 && $c <= 2383) || ($c >= 2385 && $c <= 2391) || ($c >= 2402 && $c <= 2416) || ($c == 2424) || ($c >= 2432 && $c <= 2436) || ($c >= 2445 && $c <= 2446) || ($c >= 2449 && $c <= 2450) || ($c == 2473) || ($c == 2481) || ($c >= 2483 && $c <= 2485) || ($c >= 2490 && $c <= 2492) || ($c >= 2494 && $c <= 2509) || ($c >= 2511 && $c <= 2523) || ($c == 2526) || ($c >= 2530 && $c <= 2543) || ($c >= 2546 && $c <= 2564) || ($c >= 2571 && $c <= 2574) || ($c >= 2577 && $c <= 2578) || ($c == 2601) || ($c == 2609) || ($c == 2612) || ($c == 2615) || ($c >= 2618 && $c <= 2648) || ($c == 2653) || ($c >= 2655 && $c <= 2673) || ($c >= 2677 && $c <= 2692) || ($c == 2702) || ($c == 2706) || ($c == 2729) || ($c == 2737) || ($c == 2740) || ($c >= 2746 && $c <= 2748) || ($c >= 2750 && $c <= 2767) || ($c >= 2769 && $c <= 2783) || ($c >= 2786 && $c <= 2820) || ($c >= 2829 && $c <= 2830) || ($c >= 2833 && $c <= 2834) || ($c == 2857) || ($c == 2865) || ($c == 2868) || ($c >= 2874 && $c <= 2876) || ($c >= 2878 && $c <= 2907) || ($c == 2910) || ($c >= 2914 && $c <= 2928) || ($c >= 2930 && $c <= 2946) || ($c == 2948) || ($c >= 2955 && $c <= 2957) || ($c == 2961) || ($c >= 2966 && $c <= 2968) || ($c == 2971) || ($c == 2973) || ($c >= 2976 && $c <= 2978) || ($c >= 2981 && $c <= 2983) || ($c >= 2987 && $c <= 2989) || ($c >= 3002 && $c <= 3023) || ($c >= 3025 && $c <= 3076) || ($c == 3085) || ($c == 3089) || ($c == 3113) || ($c == 3124) || ($c >= 3130 && $c <= 3132) || ($c >= 3134 && $c <= 3159) || ($c >= 3162 && $c <= 3167) || ($c >= 3170 && $c <= 3204) || ($c == 3213) || ($c == 3217) || ($c == 3241) || ($c == 3252) || ($c >= 3258 && $c <= 3260) || ($c >= 3262 && $c <= 3293) || ($c == 3295) || ($c >= 3298 && $c <= 3312) || ($c >= 3315 && $c <= 3332) || ($c == 3341) || ($c == 3345) || ($c >= 3387 && $c <= 3388) || ($c >= 3390 && $c <= 3405) || ($c >= 3407 && $c <= 3423) || ($c >= 3426 && $c <= 3449) || ($c >= 3456 && $c <= 3460) || ($c >= 3479 && $c <= 3481) || ($c == 3506) || ($c == 3516) || ($c >= 3518 && $c <= 3519) || ($c >= 3527 && $c <= 3584) || ($c == 3633) || ($c >= 3636 && $c <= 3647) || ($c >= 3655 && $c <= 3712) || ($c == 3715) || ($c >= 3717 && $c <= 3718) || ($c == 3721) || ($c >= 3723 && $c <= 3724) || ($c >= 3726 && $c <= 3731) || ($c == 3736) || ($c == 3744) || ($c == 3748) || ($c == 3750) || ($c >= 3752 && $c <= 3753) || ($c == 3756) || ($c == 3761) || ($c >= 3764 && $c <= 3772) || ($c >= 3774 && $c <= 3775) || ($c == 3781) || ($c >= 3783 && $c <= 3803) || ($c >= 3806 && $c <= 3839) || ($c >= 3841 && $c <= 3903) || ($c == 3912) || ($c >= 3949 && $c <= 3975) || ($c >= 3981 && $c <= 4095) || ($c >= 4139 && $c <= 4158) || ($c >= 4160 && $c <= 4175) || ($c >= 4182 && $c <= 4185) || ($c >= 4190 && $c <= 4192) || ($c >= 4194 && $c <= 4196) || ($c >= 4199 && $c <= 4205) || ($c >= 4209 && $c <= 4212) || ($c >= 4226 && $c <= 4237) || ($c >= 4239 && $c <= 4255) || ($c >= 4294 && $c <= 4303) || ($c == 4347) || ($c >= 4349 && $c <= 4351) || ($c == 4681) || ($c >= 4686 && $c <= 4687) || ($c == 4695) || ($c == 4697) || ($c >= 4702 && $c <= 4703) || ($c == 4745) || ($c >= 4750 && $c <= 4751) || ($c == 4785) || ($c >= 4790 && $c <= 4791) || ($c == 4799) || ($c == 4801) || ($c >= 4806 && $c <= 4807) || ($c == 4823) || ($c == 4881) || ($c >= 4886 && $c <= 4887) || ($c >= 4955 && $c <= 4991) || ($c >= 5008 && $c <= 5023) || ($c >= 5109 && $c <= 5120) || ($c >= 5741 && $c <= 5742) || ($c == 5760) || ($c >= 5787 && $c <= 5791) || ($c >= 5867 && $c <= 5887) || ($c == 5901) || ($c >= 5906 && $c <= 5919) || ($c >= 5938 && $c <= 5951) || ($c >= 5970 && $c <= 5983) || ($c == 5997) || ($c >= 6001 && $c <= 6015) || ($c >= 6068 && $c <= 6102) || ($c >= 6104 && $c <= 6107) || ($c >= 6109 && $c <= 6175) || ($c >= 6264 && $c <= 6271) || ($c == 6313) || ($c >= 6315 && $c <= 6319) || ($c >= 6390 && $c <= 6399) || ($c >= 6429 && $c <= 6479) || ($c >= 6510 && $c <= 6511) || ($c >= 6517 && $c <= 6527) || ($c >= 6572 && $c <= 6592) || ($c >= 6600 && $c <= 6655) || ($c >= 6679 && $c <= 6687) || ($c >= 6741 && $c <= 6822) || ($c >= 6824 && $c <= 6916) || ($c >= 6964 && $c <= 6980) || ($c >= 6988 && $c <= 7042) || ($c >= 7073 && $c <= 7085) || ($c >= 7088 && $c <= 7103) || ($c >= 7142 && $c <= 7167) || ($c >= 7204 && $c <= 7244) || ($c >= 7248 && $c <= 7257) || ($c >= 7294 && $c <= 7400) || ($c == 7405) || ($c >= 7410 && $c <= 7423) || ($c >= 7616 && $c <= 7679) || ($c >= 7958 && $c <= 7959) || ($c >= 7966 && $c <= 7967) || ($c >= 8006 && $c <= 8007) || ($c >= 8014 && $c <= 8015) || ($c == 8024) || ($c == 8026) || ($c == 8028) || ($c == 8030) || ($c >= 8062 && $c <= 8063) || ($c == 8117) || ($c == 8125) || ($c >= 8127 && $c <= 8129) || ($c == 8133) || ($c >= 8141 && $c <= 8143) || ($c >= 8148 && $c <= 8149) || ($c >= 8156 && $c <= 8159) || ($c >= 8173 && $c <= 8177) || ($c == 8181) || ($c >= 8189 && $c <= 8304) || ($c >= 8306 && $c <= 8318) || ($c >= 8320 && $c <= 8335) || ($c >= 8349 && $c <= 8449) || ($c >= 8451 && $c <= 8454) || ($c >= 8456 && $c <= 8457) || ($c == 8468) || ($c >= 8470 && $c <= 8472) || ($c >= 8478 && $c <= 8483) || ($c == 8485) || ($c == 8487) || ($c == 8489) || ($c == 8494) || ($c >= 8506 && $c <= 8507) || ($c >= 8512 && $c <= 8516) || ($c >= 8522 && $c <= 8525) || ($c >= 8527 && $c <= 8578) || ($c >= 8581 && $c <= 11263) || ($c == 11311) || ($c == 11359) || ($c >= 11493 && $c <= 11498) || ($c >= 11503 && $c <= 11519) || ($c >= 11558 && $c <= 11567) || ($c >= 11622 && $c <= 11630) || ($c >= 11632 && $c <= 11647) || ($c >= 11671 && $c <= 11679) || ($c == 11687) || ($c == 11695) || ($c == 11703) || ($c == 11711) || ($c == 11719) || ($c == 11727) || ($c == 11735) || ($c >= 11743 && $c <= 11822) || ($c >= 11824 && $c <= 12292) || ($c >= 12295 && $c <= 12336) || ($c >= 12342 && $c <= 12346) || ($c >= 12349 && $c <= 12352) || ($c >= 12439 && $c <= 12444) || ($c == 12448) || ($c == 12539) || ($c >= 12544 && $c <= 12548) || ($c >= 12590 && $c <= 12592) || ($c >= 12687 && $c <= 12703) || ($c >= 12731 && $c <= 12783) || ($c >= 12800 && $c <= 13311) || ($c >= 19894 && $c <= 19967) || ($c >= 40908 && $c <= 40959) || ($c >= 42125 && $c <= 42191) || ($c >= 42238 && $c <= 42239) || ($c >= 42509 && $c <= 42511) || ($c >= 42528 && $c <= 42537) || ($c >= 42540 && $c <= 42559) || ($c >= 42607 && $c <= 42622) || ($c >= 42648 && $c <= 42655) || ($c >= 42726 && $c <= 42774) || ($c >= 42784 && $c <= 42785) || ($c >= 42889 && $c <= 42890) || ($c == 42895) || ($c >= 42898 && $c <= 42911) || ($c >= 42922 && $c <= 43001) || ($c == 43010) || ($c == 43014) || ($c == 43019) || ($c >= 43043 && $c <= 43071) || ($c >= 43124 && $c <= 43137) || ($c >= 43188 && $c <= 43249) || ($c >= 43256 && $c <= 43258) || ($c >= 43260 && $c <= 43273) || ($c >= 43302 && $c <= 43311) || ($c >= 43335 && $c <= 43359) || ($c >= 43389 && $c <= 43395) || ($c >= 43443 && $c <= 43470) || ($c >= 43472 && $c <= 43519) || ($c >= 43561 && $c <= 43583) || ($c == 43587) || ($c >= 43596 && $c <= 43615) || ($c >= 43639 && $c <= 43641) || ($c >= 43643 && $c <= 43647) || ($c == 43696) || ($c >= 43698 && $c <= 43700) || ($c >= 43703 && $c <= 43704) || ($c >= 43710 && $c <= 43711) || ($c == 43713) || ($c >= 43715 && $c <= 43738) || ($c >= 43742 && $c <= 43776) || ($c >= 43783 && $c <= 43784) || ($c >= 43791 && $c <= 43792) || ($c >= 43799 && $c <= 43807) || ($c == 43815) || ($c >= 43823 && $c <= 43967) || ($c >= 44003 && $c <= 44031) || ($c >= 55204 && $c <= 55215) || ($c >= 55239 && $c <= 55242) || ($c >= 55292 && $c <= 63743) || ($c >= 64046 && $c <= 64047) || ($c >= 64110 && $c <= 64111) || ($c >= 64218 && $c <= 64255) || ($c >= 64263 && $c <= 64274) || ($c >= 64280 && $c <= 64284) || ($c == 64286) || ($c == 64297) || ($c == 64311) || ($c == 64317) || ($c == 64319) || ($c == 64322) || ($c == 64325) || ($c >= 64434 && $c <= 64466) || ($c >= 64830 && $c <= 64847) || ($c >= 64912 && $c <= 64913) || ($c >= 64968 && $c <= 65007) || ($c >= 65020 && $c <= 65135) || ($c == 65141) || ($c >= 65277 && $c <= 65312) || ($c >= 65339 && $c <= 65344) || ($c >= 65371 && $c <= 65381) || ($c >= 65471 && $c <= 65473) || ($c >= 65480 && $c <= 65481) || ($c >= 65488 && $c <= 65489) || ($c >= 65496 && $c <= 65497) || ($c >= 65501 && $c <= 2147483647)) {
				LOOKAHEAD_COMMIT();UNGET($c);
				STATE = 58;
				return 1;
			}
			return 0;
		case 58:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 59;
				return 1;
			} else if(($c == '<')) {
				STATE = 60;
				return 1;
			}
			return 0;
		case 60:
			if($c >= 0) {
				STATE = 61;
				return 1;
			}
			return 0;
		case 61:
			if(($c == '>')) {
				STATE = 62;
				return 1;
			} else if($c >= 0) {
				STATE = 61;
				return 1;
			}
			return 0;
		case 62:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 62;
				return 1;
			} else if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 63;
				return 1;
			}
			return 0;
		case 63:
			if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 63;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 64;
				return 1;
			}
			return 0;
		case 64:
			if(($c == ';')) {
				STATE = 2;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 64;
				return 1;
			}
			return 0;
		case 59:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 59;
				return 1;
			} else if(($c == '<')) {
				STATE = 60;
				return 1;
			}
			return 0;
		case 3:
			if((__l__ && $c == 'o')) {
				LOOKAHEAD($c);
				STATE = 65;
				return 1;
			}
			return 0;
		case 65:
			if((__l__ && $c == 'n')) {
				LOOKAHEAD($c);
				STATE = 66;
				return 1;
			}
			return 0;
		case 66:
			if((__l__ && $c == 'a')) {
				LOOKAHEAD($c);
				STATE = 67;
				return 1;
			}
			return 0;
		case 67:
			if((__l__ && $c == 's')) {
				LOOKAHEAD($c);
				STATE = 68;
				return 1;
			}
			return 0;
		case 68:
			if((__l__ && $c == 's')) {
				LOOKAHEAD($c);
				STATE = 69;
				return 1;
			}
			return 0;
		case 69:
			if((__l__ && $c == 'o')) {
				LOOKAHEAD($c);
				STATE = 70;
				return 1;
			}
			return 0;
		case 70:
			if((__l__ && $c == 'c')) {
				LOOKAHEAD($c);
				STATE = 71;
				return 1;
			}
			return 0;
		case 71:
			if(($c >= 0 && $c <= '@') || ($c >= '[' && $c <= '`') || ($c >= '{' && $c <= 169) || ($c >= 171 && $c <= 180) || ($c >= 182 && $c <= 185) || ($c >= 187 && $c <= 191) || ($c == 215) || ($c == 247) || ($c >= 706 && $c <= 709) || ($c >= 722 && $c <= 735) || ($c >= 741 && $c <= 747) || ($c == 749) || ($c >= 751 && $c <= 879) || ($c == 885) || ($c >= 888 && $c <= 889) || ($c >= 894 && $c <= 901) || ($c == 903) || ($c == 907) || ($c == 909) || ($c == 930) || ($c == 1014) || ($c >= 1154 && $c <= 1161) || ($c >= 1320 && $c <= 1328) || ($c >= 1367 && $c <= 1368) || ($c >= 1370 && $c <= 1376) || ($c >= 1416 && $c <= 1487) || ($c >= 1515 && $c <= 1519) || ($c >= 1523 && $c <= 1567) || ($c >= 1611 && $c <= 1645) || ($c == 1648) || ($c == 1748) || ($c >= 1750 && $c <= 1764) || ($c >= 1767 && $c <= 1773) || ($c >= 1776 && $c <= 1785) || ($c >= 1789 && $c <= 1790) || ($c >= 1792 && $c <= 1807) || ($c == 1809) || ($c >= 1840 && $c <= 1868) || ($c >= 1958 && $c <= 1968) || ($c >= 1970 && $c <= 1993) || ($c >= 2027 && $c <= 2035) || ($c >= 2038 && $c <= 2041) || ($c >= 2043 && $c <= 2047) || ($c >= 2070 && $c <= 2073) || ($c >= 2075 && $c <= 2083) || ($c >= 2085 && $c <= 2087) || ($c >= 2089 && $c <= 2111) || ($c >= 2137 && $c <= 2307) || ($c >= 2362 && $c <= 2364) || ($c >= 2366 && $c <= 2383) || ($c >= 2385 && $c <= 2391) || ($c >= 2402 && $c <= 2416) || ($c == 2424) || ($c >= 2432 && $c <= 2436) || ($c >= 2445 && $c <= 2446) || ($c >= 2449 && $c <= 2450) || ($c == 2473) || ($c == 2481) || ($c >= 2483 && $c <= 2485) || ($c >= 2490 && $c <= 2492) || ($c >= 2494 && $c <= 2509) || ($c >= 2511 && $c <= 2523) || ($c == 2526) || ($c >= 2530 && $c <= 2543) || ($c >= 2546 && $c <= 2564) || ($c >= 2571 && $c <= 2574) || ($c >= 2577 && $c <= 2578) || ($c == 2601) || ($c == 2609) || ($c == 2612) || ($c == 2615) || ($c >= 2618 && $c <= 2648) || ($c == 2653) || ($c >= 2655 && $c <= 2673) || ($c >= 2677 && $c <= 2692) || ($c == 2702) || ($c == 2706) || ($c == 2729) || ($c == 2737) || ($c == 2740) || ($c >= 2746 && $c <= 2748) || ($c >= 2750 && $c <= 2767) || ($c >= 2769 && $c <= 2783) || ($c >= 2786 && $c <= 2820) || ($c >= 2829 && $c <= 2830) || ($c >= 2833 && $c <= 2834) || ($c == 2857) || ($c == 2865) || ($c == 2868) || ($c >= 2874 && $c <= 2876) || ($c >= 2878 && $c <= 2907) || ($c == 2910) || ($c >= 2914 && $c <= 2928) || ($c >= 2930 && $c <= 2946) || ($c == 2948) || ($c >= 2955 && $c <= 2957) || ($c == 2961) || ($c >= 2966 && $c <= 2968) || ($c == 2971) || ($c == 2973) || ($c >= 2976 && $c <= 2978) || ($c >= 2981 && $c <= 2983) || ($c >= 2987 && $c <= 2989) || ($c >= 3002 && $c <= 3023) || ($c >= 3025 && $c <= 3076) || ($c == 3085) || ($c == 3089) || ($c == 3113) || ($c == 3124) || ($c >= 3130 && $c <= 3132) || ($c >= 3134 && $c <= 3159) || ($c >= 3162 && $c <= 3167) || ($c >= 3170 && $c <= 3204) || ($c == 3213) || ($c == 3217) || ($c == 3241) || ($c == 3252) || ($c >= 3258 && $c <= 3260) || ($c >= 3262 && $c <= 3293) || ($c == 3295) || ($c >= 3298 && $c <= 3312) || ($c >= 3315 && $c <= 3332) || ($c == 3341) || ($c == 3345) || ($c >= 3387 && $c <= 3388) || ($c >= 3390 && $c <= 3405) || ($c >= 3407 && $c <= 3423) || ($c >= 3426 && $c <= 3449) || ($c >= 3456 && $c <= 3460) || ($c >= 3479 && $c <= 3481) || ($c == 3506) || ($c == 3516) || ($c >= 3518 && $c <= 3519) || ($c >= 3527 && $c <= 3584) || ($c == 3633) || ($c >= 3636 && $c <= 3647) || ($c >= 3655 && $c <= 3712) || ($c == 3715) || ($c >= 3717 && $c <= 3718) || ($c == 3721) || ($c >= 3723 && $c <= 3724) || ($c >= 3726 && $c <= 3731) || ($c == 3736) || ($c == 3744) || ($c == 3748) || ($c == 3750) || ($c >= 3752 && $c <= 3753) || ($c == 3756) || ($c == 3761) || ($c >= 3764 && $c <= 3772) || ($c >= 3774 && $c <= 3775) || ($c == 3781) || ($c >= 3783 && $c <= 3803) || ($c >= 3806 && $c <= 3839) || ($c >= 3841 && $c <= 3903) || ($c == 3912) || ($c >= 3949 && $c <= 3975) || ($c >= 3981 && $c <= 4095) || ($c >= 4139 && $c <= 4158) || ($c >= 4160 && $c <= 4175) || ($c >= 4182 && $c <= 4185) || ($c >= 4190 && $c <= 4192) || ($c >= 4194 && $c <= 4196) || ($c >= 4199 && $c <= 4205) || ($c >= 4209 && $c <= 4212) || ($c >= 4226 && $c <= 4237) || ($c >= 4239 && $c <= 4255) || ($c >= 4294 && $c <= 4303) || ($c == 4347) || ($c >= 4349 && $c <= 4351) || ($c == 4681) || ($c >= 4686 && $c <= 4687) || ($c == 4695) || ($c == 4697) || ($c >= 4702 && $c <= 4703) || ($c == 4745) || ($c >= 4750 && $c <= 4751) || ($c == 4785) || ($c >= 4790 && $c <= 4791) || ($c == 4799) || ($c == 4801) || ($c >= 4806 && $c <= 4807) || ($c == 4823) || ($c == 4881) || ($c >= 4886 && $c <= 4887) || ($c >= 4955 && $c <= 4991) || ($c >= 5008 && $c <= 5023) || ($c >= 5109 && $c <= 5120) || ($c >= 5741 && $c <= 5742) || ($c == 5760) || ($c >= 5787 && $c <= 5791) || ($c >= 5867 && $c <= 5887) || ($c == 5901) || ($c >= 5906 && $c <= 5919) || ($c >= 5938 && $c <= 5951) || ($c >= 5970 && $c <= 5983) || ($c == 5997) || ($c >= 6001 && $c <= 6015) || ($c >= 6068 && $c <= 6102) || ($c >= 6104 && $c <= 6107) || ($c >= 6109 && $c <= 6175) || ($c >= 6264 && $c <= 6271) || ($c == 6313) || ($c >= 6315 && $c <= 6319) || ($c >= 6390 && $c <= 6399) || ($c >= 6429 && $c <= 6479) || ($c >= 6510 && $c <= 6511) || ($c >= 6517 && $c <= 6527) || ($c >= 6572 && $c <= 6592) || ($c >= 6600 && $c <= 6655) || ($c >= 6679 && $c <= 6687) || ($c >= 6741 && $c <= 6822) || ($c >= 6824 && $c <= 6916) || ($c >= 6964 && $c <= 6980) || ($c >= 6988 && $c <= 7042) || ($c >= 7073 && $c <= 7085) || ($c >= 7088 && $c <= 7103) || ($c >= 7142 && $c <= 7167) || ($c >= 7204 && $c <= 7244) || ($c >= 7248 && $c <= 7257) || ($c >= 7294 && $c <= 7400) || ($c == 7405) || ($c >= 7410 && $c <= 7423) || ($c >= 7616 && $c <= 7679) || ($c >= 7958 && $c <= 7959) || ($c >= 7966 && $c <= 7967) || ($c >= 8006 && $c <= 8007) || ($c >= 8014 && $c <= 8015) || ($c == 8024) || ($c == 8026) || ($c == 8028) || ($c == 8030) || ($c >= 8062 && $c <= 8063) || ($c == 8117) || ($c == 8125) || ($c >= 8127 && $c <= 8129) || ($c == 8133) || ($c >= 8141 && $c <= 8143) || ($c >= 8148 && $c <= 8149) || ($c >= 8156 && $c <= 8159) || ($c >= 8173 && $c <= 8177) || ($c == 8181) || ($c >= 8189 && $c <= 8304) || ($c >= 8306 && $c <= 8318) || ($c >= 8320 && $c <= 8335) || ($c >= 8349 && $c <= 8449) || ($c >= 8451 && $c <= 8454) || ($c >= 8456 && $c <= 8457) || ($c == 8468) || ($c >= 8470 && $c <= 8472) || ($c >= 8478 && $c <= 8483) || ($c == 8485) || ($c == 8487) || ($c == 8489) || ($c == 8494) || ($c >= 8506 && $c <= 8507) || ($c >= 8512 && $c <= 8516) || ($c >= 8522 && $c <= 8525) || ($c >= 8527 && $c <= 8578) || ($c >= 8581 && $c <= 11263) || ($c == 11311) || ($c == 11359) || ($c >= 11493 && $c <= 11498) || ($c >= 11503 && $c <= 11519) || ($c >= 11558 && $c <= 11567) || ($c >= 11622 && $c <= 11630) || ($c >= 11632 && $c <= 11647) || ($c >= 11671 && $c <= 11679) || ($c == 11687) || ($c == 11695) || ($c == 11703) || ($c == 11711) || ($c == 11719) || ($c == 11727) || ($c == 11735) || ($c >= 11743 && $c <= 11822) || ($c >= 11824 && $c <= 12292) || ($c >= 12295 && $c <= 12336) || ($c >= 12342 && $c <= 12346) || ($c >= 12349 && $c <= 12352) || ($c >= 12439 && $c <= 12444) || ($c == 12448) || ($c == 12539) || ($c >= 12544 && $c <= 12548) || ($c >= 12590 && $c <= 12592) || ($c >= 12687 && $c <= 12703) || ($c >= 12731 && $c <= 12783) || ($c >= 12800 && $c <= 13311) || ($c >= 19894 && $c <= 19967) || ($c >= 40908 && $c <= 40959) || ($c >= 42125 && $c <= 42191) || ($c >= 42238 && $c <= 42239) || ($c >= 42509 && $c <= 42511) || ($c >= 42528 && $c <= 42537) || ($c >= 42540 && $c <= 42559) || ($c >= 42607 && $c <= 42622) || ($c >= 42648 && $c <= 42655) || ($c >= 42726 && $c <= 42774) || ($c >= 42784 && $c <= 42785) || ($c >= 42889 && $c <= 42890) || ($c == 42895) || ($c >= 42898 && $c <= 42911) || ($c >= 42922 && $c <= 43001) || ($c == 43010) || ($c == 43014) || ($c == 43019) || ($c >= 43043 && $c <= 43071) || ($c >= 43124 && $c <= 43137) || ($c >= 43188 && $c <= 43249) || ($c >= 43256 && $c <= 43258) || ($c >= 43260 && $c <= 43273) || ($c >= 43302 && $c <= 43311) || ($c >= 43335 && $c <= 43359) || ($c >= 43389 && $c <= 43395) || ($c >= 43443 && $c <= 43470) || ($c >= 43472 && $c <= 43519) || ($c >= 43561 && $c <= 43583) || ($c == 43587) || ($c >= 43596 && $c <= 43615) || ($c >= 43639 && $c <= 43641) || ($c >= 43643 && $c <= 43647) || ($c == 43696) || ($c >= 43698 && $c <= 43700) || ($c >= 43703 && $c <= 43704) || ($c >= 43710 && $c <= 43711) || ($c == 43713) || ($c >= 43715 && $c <= 43738) || ($c >= 43742 && $c <= 43776) || ($c >= 43783 && $c <= 43784) || ($c >= 43791 && $c <= 43792) || ($c >= 43799 && $c <= 43807) || ($c == 43815) || ($c >= 43823 && $c <= 43967) || ($c >= 44003 && $c <= 44031) || ($c >= 55204 && $c <= 55215) || ($c >= 55239 && $c <= 55242) || ($c >= 55292 && $c <= 63743) || ($c >= 64046 && $c <= 64047) || ($c >= 64110 && $c <= 64111) || ($c >= 64218 && $c <= 64255) || ($c >= 64263 && $c <= 64274) || ($c >= 64280 && $c <= 64284) || ($c == 64286) || ($c == 64297) || ($c == 64311) || ($c == 64317) || ($c == 64319) || ($c == 64322) || ($c == 64325) || ($c >= 64434 && $c <= 64466) || ($c >= 64830 && $c <= 64847) || ($c >= 64912 && $c <= 64913) || ($c >= 64968 && $c <= 65007) || ($c >= 65020 && $c <= 65135) || ($c == 65141) || ($c >= 65277 && $c <= 65312) || ($c >= 65339 && $c <= 65344) || ($c >= 65371 && $c <= 65381) || ($c >= 65471 && $c <= 65473) || ($c >= 65480 && $c <= 65481) || ($c >= 65488 && $c <= 65489) || ($c >= 65496 && $c <= 65497) || ($c >= 65501 && $c <= 2147483647)) {
				LOOKAHEAD_COMMIT();UNGET($c);
				STATE = 72;
				return 1;
			}
			return 0;
		case 72:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 24;
				return 1;
			}
			return 0;
		}
		return 0;
	}

	private boolean decultureDefinition_accepted() {
		return (STATE == 0 ||
				STATE == 2);
	}

	int decultureDefinition_execaction(int  $c) {
		switch(STATE) {
		case 68:
			break;
		case 17:
			_s($c);
			break;
		case 41:
			break;
		case 52:
			_b($c);
			break;
		case 65:
			break;
		case 5:
			break;
		case 4:
			break;
		case 9:
			break;
		case 51:
			break;
		case 12:
			break;
		case 25:
			_b($c);
			break;
		case 21:
			break;
		case 71:
			break;
		case 8:
			break;
		case 13:
			break;
		case 55:
			_b($c);
			break;
		case 30:
			_pe();
			break;
		case 38:
			break;
		case 39:
			break;
		case 61:
			_b($c);
			break;
		case 47:
			break;
		case 18:
			break;
		case 14:
			break;
		case 57:
			break;
		case 6:
			break;
		case 46:
			break;
		case 43:
			lng.append((char)$c);
			break;
		case 24:
			_pa();
			break;
		case 10:
			_d($c);
			break;
		case 15:
			break;
		case 40:
			break;
		case 48:
			break;
		case 42:
			lng = new StringBuffer();
			break;
		case 1:
			break;
		case 62:
			_tp();
			break;
		case 29:
			break;
		case 69:
			break;
		case 70:
			break;
		case 11:
			break;
		case 33:
			break;
		case 54:
			_tp();
			break;
		case 56:
			break;
		case 34:
			break;
		case 58:
			_ib();
			break;
		case 63:
			_b($c);
			break;
		case 19:
			break;
		case 37:
			break;
		case 31:
			break;
		case 49:
			_ib();
			break;
		case 23:
			_ir();
			break;
		case 22:
			break;
		case 45:
			break;
		case 60:
			break;
		case 16:
			break;
		case 20:
			break;
		case 0:
			break;
		case 27:
			break;
		case 59:
			break;
		case 53:
			_pt();
			break;
		case 67:
			break;
		case 72:
			_ix();
			break;
		case 35:
			_il();
			break;
		case 66:
			break;
		case 26:
			break;
		case 3:
			break;
		case 2:
			break;
		case 36:
			break;
		case 44:
			break;
		case 32:
			break;
		case 7:
			break;
		case 64:
			_pn();
			break;
		case 50:
			break;
		case 28:
			ch = $c;
			break;
		}
		return 1;
	}

	boolean decultureDefinition_isend() {
		return false;
	}

	private final Engine ENGINE_decultureDefinition = new Engine() {

		int step(int c) throws java.io.IOException {
			return decultureDefinition_step(c);
		}

		boolean accepted() {
			return decultureDefinition_accepted();
		}

		int execaction(int c) {
			return decultureDefinition_execaction(c);
		}

		boolean isend() {
			return decultureDefinition_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 73;
		}

		int finallyState() {
			return -1;
		}

		boolean isDead() {
		return false;
		}

		boolean isEmptyTransition() {
		return false;
		}

		public String toString() {
			return "decultureDefinition";
		}

	};

	void __stkpush(int st, Engine en) {
		Object[][] c;
		Engine[] b;
		int[] a;

		if(__slen >= __sts.length) {
			a = new int[__sts.length * 2];
			b = new Engine[__stk.length * 2];
			c = new Object[__stk.length * 2][];
			System.arraycopy(__sts, 0, a, 0, __sts.length);
			System.arraycopy(__stk, 0, b, 0, __stk.length);
			System.arraycopy(__stv, 0, c, 0, __stv.length);
			__sts = a;
			__stk = b;
			__stv = c;
		}
		__sts[__slen] = st;
		__stk[__slen] = en;
		__stv[__slen++] = new Object[en.stateSize()];
	}

	private int _parse(int x, Boolean rt, boolean skip,
			int[] st) throws java.io.IOException {
		boolean b = false, p = skip;
		int c = x;
		Engine en;
		int a;

		b = __stk[__slen - 1].accepted();
		if(rt.booleanValue()) {
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_ACCEPT:
				__logprint("accept " + __stk[__slen - 1]);
				st[0] = NINA_ACCEPT;  return -1;
			case NINA_FAIL:
				__logprint("match failed: begin");
				__puttrace();
				st[0] = NINA_FAIL;  return -1;
			case NINA_HALT_ACCEPT:
				__logprint("machine halted: begin");
				st[0] = NINA_HALT_ACCEPT;  return -1;
			case NINA_HALT_REJECT:
				__logprint("machine halted: begin");
				st[0] = NINA_HALT_REJECT;  return -1;
			case NINA_YIELD:
				__logprint("machine yielded: ", c);
				st[0] = NINA_YIELD;  return -1;
			}
		}

		try {
			do {
				en = __stk[__slen - 1];
				if(p) {
					p = false;
				} else if((a = en.step(c)) > 0) {
					__logprint("transit to state " + STATE + ": ", c);
					b = en.accepted();
					switch(en.execaction(c)) {
					case NINA_ACCEPT:
						__logprint("accept " + __stk[__slen - 1]);
						UNGET(c);
						st[0] = NINA_ACCEPT;  return -1;
					case NINA_FAIL:
						__logprint("match failed: ", c);
						__puttrace();
						UNGET(c);
						st[0] = NINA_FAIL;  return -1;
					case NINA_HALT_ACCEPT:
						__logprint("machine halted: ", c);
						st[0] = NINA_HALT_ACCEPT;  return -1;
					case NINA_HALT_REJECT:
						__logprint("machine halted: ", c);
						st[0] = NINA_HALT_REJECT;  return -1;
					case NINA_YIELD:
						__logprint("machine yielded: ", c);
						st[0] = NINA_YIELD;  return -1;
					}
				} else if(a < 0) {
					__logprint("entering " + __stk[__slen - 1]);
					return c;
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					UNGET(c);
					st[0] = NINA_ACCEPT;  return -1;
				} else if(__lookaheadw_ptr >= 0) {
					__logprint("match failed: try lookahead: ", c);
					LOOKAHEAD(c);
					LOOKAHEAD_RB();
					b = en.accepted();
				} else if(c == -1) {
					if(!b)  throw new TokenException();
					st[0] = NINA_ACCEPT;
					return -1;
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					UNGET(c);
					st[0] = NINA_FAIL;  return -1;
				}

				if(__stk[__slen - 1].isEmptyTransition()) {
					// do nothing
				} else if(!__stk[__slen - 1].isDead()) {
					c = _read();
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					st[0] = NINA_ACCEPT;  return -1;
				} else if(__lookaheadw_ptr >= 0) {
					__logprint("match failed: try lookahead: ", c);
					LOOKAHEAD_RB();
					b = en.accepted();
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					st[0] = NINA_FAIL;  return -1;
				}
			} while(true);
		} catch(RuntimeException e) {
			UNGET(c);
			throw e;
		}
	}

	private Boolean execfinally() {
		int a, b;

		if((a = __stk[__slen - 1].finallyState()) >= 0) {
			b = STATE;  STATE = a;
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_HALT_ACCEPT:
				__slen = 0;
				return Boolean.TRUE;
			case NINA_HALT_REJECT:
				__slen = 0;
				return Boolean.FALSE;
			}
			STATE = b;
		}
		return null;
	}

	private int getdeadstate() {
		return __stk[__slen - 1].deadState();
	}

	private int getrecover(Exception e) {
		return __stk[__slen - 1].recover(e);
	}

	boolean parse(Engine entry) throws java.io.IOException {
		Boolean b = Boolean.FALSE;
		int[] a = new int[1];
		boolean skip = true;
		int c = 0;

		__logopen();
		try {
			if(__slen == 0) {
				b = Boolean.TRUE;
				__stkpush(0, entry);
			}

			ot: while(true) {
				try {
					if((c = _parse(c, b, skip, a)) != -1) {
						skip = false;
					} else if(a[0] == NINA_FAIL) {
						while((STATE = getdeadstate()) < 0) {
							if((b = execfinally()) != null)  break ot;
							if(__slen-- <= 1) {
								throw new TokenException();
							}
						}
						skip = true;
					} else if(a[0] == NINA_HALT_ACCEPT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.TRUE;  break;
					} else if(a[0] == NINA_HALT_REJECT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.FALSE;  break;
					} else if(a[0] == NINA_YIELD) {
						return false;
					} else if(__slen > 1) {
						if((b = execfinally()) != null)  break;
						STATE = __sts[--__slen];
						skip = true;
					} else {
						if((b = execfinally()) != null)  break;
						b = new Boolean(__stk[--__slen].accepted());
						break;
					}
				} catch(RuntimeException e) {
					exception = e;
					if(__slen <= 0)  throw e;
					while((STATE = getrecover(e)) < 0) {
						if((b = execfinally()) != null)  return b;
						if(__slen-- <= 1)  throw e;
					}
				}
				b = Boolean.TRUE;
			}
			if(!b.booleanValue())  throw new TokenException();
			return b.booleanValue();
		} finally {
			__logclose();
		}
	}

	boolean parse(java.io.Reader rd) throws java.io.IOException {
		streamStack.push(rd);
		return parse(ENGINE_decultureDefinition);
	}

	static boolean parseAll(java.io.Reader rd) throws java.io.IOException {
		DecultureDefinition o = new DecultureDefinition();

		return o.parse(rd);
	}

	void setStream(java.io.Reader rd) {
		if(streamStack.size() == 0) {
			throw new IllegalStateException();
		}
		yieldObject = rd;
		streamStack.push(rd);
	}

	Object parseNext() throws java.io.IOException {
		Object o;

		if(streamStack.size() == 0) {
			throw new IllegalStateException();
		} else if(yieldObject == null) {
			return null;
		} else if(parse(ENGINE_decultureDefinition)) {
			if(yieldObject == null)  throw new NullPointerException();
			o = yieldObject;  yieldObject = null;
			return o;
		} else {
			if(yieldObject == null)  throw new NullPointerException();
			return yieldObject;
		}
	}

	static void puts(String s) {
		System.out.println(s);
	}

	boolean parse(java.io.InputStream rd) throws java.io.IOException {
		return parse(new java.io.InputStreamReader(rd));
	}

	static boolean parseAll(
			java.io.InputStream rd) throws java.io.IOException {
		return parseAll(new java.io.InputStreamReader(rd));
	}

	/* @@@-PARSER-CODE-END-@@@ */
private Map<String, String> tokens = new HashMap<String, String>();
private Map<Terminal, Integer> priority = new HashMap<Terminal, Integer>();
private Map<Terminal, Associativity> associative = new HashMap<Terminal, Associativity>();
private Map<String, String> nttypes = new HashMap<String, String>();
private StringBuffer def = new StringBuffer();
private StringBuffer str = new StringBuffer();
private StringBuffer lng = new StringBuffer();
private StringBuffer buf;
private String tp;
private int ch, prior = 0;
private Associativity assoc;
private Map<Object, Integer> tpri;
private String language = null;

public boolean parseDefinition(java.io.Reader rd) throws java.io.IOException {
	return parse(rd);
}

public String getLanguage() {
	if(language != null) {
		// do nothing
	} else if(lng.length() > 0) {
		language = lng.toString();
	} else {
		language = "Java";
	}
	return language;
}

public String getDefinition() {
	return def.toString();
}

public String getStartSymbolName() {
	return str.toString();
}

public boolean isToken(String s) {
	return tokens.containsKey(s);
}

public Map<String, String> getTokens() {
	return Collections.unmodifiableMap(tokens);
}

public String getType(String s) {
	String t;

	if(!tokens.containsKey(s)) {
		return null;
	} else if((t = tokens.get(s)) != null) {
		return t;
	} else {
		return "Object";
	}
}

public String getNonterminalType(String s) {
	String t;

	if(!nttypes.containsKey(s)) {
		return null;
	} else if((t = nttypes.get(s)) != null) {
		return t;
	} else {
		return "Object";
	}
}

public Map<Terminal, Integer> getPriority() {
	return Collections.unmodifiableMap(priority);
}

public Map<Terminal, Associativity> getAssociativity() {
	return Collections.unmodifiableMap(associative);
}

private void _d(int c) {
	if(c >= 0)  def.appendCodePoint(c);
}

private void _s(int c) {
	if(c >= 0)  str.appendCodePoint(c);
}

private void _b(int c) {
	if(c >= 0)  buf.appendCodePoint(c);
}

private void _tp() {
	if(buf.length() > 0)  tp = buf.toString();
	buf = new StringBuffer();
}

private void _pt() {
	if(buf != null) {
		tokens.put(buf.toString(), tp);
		buf = null;
	}
}

private void _pn() {
	if(buf != null) {
		nttypes.put(buf.toString(), tp);
		buf = null;
	}
}

private void _ib() {
	buf = new StringBuffer();
	tp  = null;
	ch  = -1;
}

private void _il() {
	tpri = new HashMap<Object, Integer>();
	buf = new StringBuffer();
	ch  = -1;
	assoc = Associativity.LEFT;
}

private void _ir() {
	tpri = new HashMap<Object, Integer>();
	buf = new StringBuffer();
	ch  = -1;
	assoc = Associativity.RIGHT;
}

private void _ix() {
	tpri = new HashMap<Object, Integer>();
	buf = new StringBuffer();
	ch  = -1;
	assoc = Associativity.NONASSOC;
}

private void _pa() {
	if(ch >= 0) {
		tpri.put(Character.valueOf((char)ch), prior);
		ch  = -1;
	} else if(buf.length() > 0) {
		tpri.put(buf.toString(), prior);
		buf = new StringBuffer();
	}
}

private void _pe() {
	Terminal o;

	_pa();
	for(Map.Entry<Object, Integer> t : tpri.entrySet()) {
		if(t.getKey() instanceof Character) {
			o = new CharacterTerminal(((Character)t.getKey()).charValue());
		} else {
			o = new ConstantTerminal(t.getKey().toString());
		}
		priority.put(o, t.getValue());
		associative.put(o, assoc);
	}
	prior++;
}

}
