/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.dddsupport.basegenerator.model;

import jp.osdn.dddsupport.basegenerator.model.AbstractClass;
import jp.osdn.dddsupport.basegenerator.model.ClassName;
import jp.osdn.dddsupport.basegenerator.model.FieldName;

public class Field {
    private ClassName fieldType;
    private FieldName fieldName;
    private AbstractClass genericsType;

    protected Field() {
    }

    public Field(ClassName fieldType) {
        this.fieldType = fieldType;
        this.fieldName = fieldType.toFieldName();
    }

    public Field(ClassName fieldType, FieldName fieldName) {
        this.fieldType = fieldType;
        this.fieldName = fieldName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.fieldType);
        if (this.genericsType != null) {
            builder.append("<").append(this.genericsType.className).append(">");
        }
        builder.append(" ");
        builder.append(this.fieldName);
        return builder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected static class Builder {
        private Field field = new Field();

        public Builder fieldType(ClassName fieldTypeClass) {
            this.field.fieldType = fieldTypeClass;
            return this;
        }

        public Builder fieldName(FieldName fieldName) {
            this.field.fieldName = fieldName;
            return this;
        }

        public Builder generics(AbstractClass genericsClass) {
            this.field.genericsType = genericsClass;
            return this;
        }

        public Field build() {
            return this.field;
        }
    }
}

