#!/usr/bin/env ruby

def master_info(win, eth_num)
  win.remove(win.child)
  bindtextdomain("dcast", localedir="./locale")
  table = Gtk::Table.new(8, 3, false)

  label = Gtk::Label.new(NKF.nkf("-m0 -w", _("TThese are information on the master node. \nIf wrong, you correct it.")))
  table.attach(label, 1, 3, 0, 1)

  image_show(0, 1, 0, 7, table)

  entry_name = Gtk::Entry.new
  entry_ip = Gtk::Entry.new
  entry_network = Gtk::Entry.new
  entry_netmask = Gtk::Entry.new
  entry_bcast = Gtk::Entry.new
  entry_mac = Gtk::Entry.new

  ["NAME", "IP ADDRESS", "NETWORK", "NETMASK", "BROADCAST", "MAC ADDRESS"].each_with_index {|label, i|
    label_show(1, 2, i+1, i+2, table, label, Gtk::JUSTIFY_LEFT)
    case label
    when "NAME" then
      entry_name.set_text(hostname)
      table.attach(entry_name, 2, 3, i+1, i+2)
    when "IP ADDRESS" then
      entry_ip.set_text(get_interfaces_info("ip_address", eth_num))
      table.attach(entry_ip, 2, 3, i+1, i+2)
    when "NETWORK" then
      entry_network.set_text(get_interfaces_info("network", eth_num))
      table.attach(entry_network, 2, 3, i+1, i+2)
    when "NETMASK" then
      entry_netmask.set_text(get_interfaces_info("netmask", eth_num))
      table.attach(entry_netmask, 2, 3, i+1, i+2)
    when "BROADCAST" then
      entry_bcast.set_text(get_interfaces_info("broadcast", eth_num))
      table.attach(entry_bcast, 2, 3, i+1, i+2)
    when "MAC ADDRESS" then
      entry_mac.set_text(get_interfaces_info("mac_address", eth_num))
      table.attach(entry_mac, 2, 3, i+1, i+2)
    end
  }

  h = Hash.new
  h.store("name", entry_name)
  h.store("ip", entry_ip)
  h.store("nwork", entry_network)
  h.store("nmask", entry_netmask)
  h.store("bcast", entry_bcast)
  h.store("mac", entry_mac)
  h.store("eth", eth_num)

  $flag = "master_info"
  bottom_show(0, 3, 7, 8, win, table, h)
  win.set_title("Information of Master Node")
  win.set_default_size(500,300)
  win.add(table)
  win.show_all
end

if __FILE__ == $0
  require "libexec/load"

  Gtk.init

  win = Gtk::Window.new
  win.signal_connect("destroy") {
    Gtk::main_quit
  }

  eth_num = "eth1"
  master_info(win, eth_num)

  Gtk.main
end
