require 'fileutils'
require "libexec/nodes_class"

def disk_partition_shell(file)
  master = Nodes.new("master")

  open(file, "w"){|io|
    io.print <<"EOB"
#!/bin/sh

# This script is built diskless node
ETC=/etc/dcast
ROOTSIZE=#{master.root_size}
SWAPSIZE=#{master.swap_size}
MASTER=#{master.ip}

# Where is HDD?
HDD=""
for hdd in /dev/hd[a-d] /dev/sd[a-d]; do
  if dd if=$hdd of=/dev/null count=1 2> /dev/null; then
    HDD=$hdd
    break
   fi
done

SWAPDEVICE=$hdd"1"
ROOTDEVICE=$hdd"2"

echo "HDD is "$HDD
sleep 1

# Format Disk
echo Formatting ...
sfdisk $HDD < $ETC/zero
sfdisk $HDD < $ETC/HDD.info

# Make SWAP patrition
echo "SWAP MAKING..."
mke2fs $SWAPDEVICE
mkswap $SWAPDEVICE

# Make ROOT patrition
echo "ROOT MAKING..."
mke2fs $ROOTDEVICE
tune2fs -j -c0 -i0 $ROOTDEVICE

# Make ROOTDEVICE
mount $ROOTDEVICE /mnt

function tar_cp(){
    cp /root.tgz /mnt/
    cd /mnt
    tar xvfz root.tgz 2> /dev/null
}

function tar_cp2(){
    dd if=/root.tgz bs=16M | tar xvCfz /mnt/ - 2> /dev/null
}

echo "Copy Root Filesystem..."
tar_cp
# tar_cp2
sync

# Edit /etc/fstab
echo -e "
# /etc/fstab: static file system information.
#
# <file system>\t<mount point>\t<type>\t<options>\t<dump>\t<pass>
#------------------------------------------------------------------
$ROOTDEVICE\t/\text3\terrors=remount-ro\t0\t1
$SWAPDEVICE\tnone\tswap\tsw\t0\t0
proc\t/proc\tproc\tdefaults\t0\t0
/dev/fd0\t/floppy\tauto\tdefaults,user,noauto\t0\t0
/dev/cdrom\t/cdrom\tiso9660\tdefaults,ro,user,noauto\t0\t0
#------------------------------------------------------------------
"> /mnt/etc/fstab

# Add /etc/fstab
if [ -f /fstab ]
  then
  cat /fstab >> /mnt/etc/fstab
else
  echo -e "$MASTER:/home\\t/home\\tnfs\\trsize=32768,wsize=32768,soft,noac\\t0\\t2\\n" >> /mnt/etc/fstab
  echo -e "$MASTER:/root\\t/root\\tnfs\\trsize=32768,wsize=32768,soft,noac\\t0\\t2\\n" >> /mnt/etc/fstab
fi

# CHROOT local HD
rm /mnt/etc/init.d/dcast-nfsmount
rm /mnt/etc/rcS.d/S44dcast-nfsmount
cd
umount /mnt
mount -t ext3 $ROOTDEVICE /mnt
exec /usr/sbin/chroot /mnt /sbin/init
EOB
  }
  FileUtils.chmod(0755, file)
end

def detect_disk_shell(file)
  master = Nodes.new("master")
  open(file, "w"){|io|
    io.print <<"EOB"
#!/bin/sh

MASTER=#{master.ip}
diskflag=false

for hdd in /dev/hd[a-d] /dev/sd[a-d]; do
  if dd if=$hdd of=/dev/null count=1 2> /dev/null; then
    diskflag=true
    /etc/init.d/portmap start
    mount -t nfs $MASTER:/tftpboot/slave/ /mnt 
      if [ -f /mnt/$(hostname) ] ; then
      if [ $(head -1 /mnt/$(hostname)) == "1" ] ; then
        umount /mnt
        mount -t ext3 $hdd"2" /mnt
        exec /usr/sbin/chroot /mnt /sbin/init
        break
      elif [ $(head -1 /mnt/$(hostname)) == "0" ] ; then
        diskflag=false
        break
      fi
      fi
      umount /mnt
      break
   fi
done

case $diskflag in
   true)
      exec /etc/init.d/dcast-diskfull.sh
      ;;
   false)
      exec /sbin/init
      ;;
   esac
fi
EOB
}
  FileUtils.chmod(0755, file)
end


def write_hd_flag(file)
  master = Nodes.new("master")
  open(file, "w"){|io|
    io.print <<"EOB"
#!/bin/sh

MASTER=#{master.ip}
diskflag=false

for hdd in /dev/hd[a-d] /dev/sd[a-d]; do
  if dd if=$hdd of=/dev/null count=1 2> /dev/null; then
    diskflag=true
    break
  fi
done

mount -t nfs $MASTER:/tftpboot/slave /mnt 2> /dev/null
case $diskflag in
   true)
   if [ ! -f /mnt/$(hostname) ] ; then
     echo 1 > /mnt/$(hostname)
   fi
   ;;
   false)
   echo 0 > /mnt/$(hostname)
   ;;
esac
umount /mnt
mount -a
EOB
}
  FileUtils.chmod(0755, file)
end


def nfsroot(file)
  open(file, "w"){|io|
    io.print <<"EOB"
# tmpfs
mount -t tmpfs tmpfs /ram -o size=128m
# var
mkdir /ram/var/
cp -a /var.ro/* /ram/var

# tmp
mkdir /ram/tmp/
chmod 1777 /ram/tmp
EOB
}
  FileUtils.chmod(0755, file)
end
