#
# dcast: Hard link.

def hard_link(src, dest)
  File.makedirs(dest) unless FileTest.exist?(dest)
  Find.find(File.expand_path(src)){|path|
    if FileTest.directory?(path) && !FileTest.symlink?(path)
      stat = File.stat(path)
      FileUtils.mkdir_p(dest + path, :mode=>stat.mode)
    else
      begin
        FileUtils.ln(path, dest + path)
      rescue
        system("cp -a " + path + " " + dest + path)
      end
    end
  }
end
