#!/usr/bin/env ruby

def get_eth_num
  eth = Array.new

  io = IO.popen("/sbin/ifconfig")
  while text = io.gets do
    if /eth/ =~ text
      eth.push(text.split[0])
    end
  end
  
  return eth
end

def select_eth(win)
  win.remove(win.child)
  bindtextdomain("dcast", localedir="./locale")

  table = Gtk::Table.new(3, 2, false)

  label = Gtk::Label.new(NKF.nkf("-m0 -w", _("Select the Ethernet Number in cluster network.")))

  table.attach(label, 1, 2, 0, 1)
  image_show(0, 1, 0, 2, table)

  combo = Gtk::Combo.new()
  Array eth = get_eth_num
  combo.set_popdown_strings(eth)
  table.attach(combo, 1, 2, 1, 2, Gtk::EXPAND, Gtk::EXPAND, 0, 0)

  $flag = "select_eth"
  bottom_show(0, 2, 2, 3, win, table, combo)
  win.set_title("Configration of Eth Number in Cluster")
  win.set_default_size(500,300)
  win.add(table)
  win.show_all
end


if __FILE__ == $0
  require "libexec/load"

  Gtk.init
  
  win = Gtk::Window.new
  win.signal_connect("destroy") {
    Gtk::main_quit
  }
  
  select_eth(win)
  
  Gtk.main
end
