#
# dcast: Extracting parameters of cluster.

require 'libexec/path_class'
require 'libexec/get_master'

class Nodes
  def initialize(type)
    @eth_num = Array.new
    @name = Array.new
    @ip = Array.new
    @mac =  Array.new
    @nwork = Array.new
    @nmask = Array.new
    @bcast = Array.new
    @swap_prt="/dev/hda1"
    @swap_size=""
    @root_prt="/dev/hda2"
    @root_size="-"
    @domain=""

    filename = "./etc/dcast.conf"

    if !FileTest.exist?(filename)
      puts "No exist \"" + filename + "\". run \"./collect_mac.rb\""
      exit 1
    end

    def convert_mg(size)
      if size =~ /M$/
        tmp = size.match(/M$/)
        size = tmp.pre_match
      elsif size =~ /G$/
        tmp = size.match(/G$/)
        size = tmp.pre_match
        size = size.to_i * 1024
      end
      return size
    end

    open(filename, "r"){|io|
      while line = io.gets
        key = line.split(/=/)[0].to_s.strip
        value = line.split(/=/)[1].to_s.strip

        # ̤ͤ
        case key
        when "netmask" then
          @nmask = value.chomp
        when "network" then
          @nwork = value.chomp
        when "broadcast" then
          @bcast = value.chomp
        when "swap" then
          @swap_size = value.chomp.split(/,/)[0]
        when "domain" then
          @domain = value.chomp.gsub(/^\.*/,"")
        end
      end
    }

    path = Path.new
    if type == "all" then
      file = IO.popen("ruby dcast-parser --host --ip --mac")
      @name << hostname
      open(filename, "r"){|io|
        while line = io.gets
          key = line.split(/=/)[0].to_s.strip
          value = line.split(/=/)[1].to_s.strip
          case key
          when "ip_address"
            @ip << value.chomp
          when "eth" then
            @eth_num = value.chomp
          end
        end
      }
      @mac = get_interfaces_info("mac_address", @eth_num).to_a
      @eth_num=""

      while text = file.gets do
        @name << text.split[0]
        @ip << text.split[1]
        mac_address = ""
        text.split[2].split(/:/).each {|str|
          str = "0" + str if str.length == 1
          mac_address = mac_address + ":" + str
        }
        @mac << mac_address.sub(/:/,'')
      end
    elsif type == "slave" then
      @eth_num = "eth0"

      file = IO.popen("ruby dcast-parser --host --ip --mac")
      while text = file.gets do
        @name << text.split[0]
        @name = @name - [@master_name]
        @ip << text.split[1]
        @ip = @ip - [@master_ip]
        mac_address = ""
        text.split[2].split(/:/).each {|str|
          str = "0" + str if str.length == 1
          mac_address = mac_address + ":" + str
        }
        @mac << mac_address.sub(/:/,'')
      end
    elsif type == "master" then
      @name = hostname

      open(filename, "r"){|io|
        while line = io.gets
          key = line.split(/=/)[0].to_s.strip
          value = line.split(/=/)[1].to_s.strip
          case key
          when "eth" then
            @eth_num = value.chomp
          when "ip_address" then
            @ip = value.chomp
          end
        end
      }
      @mac = get_interfaces_info("mac_address", @eth_num).to_a
    else
      puts "host.rb Error!!"
      exit
    end
  end

  def name
    return @name
  end
  def ip
    return @ip
  end
  def eth
    return @eth_num
  end
  def nwork
    return @nwork
  end
  def nmask
    return @nmask
  end
  def bcast
    return @bcast
  end
  def domain
    return @domain
  end
  def mac
    return @mac
  end
  def swap_prt
    return @swap_prt
  end
  def swap_size
    return convert_mg(@swap_size)
  end
  def root_prt
    return @root_prt
  end
  def root_size
    return convert_mg(@root_size)
  end
end

if __FILE__ == $0
  ["slave", "master", "all"].each{|type|
    p type
    a = Nodes.new(type)
    p a.name
    p a.ip
    p a.eth
    p a.nwork
    p a.nmask
    p a.bcast
    p a.domain
    p a.mac
    p a.swap_prt
    p a.swap_size
    p a.root_prt
    p a.root_size
    puts ""
  }
end
