require "libexec/collect-mac-common"

def image_show(col_s, col_e, row_s, row_e, table) # , , table
  loader = Gdk::PixbufLoader.new
  image_file = "libexec/image/cluster.jpg"
  File.open(image_file, "rb") { |f|
    loader.last_write(f.read)
  }
  pixbuf = loader.pixbuf

  table.attach(Gtk::Image.new(pixbuf), col_s, col_e, row_s, row_e, Gtk::FILL, Gtk::FILL, 0, 0)
end

def label_show(col_s, col_e, row_s, row_e, table, str, justify) # , , table, ʸ, 
  label = Gtk::Label.new(NKF.nkf("-m0 -w", str))
  if justify != ""
    label.set_justify(justify)
  end

  table.attach(label, col_s, col_e, row_s, row_e)
end

def bottom_show(col_s, col_e, row_s, row_e, window, table, ary) # , , table, window, ary
  frame = Gtk::Frame.new("DCAST")
  hbox = Gtk::HBox.new(false, 0)

  cancel_button = Gtk::Button.new(Gtk::Stock::QUIT)
  prev_button = Gtk::Button.new(Gtk::Stock::GO_BACK)
  next_button = Gtk::Button.new(Gtk::Stock::GO_FORWARD)

  hbox.pack_start(cancel_button, false, false, 10)
  hbox.pack_end(next_button, false, false, 0)
  hbox.pack_end(prev_button, false, false, 25)

  frame.add(hbox)
  table.attach(frame, col_s, col_e, row_s, row_e)

  next_button.signal_connect("clicked") {
    case $flag
    when "first" then
      select_eth(window)
    when "select_eth" then
      # MasterΡɤͤμ
      $h.store("eth", ary.entry.text)
      $h.store("ip_address", get_interfaces_info("ip_address", $h["eth"]))
      $h.store("netmask", get_interfaces_info("netmask", $h["eth"]))
      $h.store("network", get_interfaces_info("network", $h["eth"]))
      $h.store("broadcast", get_interfaces_info("broadcast", $h["eth"]))
      # local IP Address + 1
      b = IP_Addr.new($h["netmask"], $h["ip_address"], 2)
      ip = ("%032b") % (b.ipaddr_change_10_2($h["ip_address"]).to_i(2) + 1)
      $h.store("startip", b.ipaddr_change_2_10_dot(ip))

      # ǥХåѽ
      ["eth", "ip_address", "netmask", "network", "broadcast", "startip"].each{|i|
        p i + " = " + $h[i]
      }

      cluster_info(window)
    when "cluster_info" then
      $h.store("number", ary.fetch("number").value_as_int)
      $h.store("swap", ary.fetch("swap").value_as_int)
      $h.store("prefix", ary.fetch("name").text)
      $h.store("domain", ary.fetch("domain").text)
      $h.store("start_slave_num", ary.fetch("start_slave_num").value_as_int)
      $h.store("digit", ary.fetch("digit").value_as_int)

      # ǥХåѽ
     ["number", "swap", "prefix", "domain", "start_slave_num", "digit"].each{|i|
       p i + " = " + $h[i].to_s
     }
      mac_info(window)
    when "mac_after" then
      dcast_conf_write($filename, $h)

      io = File.open($filename, "a")
      open($tmpfile, "r"){|f|
        while line = f.gets
          io.puts line
          puts line
        end
      }
      io.close

      dcast_conf_buttom_write($filename)
      run_gtk(window)
    when "mac_pre" then
      puts "Please collect MAC Address."
    else
      p $flag
      puts "Error common.rb!!"
    end
  }

  prev_button.signal_connect("clicked") {
    case $flag
    when "first" then
    when "select_eth" then
      unless FileTest.exist?($filename)
        first(window)
      else
        first_select(window)
      end
    when "cluster_info" then
      select_eth(window)
    when "mac_pre" then
      cluster_info(window)
    when "mac_after" then
      cluster_info(window)
    else
      p $flag
      puts "Error common.rb!!"
    end
  }

  cancel_button.signal_connect("clicked") {
    Gtk::main_quit
  }
end
