#
# dcast: Backup the current configration file.
# eg. /etc/hosts, /etc/pxe.conf

require 'ftools'
require 'fileutils'
require "libexec/path_class"
require "libexec/check"

def setting_files_backup(dir, files)
  path = Path.new

  check_dir_exist(dir)
  FileUtils.mkdir_p(dir) if !FileTest.exist?(dir)

  for file in files
    FileUtils.cp(file, dir) if !FileTest.exist?(dir + File.basename(file))
  end
end

def setting_files_reverse(dir, files)
  if !FileTest.exist?(dir)
    puts "Error! No exist " + dir + " directory."
    exit
  end

  files.each{|file|
    conf_file = File.join(dir ,File.basename(file))
    FileUtils.cp(conf_file, file, :verbose=>true) if FileTest.exist?(conf_file)
  }
end
