require 'fileutils'
require "nodes_class"

def disk_partition_shell(file)
  master = Nodes.new("master")

  open(file, "w"){|io|
    io.print <<"EOB"
#!/bin/sh

# This script is built diskless node
ETC=/etc/dcast
ROOTDEVICE=#{master.root_prt}
ROOTSIZE=#{master.root_size}
SWAPDEVICE=#{master.swap_prt}
SWAPSIZE=#{master.swap_size}
MASTER=#{master.ip}

# Format Disk
echo Formatting ...
sfdisk /dev/hda < $ETC/zero
sfdisk /dev/hda < $ETC/hda.out

# Make SWAP patrition
echo "SWAP MAKING..."
mke2fs $SWAPDEVICE
mkswap $SWAPDEVICE

# Make ROOT patrition
echo "ROOT MAKING..."
mke2fs $ROOTDEVICE
tune2fs -j -c0 -i0 $ROOTDEVICE

# Make ROOT
mount $ROOTDEVICE /mnt

function tar_cp(){
    cp /root.tgz /mnt/
    cd /mnt
    tar xvfz root.tgz 2> /dev/null
}

function tar_cp2(){
    dd if=/root.tgz bs=16M | tar xvCfz /mnt/ - 2> /dev/null
}

echo "Copy Root Filesystem..."
tar_cp
# tar_cp2
sync

# Edit /etc/fstab
echo -e "
# /etc/fstab: static file system information.
#
# <file system>\t<mount point>\t<type>\t<options>\t<dump>\t<pass>
#------------------------------------------------------------------
$ROOTDEVICE\t/\text3\terrors=remount-ro\t0\t1
$SWAPDEVICE\tnone\tswap\tsw\t0\t0
proc\t/proc\tproc\tdefaults\t0\t0
/dev/fd0\t/floppy\tauto\tdefaults,user,noauto\t0\t0
/dev/cdrom\t/cdrom\tiso9660\tdefaults,ro,user,noauto\t0\t0
#------------------------------------------------------------------
"> /mnt/etc/fstab

# Add /etc/fstab
if [ -f /fstab ]
  then
  cat /fstab >> /mnt/etc/fstab
else
  echo -e "$MASTER:/home\\t/home\\tnfs\\trsize=32768,wsize=32768,soft,noac\\t0\\t2\\n" >> /mnt/etc/fstab
  echo -e "$MASTER:/root\\t/root\\tnfs\\trsize=32768,wsize=32768,soft,noac\\t0\\t2\\n" >> /mnt/etc/fstab
fi

# CHROOT local HD
rm /mnt/etc/init.d/dcast-nfsmount
rm /mnt/etc/rcS.d/S46dcast-nfsmount
cd
umount /mnt
mount -t ext3 $ROOTDEVICE /mnt
exec /usr/sbin/chroot /mnt /sbin/init
EOB
  }
  FileUtils.chmod(0755, file)
end

def detect_disk_shell(file)
  master = Nodes.new("master")
  open(file, "w"){|io|
    io.print <<"EOB"
#!/bin/sh

MASTER=#{master.ip}
ROOTDEVICE=/dev/hda2
diskflag=false

for hd in /dev/hd[a-d]; do
  if dd if=$hd of=/dev/null count=1 2> /dev/null; then
    diskflag=true
    mount -t nfs $MASTER:/tftpboot/slave/ /mnt
      if [ -f /mnt/$(hostname) ] ; then
      if [ $(head -1 /mnt/$(hostname)) == "1" ] ; then
        umount /mnt
        mount -t ext3 $ROOTDEVICE /mnt
        exec /usr/sbin/chroot /mnt /sbin/init
        break
      elif [ $(head -1 /mnt/$(hostname)) == "0" ] ; then
        diskflag=false
        break
      fi
      fi
      umount /mnt
      break
   fi
done

case $diskflag in
   true)
      exec /etc/init.d/dcast-diskfull.sh
      ;;
   false)
      exec /sbin/init
      ;;
   esac
fi
EOB
}
  FileUtils.chmod(0755, file)
end


def write_hd_flag(file)
  master = Nodes.new("master")
  open(file, "w"){|io|
    io.print <<"EOB"
#!/bin/sh

MASTER=#{master.ip}
diskflag=false

for hd in /dev/hd[a-d]; do
  if dd if=$hd of=/dev/null count=1 2> /dev/null; then
    diskflag=true
    break
  fi
done

mount -t nfs $MASTER:/tftpboot/slave /mnt
case $diskflag in
   true)
   if [ ! -f /mnt/$(hostname) ] ; then
     echo 1 > /mnt/$(hostname)
   fi
   ;;
   false)
   echo 0 > /mnt/$(hostname)
   ;;
esac
umount /mnt
EOB
}
  FileUtils.chmod(0755, file)
end


def nfsroot(file)
  open(file, "w"){|io|
    io.print <<"EOB"
# tmpfs
mount -t tmpfs tmpfs /ram -o size=128m
# var
mkdir /ram/var/
cp -a /var.ro/* /ram/var

# tmp
mkdir /ram/tmp/
chmod 1777 /ram/tmp
EOB
}
  FileUtils.chmod(0755, file)
end
