/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs;

import daruma.auth.AuthenticationInfo;
import daruma.auth.PermissionManager;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.ElementName;
import daruma.wfs.ResponseInfo;
import daruma.wfs.SOAPFaultDocumentBuilder;
import daruma.wfs.WFSHandler;
import daruma.xml.URI;
import daruma.xml.handler.MispDefaultHandler;
import daruma.xml.util.XMLFormatConverter;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SOAPHandler
extends MispDefaultHandler {
    private StorageManager storage;
    private PermissionManager permissionManager;
    private boolean soapEnvelopePrinted;
    private AuthenticationInfo authInfo;

    public SOAPHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, AuthenticationInfo authInfo, StorageManager storage, PermissionManager permissionManager) {
        super(out, parser, isTopLevelHandler);
        this.storage = storage;
        this.authInfo = authInfo;
        this.permissionManager = permissionManager;
        this.soapEnvelopePrinted = false;
    }

    public void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        ElementName t = new ElementName(uri, localName);
        if (t.getNamespaceNonNull().equals(URI.SOAP_ENV)) {
            if (super.getCurrentLevel() == 1) {
                if (!t.equals(new ElementName(URI.SOAP_ENV, "Envelope"))) {
                    SAXParseException e = new SAXParseException("top level tag of SOAP shold be an \"Envelope\" tag ", super.getLocator());
                    this.printError(e);
                    throw e;
                }
                this.setResponse(new ResponseInfo(true));
                return;
            }
            if (!t.getLocalName().equals("Header") && t.getLocalName().equals("Body")) {
                // empty if block
            }
        } else {
            if (!this.hasResponse()) {
                this.setResponse(new ResponseInfo(false));
            }
            try {
                this.setMostRecentTransactionURI(this.storage.getMostRecentTransactionURI());
            }
            catch (StorageException ex) {
                throw new SAXException(ex);
            }
            super.setContentHandlerDelegator(new WFSHandler(super.getOutputStream(), super.getParser(), this.isTopLevelHandler() && super.getCurrentLevel() == 1, this.authInfo, this.storage, this.permissionManager), uri, localName, qName, attrs);
            return;
        }
    }

    public void xEndDocument() throws SAXException {
        try {
            PrintWriter out = super.getPrintWriter();
            ResponseInfo response = this.getResponse();
            if (response.headerIsOutputedP) {
                out.print(response.tailerStr);
            } else {
                String resStr = XMLFormatConverter.toString(response.document);
                out.print(resStr);
            }
            out.flush();
        }
        catch (TransformerException ex) {
            throw new SAXException(ex);
        }
    }

    public void xFatalError(SAXParseException exception) throws SAXException {
        this.printError(exception);
    }

    public void xError(SAXParseException exception) throws SAXException {
        this.printError(exception);
    }

    public void xWarning(SAXParseException exception) throws SAXException {
        this.printError(exception);
    }

    protected void printError(SAXParseException e) throws SAXException {
        try {
            XMLFormatConverter.print(new SOAPFaultDocumentBuilder(e).newDocument(), this.getOutputStream());
        }
        catch (ParserConfigurationException pe) {
            throw new SAXException(pe);
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }
}

